// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19866 $
//  $Date: 2008-01-23 14:54:04 -0500 (Wed, 23 Jan 2008) $
//  $Author: possu $

#ifndef INCLUDED_PackerTask_H
#define INCLUDED_PackerTask_H


// Rosetta headers
#include "param.h"
#include "design.h"
#include "DesignMap.h"
#include "PackerTaskResidueWeights.h"
#include "files_paths.h"
//#include "template_pack.h"

#include "pose.h"

// ObjexxFCL headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>

// Utility headers
#include <utility/vector1.hh>

// C++ headers
#include <cstdlib>
#include <cstdio>
#include <iostream>


class PackerTask{

public:

  //Constructor with Pose
  PackerTask( pose_ns::Pose const & pose );

  //Constructor with parameters
  PackerTask(
	     pose_ns::Pose const & pose,
	     std::string const & mode_in,
	     const bool make_output_file_in,
	     const FArray1D_bool & allow_repack_in
  );

  //DO NOT USE THIS CONSTRUCTOR -- THIS CONSTRUCTOR IS DISAPPEARING ASAP
  PackerTask( int, FArray1D_int const & );

  //Copy Constructor -- shouldn't be inlined
  PackerTask( PackerTask const & last_task);

  //Descructor
  ~PackerTask(){}

  //set designmap
  void set_designmap(DesignMap const & design_map_in);

  //get_designmap
  DesignMap const & get_designmap() const;
  DesignMap & get_designmap();

  //set ResidueWeightMap
  inline void set_residue_weight_map(PackerTaskResidueWeightMap const & residue_weight_map_in) {
		residue_weight_map_ = residue_weight_map_in;
	}
  inline void set_residue_weight(float const new_weight, int seqpos1, int seqpos2) {
		residue_weight_map_.set_weight(new_weight, seqpos1, seqpos2);
	}
  inline void set_residue_weight(float const new_weight, int seqpos1, int aa1, int seqpos2, int aa2) {
		residue_weight_map_.set_weight(new_weight, seqpos1, aa1, seqpos2, aa2);
	}
  //get ResidueWeightMap
  inline PackerTaskResidueWeightMap const & get_residue_weight_map() const { return residue_weight_map_; };
  inline PackerTaskResidueWeightMap & get_residue_weight_map() { return residue_weight_map_; };
  inline float get_residue_weights(int seqpos1, int aa1, int seqpos2, int aa2 ) const
	{ return residue_weight_map_.get_weight(seqpos1, aa1, seqpos2, aa2); };
	//check for empty WeightMap
	inline bool check_empty_weight_map() { return residue_weight_map_.check_empty_map(); };


  //set_mode
  void set_mode(const std::string &mode_in);

  //get_mode
  std::string const & get_mode() const;

  //set_optimize_h
  void set_optimize_h() {
    if (mode_for_packer == "optimizeH") {
      optimize_h = true;
      rotamerize_flag = false;
    }
  }

  //get_optimize_h
  inline bool get_optimize_h() const {
    return optimize_h;
  }

  inline bool rotamerizing() const {
    return ( ( get_mode() == "design" || get_mode() == "packrot" ) &&
	     (rotamerize_flag && get_make_output_file() ) );
  }

  //set_allow_repack, include param.h -- namespace param
  void set_allow_repack(FArray1DB_bool const & allow_repack_in);

  //get_allow_repack
  utility::vector1<bool> const & get_allow_repack() const;

  //set_make_output_file
  inline void set_make_output_file(const bool &make_output_file_in){
    make_output_file_for_packer = make_output_file_in;
  }

  //get_make_output_file
  inline bool get_make_output_file() const {
    return make_output_file_for_packer;
  }

  //set_nloop
  inline void set_nloop(){
    if (mode_for_packer == "optimizeH"){
      nloop = 1;
    }
    if ( mode_for_packer == "packrot" && (!make_output_file_for_packer )) {
      nloop = 1;
    }
  }

  //ja set_nloop from user input
  inline void set_nloop( int const setting ){
    nloop = setting;
  }

  //get_nloop
  inline int get_nloop() const {
    return nloop;
  }

  inline void set_perturb_ligand_rotamers( float const translation, float const rotation){
    perturb_ligand_rotamers.first=translation; perturb_ligand_rotamers.second=rotation;return;
  }

  inline void get_perturb_ligand_rotamers( float & translation, float & rotation ) const {
    translation=perturb_ligand_rotamers.first;rotation=perturb_ligand_rotamers.second;return;
  }

  inline void set_include_current(const bool & include_current_in){
    include_current_for_packer = include_current_in;
  }

  inline bool get_include_current() const{
    return include_current_for_packer;
  }

  inline void set_include_extra(const bool & include_extra_in){
    include_extra_for_packer = include_extra_in;
  }

  inline bool get_include_extra() const {
    return include_extra_for_packer;
  }

  inline void set_extra_rot(const FArray2DB_int& extra_rot_in ){
    using namespace param;
    extra_rot_for_packer = extra_rot_in;
  }

  inline FArray2D_int const & get_extra_rot() const  {
    return extra_rot_for_packer;
  }

  inline void set_extra_chi(const FArray2DB_float & extra_chi_in ){
    using namespace param;
    extra_chi_for_packer = extra_chi_in;
  }

  inline FArray2D_float const & get_extra_chi()  const {
    return extra_chi_for_packer;
  }


  inline std::string const & get_resfile_option(int const residue) const {
    return resfile_options[residue];
  }

  //setup_residues_to_vary
  void setup_residues_to_vary();

  //setup_residues_to_vary, overloading, incase forget to call the functions
  //to setup the private flags, then need to use the flags which is setup outside
  //the class.

  void setup_residues_to_vary(
			      //DesignMap design_map,
			      const std::string & mode_in,
			      const bool & optimize_h,
			      const FArray1DB_bool & allow_repack_in, // allow_reapck from outside is defined as FArray currently
			      const bool & make_output_file_in
			      );


  //get_resfile
  void load_resfile( std::string filepath = files_paths::resfile );

  void bad_resfile_flag(
			std::string const charid,
			int const seqpos,
			std::string const message = "reason not given"
			);


  //set Task
  void set_task(const std::string &mode_in,
		const bool make_output_file_in,
		const FArray1DB_bool & allow_repack_in,
		const bool include_current_in,
		bool const update_favored_residues_in = true // ja update "native" array?
		);

  //set Task
  void set_task(const std::string &mode_in,
		const bool make_output_file_in,
		const FArray1DB_bool & allow_repack_in,
		const bool include_current_in,
		const bool include_extra_in,
		const FArray2DB_int & extra_rot_in,
		const FArray2DB_float & extra_chi_in,
		const bool update_favored_residues_in = true //ja update "native" array?
		);

  int total_residue() const { return total_residue_; }

 private:
  PackerTask(); //private and unimplemented to prevent use

  // Data, Flag, currently just take the paramters from setup_residues_to_vary
  DesignMap design_map;
	PackerTaskResidueWeightMap residue_weight_map_;
  std::string mode_for_packer;
  bool optimize_h;   // if true, just optimize h positions
  bool rotamerize_flag;    // taken from the design namespace at construction
  utility::vector1<bool> allow_repack_for_packer; // FArray_1D bool in original codes
  bool make_output_file_for_packer;
  int nloop;
  // add new attributes
  std::pair< float, float> perturb_ligand_rotamers; // allow rigid_body perturbations of ligand rotamers in the packer
  bool include_current_for_packer;
  bool include_extra_for_packer;
  FArray2D_int extra_rot_for_packer;
  FArray2D_float extra_chi_for_packer;
  utility::vector1<std::string> resfile_options;

  ///////////////////////////////////////////////////////////
  //new private members use in setup_residues_to_vary
  int const total_residue_;
  FArray1D_int const res_;


  ///////////////////// internal methods ////////////////////////////////////
  // potimizeH mode
  void optimizeH_mode();

  void packrot_mode();

  void design_matrix_mode();

  void design_natrot_mode();

  void design_mutlist_mode();

  void design_inter_mode();

  void design_ligand_mode();

  void design_mode();

  void packcys_mode();

	void auto_dnaint_mode();
};

#endif   //INCLUDED_PackerTask_H


