// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12824 $
//  $Date: 2007-02-14 16:50:02 -0800 (Wed, 14 Feb 2007) $
//  $Author: johnk $

#ifndef INCLUDED_PackerTaskResidueWeight
#define INCLUDED_PackerTaskResidueWeight

#include <map>

#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray2D.hh>

// jk Class definition for PackerTaskResidueWeight
class PackerTaskResidueWeight {

private:

	bool aa_dependent;
	float weight;
	FArray2D_float aa_dep_weights;

public:

	PackerTaskResidueWeight();

	float get_resres_weight( int const aa1, int const aa2 ) const;

	inline void set_resres_weight( float const new_weight ) { weight = new_weight; };

	void set_resres_weight( float const new_weight, int const aa1, int const aa2 );

};


// jk Class definition for PackerTaskResidueWeightMap
class PackerTaskResidueWeightMap {

private:

	int numres_;
	std::map< int, PackerTaskResidueWeight > WeightMap;

	int generate_map_inx( int const seqpos1, int const seqpos2 ) const;

	void ensure_seqpos_swap( int & seqpos1, int & aa1,
													 int & seqpos2, int & aa2 ) const;

	void ensure_seqpos_swap( int & seqpos1, int & seqpos2 ) const;

public:

	inline PackerTaskResidueWeightMap() { numres_ = 0; return; };

	inline PackerTaskResidueWeightMap( int const new_numres ) { numres_ = new_numres; return; };

	inline bool check_empty_map() { return WeightMap.empty(); };

	inline void set_numres( int const new_numres ) { numres_ = new_numres; };

	bool check_for_reweighted_pair( int seqpos1, int seqpos2 ) const;

	float get_weight( int seqpos1, int aa1,
										int seqpos2, int aa2 ) const;

	void set_weight( float const new_weight, int seqpos1, int seqpos2 );

	void set_weight( float const new_weight, int seqpos1, int aa1,
									                         int seqpos2, int aa2 );

	//unsigned int dynamic_size() const; //apl -- I need to implement this function
};


#endif
