// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

//xa   Implementation for new simulated annealing routine that will optimize
//xa   a single sequence for multiple structures (Ambroggio & Kuhlman 2006)

// Rosetta Headers
#include "design.h"              // needed for conv_limit_mod
#include "files_paths.h"         // needed for reading in equiv_resfile
#include "EquivResfileReader.h"
#include "FixbbSimAnnealer.h"
#include "InteractionGraphBase.h" // needed for calling ig functions
#include "misc.h"                // needed for res_num_from_pdb_res_num_chain
#include "pack.h"                // needed for rotindex
#include "ParallelSimAnneal.h"
#include "param.h"               // needed for MAX_RES
#include "pdb.h"                 // needed for res_num_from_pdb_res_num_chain
#include "ResidueData.h"
#include "RotamerSet.h"
#include "XUtilities.cc"

// C++ Headers
#include <fstream>
#include <iostream>
#include <set>

//Utility Headers
#include <utility/basic_sys_util.hh>

namespace pack{


  ////////////////////////////////////////////////////////////////////////////////

  ParallelSimAnneal::ParallelSimAnneal(
				       const RotamerSet * p_rotamer_set,
				       FArray2DB_bool & neighborlist,
				       FArray1D_int & bestrotamer_at_seqpos,
				       float & bestenergy,
				       bool start_with_current, // start simulation with current rotamers
				       pack::InteractionGraphBase * ig,
				       FArray1DB_int & current_rot_index,
				       bool calc_rot_freq,
				       FArray1D_float & rot_freq
				       ):
    ParallelSimAnnealBase(
			  p_rotamer_set,
			  neighborlist,
			  bestrotamer_at_seqpos,
			  bestenergy,
			  start_with_current,
			  ig,
			  current_rot_index,
			  calc_rot_freq,
			  rot_freq
			  )

  {
    enforce_common_amino_acids_for_equivalent_sequence_positions();
  }

  ////////////////////////////////////////////////////////////////////////////////

  ParallelSimAnneal::~ParallelSimAnneal()
  {}

  void ParallelSimAnneal::enforce_common_amino_acids_for_equivalent_sequence_positions()
  {
    vector< list<int> > possible_common_amino_acid_lists;
    list<int> possible_common_amino_acids, possible_amino_acids_for_residue, temporary_amino_acid_list;
    list<int>::iterator list_oI_iter;

    for(unsigned int i = 0; i < equivalent_residues.size(); i++){
      possible_common_amino_acids.clear();
      for( list_oI_iter = equivalent_residues.at(i).begin(); list_oI_iter != equivalent_residues.at(i).end(); list_oI_iter++){
	possible_amino_acids_for_residue.clear();
	temporary_amino_acid_list.clear();
	if( list_oI_iter == equivalent_residues.at(i).begin() ){
	  master_sequence_map.find( * list_oI_iter )->second.return_possible_amino_acids( possible_common_amino_acids );
	}else{
	  master_sequence_map.find( * list_oI_iter )->second.return_possible_amino_acids( possible_amino_acids_for_residue );
	  set_intersection( possible_common_amino_acids.begin(), possible_common_amino_acids.end(),
			    possible_amino_acids_for_residue.begin(), possible_amino_acids_for_residue.end(),
			    inserter( temporary_amino_acid_list, temporary_amino_acid_list.begin() ) );
	  if( temporary_amino_acid_list.empty() ) utility::exit( EXIT_FAILURE, __FILE__, __LINE__); // no common amino acids
	  possible_common_amino_acids.clear();
	  possible_common_amino_acids = temporary_amino_acid_list;
	}
      }
      possible_common_amino_acid_lists.push_back( possible_common_amino_acids );
    }

    for(unsigned int i = 0; i < equivalent_residues.size(); i++)
      for( list_oI_iter = equivalent_residues.at(i).begin(); list_oI_iter != equivalent_residues.at(i).end(); list_oI_iter++)
	master_sequence_map.find( * list_oI_iter )->second.delete_possible_amino_acids_not_in_list( possible_common_amino_acid_lists.at(i) );

  }

  void ParallelSimAnneal::create_a_random_sequence()
  {
    set<int> mutated_residues;
    int aa_mutated_to = 0;
    list<int>::iterator list_oI_iter;
    std::map<int, ResidueData>::iterator intResDataMap_iter;

    for(unsigned int i = 0; i < equivalent_residues.size(); i++)
      for( list_oI_iter = equivalent_residues.at(i).begin(); list_oI_iter != equivalent_residues.at(i).end(); list_oI_iter++){
	if( list_oI_iter == equivalent_residues.at(i).begin() ){
	  master_sequence_map.find( * list_oI_iter )->second.mutate_codon();
	  master_sequence_map.find( * list_oI_iter )->second.get_curr_aa( aa_mutated_to );
	}else master_sequence_map.find( * list_oI_iter )->second.set_curr_aa( aa_mutated_to );
	mutated_residues.insert( * list_oI_iter );
      }

    for( intResDataMap_iter = master_sequence_map.begin(); intResDataMap_iter != master_sequence_map.end(); intResDataMap_iter++)
      if( mutated_residues.find( intResDataMap_iter->first ) == mutated_residues.end() ) intResDataMap_iter->second.mutate_codon();
  }

  void ParallelSimAnneal::propogate_mutations_to_equivalent_residues()
  {
    if( mutant_sequence_positions.empty() ) utility::exit( EXIT_FAILURE, __FILE__, __LINE__);

    int aa_mutated_to;
    list<int>::iterator mutant_seq_iter, equiv_seq_iter;
    list<int> additional_mutant_sequence_positions;

    for( mutant_seq_iter = mutant_sequence_positions.begin(); mutant_seq_iter != mutant_sequence_positions.end(); mutant_seq_iter++)
      for(unsigned int i = 0; i < equivalent_residues.size(); i++)
	if( * mutant_seq_iter == equivalent_residues.at(i).front() ){
	  master_sequence_map.find( * mutant_seq_iter )->second.get_curr_aa( aa_mutated_to );
	  for( equiv_seq_iter = equivalent_residues.at(i).begin(); equiv_seq_iter != equivalent_residues.at(i).end(); equiv_seq_iter++){
	    if( equiv_seq_iter != equivalent_residues.at(i).begin() ) master_sequence_map.find( * equiv_seq_iter )->second.set_curr_aa( aa_mutated_to );
	    additional_mutant_sequence_positions.push_back( * equiv_seq_iter );
	  }
	}

    mutant_sequence_positions.sort();
    additional_mutant_sequence_positions.sort();
    mutant_sequence_positions.merge( additional_mutant_sequence_positions );
    mutant_sequence_positions.unique();
  }

////////////////////////////////////////////////////////////////////////////////
/// @begin ParallelSimAnneal::run
///
/// @brief Optimize a single sequence for multiple backbones
///
/// @refrences Ambroggio & Kuhlman, JACS 2006
///
/// @authors Xavier Ambroggio
////////////////////////////////////////////////////////////////////////////////

  void ParallelSimAnneal::run()
  {
    using namespace design;
    std::cout << "Starting parallel simulated annealing\n";

    create_a_random_sequence();
    //    print_current_sequences();

    fill_rot_to_pack_for_current_sequence();

    if( rot_to_pack.empty() ) return;

    pack_set_of_rotamers();

    previous_energy = energy_of_best_run = bestenergy_;

    accept_new_sequence_from_packing_run();

    best_rotamers_ever.clear();
    for( int i = 1; i <= (int)bestrotamer_at_seqpos_.size(); i++ ) best_rotamers_ever.push_back( bestrotamer_at_seqpos_(i) );

    start_with_current_ = true;

    setup_iterations( number_of_possible_mutations() );

    for( int i = 1; i <= get_outeriterations(); i++ ){ // annealing outer loop
      setup_temperature( i );

      for( int j = 1; j <= get_inneriterations() + ( i * 200 * conv_limit_mod ); j++ ){ // inner loop for mutations

	make_a_sequential_substitution();

	propogate_mutations_to_equivalent_residues();

	add_rotamers_to_pack_for_residue_list( mutant_sequence_positions );

	add_rotamers_to_pack_for_neighbors_of_mutated_residues();

	add_current_rotamers_and_start_with_them();

	if( rot_to_pack.empty() ) continue;

	pack_set_of_rotamers();

	delta_energy = bestenergy_ - previous_energy;

	if( pass_metropolis( delta_energy ) ){
	  accept_new_sequence_from_packing_run();
	}else{
	  reject_mutations();
	}
      }
      revert_to_best_sequence();
    }
    output_best_rotamers();
  }


} //end of namespace
