// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef RESIDUE_DATA_H
#define RESIDUE_DATA_H

// C++ Headers
#include <vector>
#include <map>
#include <list>
#include <string>
#include <iostream>


  //////////////////////////////////////////////////////////////////////////////////////
  // ResidueData: Data structure to store and manipulate residue information
  //////////////////////////////////////////////////////////////////////////////////////

using namespace std;
class ResidueData
{
public:
  inline ResidueData() {}
  ResidueData( const map<int, list<int> > & possible_amino_acids_with_rotamers_input );
  static const map<string, int> CodonTable;
  static bool return_codon_for_amino_acid( const int & amino_acid_input, string & codon_output );
  static const string DNA_bases;
  static const map<int, char> AminoAcidLookup;
  static string return_reverse_complement( const string & DNA_sequence_input );
  void mutate_residue();
  void mutate_codon();
  void fill_neighbor_list( const list<int> & neighbors_input );
  void accept_aa();
  void accept_codon();
  void set_best_state();
  void accept_rot();
  void accept_residue();
  void revert_rot();
  void revert_aa();
  void revert_codon();
  void revert_residue();
  void revert_to_best_state();
  void assign_rand_rot();
  bool set_curr_aa( const int & amino_acid_input );
  bool set_curr_codon( const string & curr_codon_input );
  inline bool get_curr_codon( string & curr_codon_output )
  {
    if( curr_codon.empty() ) return false;
    else{
      curr_codon_output = curr_codon;
      return true;
    }
  }
  inline bool get_curr_aa( int & curr_aa_output )
  {
    curr_aa_output = curr_aa;
    return curr_aa;
  }
  inline bool get_best_rotamer( int & best_rot_output )
  {
    best_rot_output = best_rot;
    return best_rot;
  }
  inline bool get_current_rotamer( int & curr_rot_output )
  {
    curr_rot_output = curr_rot;
    return curr_rot;
  }
  void print_state();
  void print_amino_acid_rotamer_maps();
  void print_possible_amino_acids();
  void print_neighbors();
  inline int number_of_possible_amino_acids() { return possible_amino_acids_with_rotamers.size(); }
  bool accept_new_state( const int & new_rotamer_input );
  inline bool no_possible_rotamers() { return no_rotamers; }
  void return_possible_amino_acids( list<int> & possible_amino_acids_output );
  void return_possible_codons( list<string> & possible_codons_output );
  void return_possible_anticodons( list<string> & possible_anticodons_output );

  template< template< class, class > class Container, class AllocT >
  static bool return_reverse_complement_of_strings( const Container<string, AllocT> & sense_strings_input, Container<string, AllocT> & antisense_strings_output );

  bool return_possible_rotamers_for_amino_acid( const int & amino_acid_input, list<int> & possible_rotamers_output );
  bool return_possible_rotamers_for_current_amino_acid( list<int> & possible_rotamers_output );
  void delete_possible_amino_acids_not_in_list( const list<int> & amino_acids_input );
  void delete_possible_amino_acids_not_in_codon_list( const list<string> & codons_input );
  void delete_possible_amino_acids_not_in_anticodon_list( const list<string> & anticodons_input );
  void delete_possible_codons_not_in_codon_list( const list<string> & codons_input );
  void delete_possible_codons_not_in_anticodon_list( const list<string> & anticodons_input );
  inline void get_neighbors( list<int> & neighbors_output ) { neighbors_output = neighbors; }
  bool not_a_possible_amino_acid( const int & amino_acid_input );

private:
  int prev_aa, curr_aa;
  int prev_rot, curr_rot, best_rot;
  string prev_codon, curr_codon, best_codon;
  list<int> neighbors;
  bool only_one_possible_amino_acid;
  bool no_rotamers;
  map<int, list<int> > possible_amino_acids_with_rotamers;      // possible aa's are keys to list of associated rotamers
  list<string> possible_codons;
  static const map<string, int> initialize_CodonTable();
  static const string initialize_DNA_bases();
  static const map<int,char> initialize_AminoAcidLookup();
};

#endif
