// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef INCLUDED_ROTAMER
#define INCLUDED_ROTAMER

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>


class Rotamer
{

 protected:

  int seqpos_; // resid
  int aa_; // aa type
  int aav_; // variant type
  int rotnum_; // rotamer number
  float rperc_; // relative probability
  FArray1D_float rotactcoord_; // center of action for the rotamer
  FArray2D_float rotcoord_; // rotamer coordinates
  FArray1D_float rchi_; // rotamer chi angles
  FArray1D_int rrot_; // rotamer type
  FArray1D_float rot_born_radius_; // GB radius for each atom of each rotamer

 public:

  inline Rotamer( int const seqpos, int const aa, int const aav, int const rotnum )
  { initialize( seqpos, aa, aav, rotnum ); return; };

  inline Rotamer() { return; };

  inline ~Rotamer() { return; };

  void initialize( int const seqpos, int const aa, int const aav, int const rotnum );

  void change_chi_angle_update_coors( int const ichi, float const chi );

  void fill_chi_from_coors();

  void fill_coors_from_chi();

  void compute_rperc();

  void fill_rotactcoord();

  //  bool operator < ( Rotamer const & rhs );

  // Accessor functions
  inline int seqpos() const { return seqpos_; };
  inline int aa() const { return aa_; };
  inline int aav() const { return aav_; };
  inline int rotnum() const { return rotnum_; };

  inline void set_rotnum(int const newval) { rotnum_ = newval; return; };
  inline int & set_rotnum() { return rotnum_; };

  inline float get_rperc() const { return rperc_; };
  inline float & set_rperc() { return rperc_; };
  inline void set_rperc(float const newval) { rperc_ = newval; return; };

  inline float & set_rotactcoord( int const xyzinx ) { return rotactcoord_( xyzinx ); };
  inline float get_rotactcoord( int const xyzinx ) const { return rotactcoord_( xyzinx ); };
  inline FArray1D_float const & get_rotactcoord() const { return rotactcoord_; };
  inline FArray1D_float & get_rotactcoord() { return rotactcoord_; };

  inline float & set_rotcoord( int const xyzinx, int const atominx ) { return rotcoord_( xyzinx, atominx ); };
  inline float get_rotcoord( int const xyzinx, int const atominx ) const { return rotcoord_( xyzinx, atominx ); };
  inline FArray2D_float const & get_rotcoord() const { return rotcoord_; };
  inline FArray2D_float & get_rotcoord() { return rotcoord_; };

  inline float & set_rchi( int const chiinx ) { return rchi_( chiinx ); };
  inline float get_rchi( int const chiinx ) const { return rchi_( chiinx ); };
  inline FArray1D_float const & get_rchi() const { return rchi_; };
  inline FArray1D_float & get_rchi() { return rchi_; };

  inline int & set_rrot( int const chiinx ) { return rrot_( chiinx ); };
  inline int get_rrot( int const chiinx ) const { return rrot_( chiinx ); };
  inline FArray1D_int const & get_rrot() const { return rrot_; };
  inline FArray1D_int & get_rrot() { return rrot_; };

  inline float & set_rot_born_radius( int const atominx ) { return rot_born_radius_( atominx ); };
  inline float get_rot_born_radius( int const atominx ) const { return rot_born_radius_( atominx ); };
  inline FArray1D_float const & get_rot_born_radius() const { return rot_born_radius_; };
  inline FArray1D_float & get_rot_born_radius() { return rot_born_radius_; };

  friend bool operator < ( Rotamer const & lhs, Rotamer const & rhs );

};

bool operator < ( Rotamer const & lhs, Rotamer const & rhs );

#endif
