// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#include "random_numbers.h"
#include "RotamerAssigningAnnealer.h"

#include <ObjexxFCL/Fmath.hh>
#include <iostream>
namespace pack
{

RotamerAssigningAnnealer::RotamerAssigningAnnealer(
	int num_of_rot_to_pack,
	FArray1D_int & bestrotamer_at_seqpos,
	float & bestenergy,
	bool start_with_current, // start simulation with current rotamers
	const RotamerSet * p_rotamer_set,
	FArray1DB_int & current_rot_index,
	bool calc_rot_freq,
	FArray1D_float & rot_freq
) :
	SimAnnealerBase(
	num_of_rot_to_pack,
	bestrotamer_at_seqpos,
	bestenergy,
	start_with_current, // start simulation with current rotamers
	p_rotamer_set,
	current_rot_index,
	calc_rot_freq,
	rot_freq
	),
	rot_to_pack_(num_of_rot_to_pack),
	current_to_pick_( 1 )
{
	for (unsigned int ii =1; ii <= rot_to_pack_.size(); ++ii) {
		rot_to_pack_[ ii-1 ] = ii;
	}
}


RotamerAssigningAnnealer::RotamerAssigningAnnealer(
	std::vector<int> & rot_to_pack,
	int num_of_rot_to_pack,
	FArray1D_int & bestrotamer_at_seqpos,
	float & bestenergy,
	bool start_with_current, // start simulation with current rotamers
	const RotamerSet * p_rotamer_set,
	FArray1DB_int & current_rot_index,
	bool calc_rot_freq,
	FArray1D_float & rot_freq
) :
	SimAnnealerBase(
	num_of_rot_to_pack,
	bestrotamer_at_seqpos,
	bestenergy,
	start_with_current, // start simulation with current rotamers
	p_rotamer_set,
	current_rot_index,
	calc_rot_freq,
	rot_freq
	),
	rot_to_pack_( rot_to_pack ),
	current_to_pick_( 1 )
{}

////////////////////////////////////////////////////////////////////////////////
/// @begin RotamerAssigningAnnealer::pick_a_rotamer()
///
/// @brief pick a rotamer from a list
///
/// @detailed:if no rotamer is available, return a nonsense number, like -1
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
int RotamerAssigningAnnealer::pick_a_rotamer( int cycle )
{
	bool start_with_current = get_start_with_current();
	int ranrotamer = -1;
	int num = 0;
	//bk if quench cycle, pass through all rotamers before
	//bk repeating a rotamer
	if ( quench() ){
		num =   mod( cycle - 1, num_of_rot_to_pack_);
		if (num == 0){
			std::random_shuffle(rot_to_pack_.begin(),rot_to_pack_.end());
		}
		ranrotamer = rot_to_pack_.at(num);
		//bk if start of run and start_with_current is true then first nres
		//bk iterations will be used to place the current rotamers
	}else if (start_with_current && (unsigned int) current_to_pick_ <= current_rot_index_.size() ){

		if (current_rot_index_(current_to_pick_) != -1 ){
			ranrotamer = current_rot_index_(current_to_pick_);
		}else{
			ranrotamer = -1;
		}
		++current_to_pick_;
	}else{
		ranrotamer = rot_to_pack_.at(static_cast<int>( num_of_rot_to_pack_ * ran3() ));
	}
	//std::cerr << "ranrotamer: " << ranrotamer << " total: " << current_rot_index_.size() << std::endl;
	return ranrotamer;
}


}
