// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef ROTAMER_ASSIGNING_ANNEALER_CLASS
#define ROTAMER_ASSIGNING_ANNEALER_CLASS

#include <ObjexxFCL/FArray1D.hh>

#include "SimAnnealerBase.h"
#include "RotamerSetFWD.h"


#include <vector>

namespace pack {

class RotamerAssigningAnnealer;

class RotamerAssigningAnnealer : public SimAnnealerBase
{
public:
	RotamerAssigningAnnealer(
		int num_of_rot_to_pack,
		FArray1D_int & bestrotamer_at_seqpos,
		float & bestenergy,
		bool start_with_current, // start simulation with current rotamers
		const RotamerSet * p_rotamer_set,
		FArray1DB_int & current_rot_index,
		bool calc_rot_freq,
		FArray1D_float & rot_freq
	);

	RotamerAssigningAnnealer(
		std::vector<int> & rot_to_pack,
		int num_of_rot_to_pack,
		FArray1D_int & bestrotamer_at_seqpos,
		float & bestenergy,
		bool start_with_current, // start simulation with current rotamers
		const RotamerSet * p_rotamer_set,
		FArray1DB_int & current_rot_index,
		bool calc_rot_freq,
		FArray1D_float & rot_freq
	);

	virtual ~RotamerAssigningAnnealer() {}

	int pick_a_rotamer( int cycle );

protected:
	std::vector<int> rot_to_pack_;

private:
	int current_to_pick_;

};

} // end namespace
#endif
