// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef INCLUDED_SASA_PACK_INTERACTION_GRAPH_INTERFACE_HEADER
#define INCLUDED_SASA_PACK_INTERACTION_GRAPH_INTERFACE_HEADER

//pure virtual interface for functions that hand data to the
//SASAInteractionGraph classes.

#include "InteractionGraph.h"
#include "RotamerDotsFWD.h"

namespace pack {

class SASAGraph : public virtual InteractionGraph
{
public:
	virtual ~SASAGraph() {}
	virtual void setRotamerCoordsForNodeState
	(
		int node_index,
		int state,
		RotamerCoords const & coords
	) = 0;

	virtual void setNumResiduesInProtein( int num_res ) = 0;
	virtual void setNumBackgroundResidues( int num_background_residues ) = 0;
	virtual void setResidueAsBackgroundResidue( int residue ) = 0;
	virtual void setBackgroundResidueRotamerCoords( int residue, RotamerCoords const & coords) = 0;
	virtual void initialize_overlap_with_ligand( Ligand & ligand) = 0;
};

}
#endif
