// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef SIMULATED_ANNEALER_BASE_H
#define SIMULATED_ANNEALER_BASE_H

#include "InteractionGraphFWD.h"
#include "RotamerSetFWD.h"

#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

#include <vector>

namespace pack {

  extern bool annealing_starts_at_low_temperature;
  class SimAnnealerBase;

  class SimAnnealerBase
  {
  public:

    SimAnnealerBase(
		    int num_of_rot_to_pack,
		    FArray1D_int & bestrotamer_at_seqpos,
		    float & bestenergy,
		    bool start_with_current, // start simulation with current rotamers
		    const RotamerSet * p_rotamer_set,
		    FArray1DB_int & current_rot_index,
		    bool calc_rot_freq,
		    FArray1D_float & rot_freq
		    );

    virtual ~SimAnnealerBase();

    virtual void run() = 0;

    bool pass_metropolis( const float & delta_energy);
    bool pass_metropolis( float previous_energy, float delta_energy );

    void setup_iterations();
    void setup_iterations( const int & num_of_state_changes );
    int get_outeriterations() const;
    int get_inneriterations() const;

    void setup_temperature( const int & nn );
    void setup_temperature( const FArray1D_float& loopenergy,int nn );
    void set_temperature( float new_temperature );
    float get_temperature() const;
    void set_to_quench();
    void set_not_to_quench();
    bool quench() const;
    bool get_start_with_current() const;
    bool get_calc_rot_freq() const;

		inline bool save_trajectory() const { return save_trajectory_; }
		inline void save_trajectory( bool val ) { save_trajectory_ = val; }
    inline int get_num_frames() const { return trajectory_.size(); }
    inline int get_frame( int const fnum ) const
  		{ return trajectory_.at(fnum); }
    inline void save_traj_inx( int const inx )
  		{ trajectory_.push_back(inx); }

    inline void scale_outeriterations( float const so )
    {
      outeriterations_scaling_ = so; return;
    }

    inline void scale_inneriterations( float const si )
    {
      inneriterations_scaling_ = si; return;
    }

    inline float get_delG() const { return delG_; }
    inline void  set_delG( float const delG ) { delG_ = delG; }

    inline float get_bestenergy() const{ return bestenergy_;};

  protected:

    static const float hightemp;
    static const float lowtemp;
    static const int maxouteriterations = 500;
    static const float calc_freq_temp;

    int num_of_rot_to_pack_;
    FArray1D_int& bestrotamer_at_seqpos_;
    float & bestenergy_;
    bool start_with_current_;
    const RotamerSet * p_rotamer_set_;
    FArray1DB_int & current_rot_index_; //assert current_rot_index.size() == pose.total_residue()
    bool calc_rot_freq_;
    FArray1D_float& rot_freq_;

    void set_hightemp( float );
    void set_lowtemp( float );

    float get_hightemp() const { return hightemp_; }
    float get_lowtemp() const { return lowtemp_; }

    void clear(); // resets counts modified by get_temperature


  private:
    int outeriterations_;
    int inneriterations_;
    bool quench_;
    float hightemp_; // initialized at instantiation
    float lowtemp_; // initialized at instantiation
    float temperature_;
    int jump_;

    float delG_;

    float outeriterations_scaling_;
    float inneriterations_scaling_;

    bool const low_temp_annealing_;

    bool save_trajectory_;
		std::vector<int> trajectory_;

    SimAnnealerBase(const SimAnnealerBase& rhs);
  };

}//end of namespace
#endif
