// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#include <iostream>
#include <list>
#include <vector>
#include <map>
#include "random_numbers.h"
#include <utility/basic_sys_util.hh>

using namespace std;

class XUtilities
{
public:
  template< class Container1, class Container2, class Container3 >
  static bool return_keys_given_values( const Container1 & map_inp, const Container2 & vals_inp, Container3 & keys_out )
  {
    if( map_inp.empty() ) return false;

    typename Container1::const_iterator map_inp_iter;

    for( map_inp_iter = map_inp.begin(); map_inp_iter != map_inp.end(); map_inp_iter++ )
      if( find( vals_inp.begin(), vals_inp.end(), map_inp_iter->second ) != vals_inp.end() ) keys_out.push_back( map_inp_iter->first );

    if( keys_out.empty() ) return false;
    else return true;
  }

  template< class Container1, class Container2, class Container3 >
  static bool return_values_given_keys( const Container1 & map_inp, const Container2 & keys_inp, Container3 & vals_out )
  {
    if( map_inp.empty() ) return false;

    typename Container1::const_iterator map_inp_iter;

    for( map_inp_iter = map_inp.begin(); map_inp_iter != map_inp.end(); map_inp_iter++ )
      if( find( keys_inp.begin(), keys_inp.end(), map_inp_iter->first ) != keys_inp.end() ) vals_out.push_back( map_inp_iter->second );

    if( vals_out.empty() ) return false;
    else return true;
  }

  template< class Container1, class Container2, class T >
  static bool return_values_given_keys( const Container1 & map_inp, const Container2 & keys_inp, list<T> & vals_out )
  {
    if( map_inp.empty() ) return false;

    typename Container1::const_iterator map_inp_iter;

    for( map_inp_iter = map_inp.begin(); map_inp_iter != map_inp.end(); map_inp_iter++ )
      if( find( keys_inp.begin(), keys_inp.end(), map_inp_iter->first ) != keys_inp.end() ) vals_out.push_back( map_inp_iter->second );

    if( vals_out.empty() ) return false;
    else{
      vals_out.sort();
      vals_out.unique();
      return true;
    }
  }

  template< class Container1, class Container2, class T >
  static bool return_keys_given_values( const Container1 & map_inp, const Container2 & vals_inp, list<T> & keys_out )
  {
    if( map_inp.empty() ) return false;

    typename Container1::const_iterator map_inp_iter;

    for( map_inp_iter = map_inp.begin(); map_inp_iter != map_inp.end(); map_inp_iter++ )
      if( find( vals_inp.begin(), vals_inp.end(), map_inp_iter->second ) != vals_inp.end() ) keys_out.push_back( map_inp_iter->first );

    if( keys_out.empty() ) return false;
    else{
      keys_out.sort();
      keys_out.unique();
      return true;
    }
  }

  template< class Container1, class Container2 >
  static bool return_all_keys( const Container1 & map_inp, Container2 & keys_out )
  {
    if( map_inp.empty() ) return false;

    typename Container1::const_iterator map_inp_iter;

    for( map_inp_iter = map_inp.begin(); map_inp_iter != map_inp.end(); map_inp_iter++ )
      keys_out.push_back( map_inp_iter->first );

    if( keys_out.empty() ) return false;
    else return true;
  }

  template< class T >
  static T random_element_from_container( const list<T> & list_inp )
  {
    if( list_inp.empty() ) utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
    vector< T > T_vec;
    copy( list_inp.begin(), list_inp.end(), back_inserter( T_vec ) );
    return T_vec.at( static_cast<int>( T_vec.size() * ran3() ) );
  }

  template< class Ktype, class Vtype >
  static Ktype random_element_from_container( const map<Ktype, Vtype> & map_inp )
  {
    if( map_inp.empty() ) utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
    vector< Ktype > Ktype_vec;
    typename map<Ktype, Vtype>::const_iterator map_inp_iter;

    for( map_inp_iter = map_inp.begin(); map_inp_iter != map_inp.end(); map_inp_iter++ )
      Ktype_vec.push_back( map_inp_iter->first );

    return Ktype_vec.at( static_cast<int>( Ktype_vec.size() * ran3() ) );
  }

  template< class Ktype, class Vtype >
  static void print_container_contents( const map<Ktype, Vtype> & map_inp )
  {
    if( map_inp.empty() ) return;
    typename map<Ktype, Vtype>::const_iterator map_inp_iter;

    for( map_inp_iter = map_inp.begin(); map_inp_iter != map_inp.end(); map_inp_iter++ )
      cout << map_inp_iter->first << ":" << map_inp_iter->second;
    cout << endl;
  }

  template< class Container >
  static void print_container_contents( const Container & cnt_inp )
  {
    if( cnt_inp.empty() ) return;

    typename Container::const_iterator cnt_inp_iter;
    for( cnt_inp_iter = cnt_inp.begin(); cnt_inp_iter != cnt_inp.end(); cnt_inp_iter++ )
      cout << * cnt_inp_iter << " ";
    cout << endl;
  }

};

