// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16039 $
//  $Date: 2007-07-15 01:04:19 -0400 (Sun, 15 Jul 2007) $
//  $Author: ashworth $


// Rosetta Headers
#include "after_opts.h"
#include "namespace_options.h"

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.o.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>

// C++ Headers
#include <iostream>
#include <sstream>
#include <string>
#include <vector>

// Using
using namespace options;


//car   In all functions, change write statements to use substring of
//car    cstr rather than the passed str because concatenation operator
//car    requires scalar subexpressions, not arrays (PG compiler complains)
//car
//cj    =========================================================================
//cj    30 Oct 00 - cleaned up code and added falsetrueoption - jwt
//cj              - made truefalse & falsetrue to return bool
//cj    =========================================================================

//car   if "-str" is included on the command line, sets lval to T
//car   if "-str" is not included in iargc, sets lval to F

//Utility Headers
#include <utility/basic_sys_util.hh>

////////////////////////////////////////////////////////////////////////////////
/// @begin truefalseoption
///
/// @brief
///
/// @detailed
///
/// @param  str - [in/out]? -
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool
truefalseoption( std::string const & str )
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			if (option_display) std::cout << "[T/F  OPT]New TRUE value for [" << cstr << ']' << std::endl;
			return true;
		}
	}

	if (option_display) std::cout << "[T/F  OPT]Default FALSE value for [" << cstr << ']' << std::endl;
	return false;
}

bool
quiettruefalseoption( std::string const & str )
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			return true;
		}
	}

	return false;
}

///////////////////////////////////////////////////////////////////////////////
void
add_args_from_file()
{

	//Right at the beginning, let's decide whether we want any more options displayed.
	if ( truefalseoption("no_option_display")) options::option_display = false;

	if ( truefalseoption("args_file") ) {
		add_args_from_file( stringafteroption("args_file") );
	}
}

///////////////////////////////////////////////////////////////////////////////
void
add_args_from_file(
	std::string const & filename
)
{
	// where we store all the new args
	static std::vector< std::string > new_args; // keep adding here

	// this is where we store all the args
	static std::vector< char* > all_args;

	// the number of true command line options
	static int const arg_count_orig( arg_count );


	// parse the file
	utility::io::izstream data( filename );
	std::string line;

	while ( getline( data, line ) ) {
		std::istringstream l( line );
		while ( !l.fail() ) {
			std::string arg;
			l >> arg;
			if ( !l.fail() ) {
				new_args.push_back( arg );
			}
		}
	}

	// now fill in all_args
	all_args.clear();

	// the original command line options
	for ( int i=0; i<arg_count_orig; ++i ) {
		all_args.push_back( arg_vector[i] );
	}

	for ( std::vector< std::string >::const_iterator it=new_args.begin(),
					it_end=new_args.end(); it != it_end; ++it ) {
		// bad,bad,bad:
		all_args.push_back( const_cast<char *>( it->c_str() ));
	}

	// update the char** and count
	arg_vector = &( all_args[0] );
	arg_count = all_args.size();

}



////////////////////////////////////////////////////////////////////////////////
/// @begin realafteroption
///
/// @brief
///
/// @detailed
///
/// @param  str - [in/out]? -
/// @param  opt_default - [in/out]? -
/// @param  rnum - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
realafteroption(
	std::string const & str,
	float opt_default,
	float & rnum
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 1; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			std::istringstream rnum_stream( arg_vector[ jj + 1 ] );
			rnum_stream >> rnum;
			if (option_display)  std::cout << "[REAL OPT]New value for [" << cstr << "] " <<
			 SS( rnum ) << std::endl;
			return;
		}
	}

	rnum = opt_default;
	if (option_display)  std::cout << "[REAL OPT]Default value for [" << cstr << "] " <<
	 SS( rnum ) << std::endl;
}

float
realafteroption(
	std::string const & str
)
{
	if ( !truefalseoption( str ) ) {
		if (option_display)  std::cout << "realafteroption: missing required arg: " << str << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	float val;
	realafteroption( str, 100, val );
	return val;
}

float
realafteroption(
	std::string const & str,
	float const opt_default
)
{
	float value;
	realafteroption( str, opt_default, value );
	return value;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin Drealafteroption
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
Drealafteroption(
	std::string const & str,
	double opt_default,
	double & rnum
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 1; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			std::istringstream rnum_stream( arg_vector[ jj + 1 ] );
			rnum_stream >> rnum;
			if (option_display)  std::cout << "[REAL OPT]New value for [" << cstr << "] " <<
			 SS( rnum ) << std::endl;
			return;
		}
	}

	rnum = opt_default;
	if (option_display)  std::cout << "[REAL OPT]Default value for [" << cstr << "] " <<
	 SS( rnum ) << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin real3afteroption
///
/// @brief
///
/// @detailed
///
/// @param  str - [in/out]? -
/// @param  default1 - [in/out]? -
/// @param  rnum1 - [in/out]? -
/// @param  default2 - [in/out]? -
/// @param  rnum2 - [in/out]? -
/// @param  default3 - [in/out]? -
/// @param  rnum3 - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
real3afteroption(
	std::string const & str,
	float default1,
	float & rnum1,
	float default2,
	float & rnum2,
	float default3,
	float & rnum3
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 3; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			std::istringstream rnum_stream( arg_vector[ jj + 1 ] );
			rnum_stream >> rnum1;
			rnum_stream.clear();
			rnum_stream.str( arg_vector[ jj + 2 ] );
			rnum_stream >> rnum2;
			rnum_stream.clear();
			rnum_stream.str( arg_vector[ jj + 3 ] );
			rnum_stream >> rnum3;
			if (option_display)  std::cout << "[REAL OPT]New values for [" << cstr << "] " <<
			 SS( rnum1 ) << SS( rnum2 ) << SS( rnum3 ) << std::endl;
			return;
		}
	}

	rnum1 = default1;
	rnum2 = default2;
	rnum3 = default3;
	if (option_display) std::cout << "[REAL OPT]Default values for [" << cstr << "] " <<
	 SS( rnum1 ) << SS( rnum2 ) << SS( rnum3 ) << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin intafteroption
///
/// @brief
///
/// @detailed
///
/// @param  str - [in/out]? -
/// @param  opt_default - [in/out]? -
/// @param  inum - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
int
intafteroption(
	std::string const & str
)
{
	if ( !truefalseoption( str ) ) {
		if (option_display)  std::cout << "intafteroption: missing required arg: " << str << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	int val;
	intafteroption( str, 100, val );
	return val;
}

int
intafteroption(
	std::string const & str,
	int const opt_default
)
{
	int val;
	intafteroption( str, opt_default, val );
	return val;
}

void
intafteroption(
	std::string const & str,
	int opt_default,
	int & inum
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 1; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			std::istringstream inum_stream( arg_vector[ jj + 1 ] );
			inum_stream >> inum;
			if (option_display)  std::cout << "[INT  OPT]New value for [" << cstr << "] " <<
			 SS( inum ) << std::endl;
			return;
		}
	}

	inum = opt_default;
	if (option_display)  std::cout << "[INT  OPT]Default value for [" << cstr << "] " <<
	 SS( inum ) << std::endl;
}

void
optional_positive_intafteroption(
	std::string const & str,
	int opt_default,
	int & inum
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 1; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {

			std::istringstream inum_stream( arg_vector[ jj + 1 ] );

			char peekchar = inum_stream.peek();
			if ( peekchar == '-' ) break;

			inum_stream >> inum;
			if (option_display)  std::cout << "[INT  OPT]New value for [" << cstr << "] " <<
			 SS( inum ) << std::endl;
			return;
		}
	}

	inum = opt_default;
	if (option_display)  std::cout << "[INT  OPT]Default value for [" << cstr << "] " <<
	 SS( inum ) << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin int2afteroption
///
/// @brief
///
/// @detailed
///
/// @param  str - [in/out]? -
/// @param  opt_default - [in/out]? -
/// @param  inum - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////

void
int2afteroption(
	std::string const & str,
	int opt_default,
	int & inum,
	int opt_default2,
	int & inum2
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 1; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			std::istringstream inum_stream( arg_vector[ jj + 1 ] );
			inum_stream >> inum;
			inum_stream.clear();
			inum_stream.str( arg_vector[ jj + 2 ] );
			inum_stream >> inum2;
			if (option_display)  std::cout << "[INT  OPT]New values for [" << cstr << "] " <<
			 SS( inum ) << SS( inum2 ) << std::endl;
			return;
		}
	}

	inum = opt_default;
	inum2 = opt_default2;
	if (option_display) std::cout << "[INT  OPT]Default values for [" << cstr << "] " <<
	 SS( inum ) << SS( inum2 ) << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin stringafteroption
///
////////////////////////////////////////////////////////////////////////////////
void
charafteroption(
	std::string const & str,
	char const & opt_def,
	char & val
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 1; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			val = arg_vector[ jj + 1 ][0];
			std::cout << "[STR  OPT]New value for [" << cstr << "] " <<
			 A(val) << '.' << std::endl;
			return;
		}
	}

	val = opt_def;
	std::cout << "[STR  OPT]Default value for [" << cstr << "] " <<
	 A(val) << '.' << std::endl;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin stringafteroption
///
/// @brief
///
/// @detailed
///
/// @param  str - [in/out]? -
/// @param  opt_default - [in/out]? -
/// @param  cval - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
stringafteroption(
	std::string const & str,
	std::string const & opt_default,
	std::string & cval
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 1; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			cval = arg_vector[ jj + 1 ];
			if (option_display)  std::cout << "[STR  OPT]New value for [" << cstr << "] " <<
			 cval << '.' << std::endl;
			return;
		}
	}

	cval = opt_default;
	if (option_display)  std::cout << "[STR  OPT]Default value for [" << cstr << "] " <<
	 cval << '.' << std::endl;
}

///////////////////////////////////////////////////////////////////////////////
// require presence of the option
//

std::string
stringafteroption(
	std::string const & str
)
{
	if ( !truefalseoption( str ) ) {
		if (option_display)  std::cout << "STOP:: stringafteroption: missing a required argument: " <<
			str << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	std::string val;
	stringafteroption( str, "dummy", val );
	return val;
}

///////////////////////////////////////////////////////////////////////////////
std::string
stringafteroption(
	std::string const & str,
	std::string const & opt_default
)
{
	std::string val;
	stringafteroption( str, opt_default, val );
	return val;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin stringafteroption
///
/// @brief
///
/// @detailed
///
/// @param  str - [in/out]? -
/// @param  opt_default - [in/out]? -
/// @param  cval - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
/// Overload for char options
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
stringafteroption(
	std::string const & str,
	char const opt_default,
	char & cval
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 1; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			cval = arg_vector[ jj + 1 ][ 0 ];
			if (option_display) std::cout << "[STR  OPT]New value for [" << cstr << "] " <<
			 cval << '.' << std::endl;
			return;
		}
	}

	cval = opt_default;
	if (option_display) std::cout << "[STR  OPT]Default value for [" << cstr << "] " <<
	 cval << '.' << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin output_command
///
/// @brief
///cj    recreates the command from argument list and outputs to stderr
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
output_command()
{
	std::string comm( arg_vector[ 0 ] );
	for ( int jj = 1; jj < arg_count; ++jj ) {
		comm += ' ';
		comm += arg_vector[ jj ];
	}
	if (option_display) std::cout << "command executed: " << comm << std::endl;
}

std::string
rosetta_command_string()
{
	std::string comm( arg_vector[ 0 ] );
	for ( int jj = 1; jj < arg_count; ++jj ) {
		comm += ' ';
		comm += arg_vector[ jj ];
	}
	return comm;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin real2afteroption
///
/// @brief
///
/// @detailed
///
/// @param  str - [in/out]? -
/// @param  default1 - [in/out]? -
/// @param  rnum1 - [in/out]? -
/// @param  default2 - [in/out]? -
/// @param  rnum2 - [in/out]? -
/// @param  default3 - [in/out]? -
/// @param  rnum3 - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
real2afteroption(
	std::string const & str,
	float default1,
	float & rnum1,
	float default2,
	float & rnum2
)
{
	std::string const cstr( '-' + str );

	for ( int jj = 1; jj < arg_count - 2; ++jj ) {
		if ( arg_vector[ jj ] == cstr ) {
			std::istringstream rnum_stream( arg_vector[ jj + 1 ] );
			rnum_stream >> rnum1;
			rnum_stream.clear();
			rnum_stream.str( arg_vector[ jj + 2 ] );
			rnum_stream >> rnum2;
			if (option_display) std::cout << "[REAL OPT]New values for [" << cstr << "] " <<
			 SS( rnum1 ) << SS( rnum2 ) << std::endl;
			return;
		}
	}

	rnum1 = default1;
	rnum2 = default2;
	if (option_display) std::cout << "[REAL OPT]Default values for [" << cstr << "] " <<
	 SS( rnum1 ) << SS( rnum2 ) << std::endl;
}
