// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12560 $
//  $Date: 2007-02-07 20:18:53 -0500 (Wed, 07 Feb 2007) $
//  $Author: yab $

#ifndef INCLUDED_all_atom
#define INCLUDED_all_atom


// Rosetta Headers
#include "aaproperties_pack.h"
#include "vdw.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>


////////////////////////////////////////////////////////////////////////////////
//\BEGIN all_atom_cutoff
//
//\BRIEF
//
//\FULL
//
//\PARAM - type1 - in/out -
//\PARAM - type2 - in/out -
//\PARAM - fullatom - in/out -
//
//\RETURN
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
float
all_atom_cutoff(
	int const type1,
	int const type2,
	bool const fullatom
)
{
	using namespace aaproperties_pack;

	static float const buffer = { 4.0 };
	static float const fa_cutoff = { 49.0 };
	static float const H1_cutoff = { 25.0 };
	static float const H2_cutoff = { 16.0 };

	if ( fullatom ) {

//bk      use shorter cutoff if atom is a hydrogen since hydrogens
//bk      are only being evaluated for repulsions

		if ( atom_type_name(type1)[0] == 'H' ) {
			return ( atom_type_name(type2)[0] == 'H' ? H2_cutoff : H1_cutoff );
		} else if ( atom_type_name(type2)[0] == 'H' ) {
			return H1_cutoff;
		} else {
			return fa_cutoff;
		}
	} else {
		return vdw::atom_vdw(type1,type2) + buffer;
	}
}


#endif
