// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16039 $
//  $Date: 2007-07-15 01:04:19 -0400 (Sun, 15 Jul 2007) $
//  $Author: ashworth $

#ifndef INCLUDED_analyze_interface_ddg
#define INCLUDED_analyze_interface_ddg

//#include "pose.h"
#include "cst_set.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// analyze_interface_ddg Function Declarations


void
analyze_interface_ddg();


void
setup_interface(
	int & p1_start,
	int & p1_end,
	int & p2_start,
	int & p2_end,
	std::map<std::pair<int,int>,int>& pdb_res_chain_to_rosetta
);


void
binding_energy_one_structure(
	int & p1_start,
	int & p1_end,
	int & p2_start,
	int & p2_end,
	int listnumber,
	bool wtflag
);


void
binding_energies_mutlist(
	int & p1_start,
	int & p1_end,
	int & p2_start,
	int & p2_end,
	std::map<std::pair<int,int>,int>& pdb_res_chain_to_rosetta
);


void
save_pack_weights();


void
reset_weights_to_pack_weights();


void
set_new_Waa_value(
	int aa_type,
	float new_weight
);


void
reset_Waa_value( int aa_type );


void
reset_weights_to_int_weights();


void
calc_binding_energy_complex(
	int & p1_start,
	int & p1_end,
	int & p2_start,
	int & p2_end,
	bool wtflag
);


void
calc_binding_energy_mut_complex(
	int & p1_start,
	int & p1_end,
	int & p2_start,
	int & p2_end,
	FArray2D_int const & mutations_all_res,
	FArray2D_int const & mutations_all_aa,
	int & curr_mutated_complex,
	int & n_mutations_curr_complex
);


void
mutate_structure(
	FArray1Da_int mutations_curr_struct_res,
	FArray1Da_int mutations_curr_struct_aa,
	int & n_mutations_curr_struct,
	FArray3Da_float xyz_curr,
	FArray1Da_float phi_curr,
	FArray1Da_float psi_curr,
	FArray1Da_int aan_curr,
	FArray1Da_int aav_curr,
	int & nres_curr
);


void
save_scores(
	int & which_partner,
	int & nres
);


void
set_residues_to_vary(
	FArray1DB_int  & mutations_curr_struct_aa,
	FArray1DB_int & mutations_curr_struct_res,
	int n_mutations_curr_struct,
	FArray1DB_int & aan_curr,
	FArray3DB_float & xyz_curr,
	int nres_curr
);


void
save_wt_scores( int & which_partner );


void
retrieve_unmutated_part_scores( int & which_partner );


void
compile_binding_energy( int listnumber );


// void
// set_allow_repack_int(
// 	FArray1Da_int mutations_curr_struct_res,
// 	int & n_mutations_curr_struct,
// 	FArray1Da_bool allow_repack,
// 	int & nres_curr,
// 	FArray1Da_bool extra_res_to_repack,
// 	bool & extra_repack,
// 	FArray1Da_int aan_curr,
// 	FArray3Da_float xyz_curr
// );


void
settings_general_functions();

void
settings_for_pack_rotamers(
	bool & make_output_file,
	bool & include_current,
	bool & include_extra,
	std::string & packmode
);

void
get_complex_boundaries(
	int & p1_start,
	int & p1_end,
	int & p2_start,
	int & p2_end
);

bool
get_complex_boundaries_protein_NA(
	int & protein_end,
	int & NA_start,
	int & NA_end
);

void
set_partner_specific_params(
	int & which_partner,
	int & startres,
	int & endres,
	int & p1_start,
	int & p1_end,
	int & p2_start,
	int & p2_end,
	int & all_res_complex
);


void
copy_xyz_aan_aav_phi_psi(
	FArray3Da_float xyz_in, // starting coordinate array
	FArray3Da_float xyz_out, // output coordinate array
	FArray1Da_float phi_in, // starting phi angles
	FArray1Da_float phi_out, // output phi angles
	FArray1Da_float psi_in, // starting psi angles
	FArray1Da_float psi_out, // output psi angles
	FArray1Da_int aan_in, // starting sequence
	FArray1Da_int aan_out, // output sequence
	FArray1Da_int aav_in, // starting variant
	FArray1Da_int aav_out, // output variant
	FArray1D_char & residue1_in,
	FArray1D_char & residue1_out,
	FArray1D_string & residue3_in,
	FArray1D_string & residue3_out,
	FArray3Dp_float & Eposition,
	int & nres_out, // number of residues in output
	int startres,
	int endres
);


void
set_aan_variant(
	FArray1Da_int aa_variant_inout,
	int & nres_curr
);


void
map_1_ros_num_to_pdb_res_chain(
	int & rosetta_resnum,
	int & pdb_resnum,
	char & chain
);


void
map_all_pdb_pos_to_rosetta(
  std::map<std::pair<int,int>,int>& pdb_res_chain_to_rosetta
);


void
map_complex_num_to_part_num(
	int & complex_num,
	int & part_num,
	int & p2_start,
	bool & p2_true
);


void
map_part_num_to_complex_num(
	int & part_num,
	int & complex_num,
	int & p2_start,
	bool & p1_true // true if partner1, false if partner 2
);


void
get_complete_mutation_list(
	Dimension & n_mut_structs,
	FArray2D_int & mutations_all_res,
	FArray2D_int & mutations_all_aa,
	FArray1D_int & n_mut_per_struct,
	std::map<std::pair<int,int>,int>& pdb_res_chain_to_rosetta
);


void
set_mut_arrays_curr_struct(
	FArray2D_int const & mutations_all_res,
	FArray2D_int const & mutations_all_aa,
	int & number_of_curr_struct,
	//	int & which_partner,
	int & p2_start,
	int & n_mutations_curr_complex,
	int & n_mutations_curr_struct,
	FArray1D_int & mutations_curr_struct_res,
	FArray1D_int & mutations_curr_struct_aa,
	int & startres,
	int & endres
);


void
output_complex_ddg_table(
	int const n_mut_structs,
	FArray2Da_int mutations_all_res,
	FArray2Da_int mutations_all_aa,
	FArray1Da_int n_mut_per_struct
);


void
initialize_1dim_logical(
	FArray1Da_bool logical_array,
	int size
);


void
convert_chain_char_to_chain_num(
	char const chain_char,
	int & chain_num
);


void
repack_wt_structure(
	int const which_partner,
	int const p2_start
);


void
pick_interface_residues_for_repacking(
	int const which_partner,
	int const p2_start,
	FArray2Da_bool const & neighborlist
);

void
setup_minimize_interface(
	cst_set_ns::Cst_set & cst_complex,
	cst_set_ns::Cst_set & cst_partner1,
	cst_set_ns::Cst_set & cst_partner2,
	int const & p2_start
);

void
remove_sidechain_constraints(
  int const & residue,
	cst_set_ns::Cst_set & cst_set
);

void
minimize_interface(
									 //pose_ns::Pose & pose,
  cst_set_ns::Cst_set & cst_set,
  int const nchains,
	int const partner2_begin,
	bool const first_min
);

void
initialize_allow_mutation(
	FArray2D_bool & allow_mutation
);


#endif
