// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12596 $
//  $Date: 2007-02-09 14:42:29 -0500 (Fri, 09 Feb 2007) $
//  $Author: sammond $


// Rosetta Headers
#include "analyze_interface_ddg_ns.h"
#include "param.h"
#include "pose_constraints.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;


//tk variables and parameters for interface mode


namespace analyze_interface_ddg_ns {


//tk max_sizes

int const MAX_MUT_PER_STRUCT = { 80 };

int const MAX_CHAINNUMS = { 27 };

int const MAX_FILENAMELENGTH = { 100 };


//tk filenames

namespace int_chars {
	std::string mutlist;
	std::string intout;
}


//tk flags

namespace int_flags {
	bool ddg_bind_only; // calculate binding energy of complex only
	bool Wpack_only; // use packer weights for both packing and scoring
	bool Wint_only; // use int weights for both packing and scoring
	bool safety_check; // activate safety checks
	bool output_structure; // output all the structures during ddg calculation
	bool alter_spec_format; // output energy table with special format for alter_spec
	bool chain_energies; // output energies for each binding partner
	bool repack_neighbors; // allow analyze_interface to repack neighbors to each mut
	bool min_interface; //gradient based minimization before and after mut
	bool ddg_per_residue; // keep track of ddg per residue

	//flags for specifying what can move during minimization
	bool bb; //backbone torsion
	bool int_bb; //interface backbone torsion
	bool chi; // chi angles
	bool int_chi; // interface chi angles
	bool rb; // rigid body optimization
	bool use_cst;  // use constraints
	float cstW; // constraint weight

	bool relax_unbound; // apply minimization and/or repacking to the unbound state
  bool ala_scan;//calculate delta delta binding energy for alanine scan
	bool pmut_scan;// point mutant scan
  bool output_mabo_input;//special output if ala_scan
  int n_partner; //number of partners  1: single protein  3: complex
  bool single_protein; //true if calculate the single protein chain
	bool ddg_decoystats = { true };
	bool affin_incr; // adds filter to pmutscan and outputs #neighbors in energy file.

}

//tk oiriginal pack weights for resetting scoring functions
namespace int_weight_parameters {
	FArray1D_float Waa_saved( MAX_AA(), 999.0f );
}

//tk original complex coordinates

namespace complex_orig {
	FArray3D_float xyz_orig( 3, MAX_ATOM(), MAX_RES() );
	FArray1D_float phi_orig( MAX_RES() );
	FArray1D_float psi_orig( MAX_RES() );
	FArray1D_int aan_orig( MAX_RES() );
	FArray1D_int aav_orig( MAX_RES() );
	FArray1D_char residue1_orig( MAX_RES(), ' ' );
	FArray1D_string residue3_orig( MAX_RES(), std::string( 3, ' ' ) );
	int nres_orig;
	FArray1D_int number_of_neighbors_orig( MAX_RES());
}


//ds original complex coordinates for chain A after relaxing interface residues

namespace chainA_orig {
	FArray3D_float xyz_chA( 3, MAX_ATOM(), MAX_RES() );
	FArray1D_float phi_chA( MAX_RES() );
	FArray1D_float psi_chA( MAX_RES() );
	FArray1D_int aan_chA( MAX_RES() );
	FArray1D_int aav_chA( MAX_RES() );
	FArray1D_char residue1_chA( MAX_RES(), ' ' );
	FArray1D_string residue3_chA( MAX_RES(), std::string( 3, ' ' ) );
	int endres_chA;
}


//ds original complex coordinates for chain B after relaxing interface residues

namespace chainB_orig {
	FArray3D_float xyz_chB( 3, MAX_ATOM(), MAX_RES() );
	FArray1D_float phi_chB( MAX_RES() );
	FArray1D_float psi_chB( MAX_RES() );
	FArray1D_int aan_chB( MAX_RES() );
	FArray1D_int aav_chB( MAX_RES() );
	FArray1D_char residue1_chB( MAX_RES(), ' ' );
	FArray1D_string residue3_chB( MAX_RES(), std::string( 3, ' ' ) );
	int endres_chB;
}

//bk save constraint sets based on the starting structure
namespace cst_set_start {
	cst_set_ns::Cst_set cst_complex;
	cst_set_ns::Cst_set cst_partner1;
	cst_set_ns::Cst_set cst_partner2;
}


//tk complex_definitions

namespace param_chains_data {


	void
	chain_name_initializer( FArray1D_char & chain_name )
	{
		int i = 0;
		chain_name( ++i ) = 'A';
		chain_name( ++i ) = 'B';
		chain_name( ++i ) = 'C';
		chain_name( ++i ) = 'D';
		chain_name( ++i ) = 'E';
		chain_name( ++i ) = 'F';
		chain_name( ++i ) = 'G';
		chain_name( ++i ) = 'H';
		chain_name( ++i ) = 'I';
		chain_name( ++i ) = 'J';
		chain_name( ++i ) = 'K';
		chain_name( ++i ) = 'L';
		chain_name( ++i ) = 'M';
		chain_name( ++i ) = 'N';
		chain_name( ++i ) = 'O';
		chain_name( ++i ) = 'P';
		chain_name( ++i ) = 'Q';
		chain_name( ++i ) = 'R';
		chain_name( ++i ) = 'S';
		chain_name( ++i ) = 'T';
		chain_name( ++i ) = 'U';
		chain_name( ++i ) = 'V';
		chain_name( ++i ) = 'W';
		chain_name( ++i ) = 'X';
		chain_name( ++i ) = 'Y';
		chain_name( ++i ) = 'Z';
		chain_name( ++i ) = ' ';
	}


	FArray1D_char const chain_name( MAX_CHAINNUMS, chain_name_initializer );
}

//cmd variable to track status of interface calculations
namespace track_complex_state {
	int complex_state;
}

}
