// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 9595 $
//  $Date: 2006-08-08 19:20:23 -0400 (Tue, 08 Aug 2006) $
//  $Author: tex $


// Rosetta Headers
#include "angles_ns.h"
//KMa phospho_ser 2006-01
#include "param.h"
#include "options.h"
#include "add_pser.h"



// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>


namespace angles {

// precomputed rotation matrix coeficients
namespace angles_template_coef {
	FArray2D_double omega_coef( 2, 9 );
	FArray2D_double psi_coef( 2, 9 );
	FArray2D_double phi_coef( 2, 9 );
}

namespace angles_stub {
	FArray1D_double xn( 3 );
	FArray1D_double xca( 3 );
	FArray1D_double xc( 3 );
}

namespace angles_standard_residue {


	void
	Bcentroids_initializer( FArray2D_double & Bcentroids )
	{
		FArray1Da_double Bcentroids1d( Bcentroids );
		int i = 0;
		Bcentroids1d( ++i ) = 0.765;
		Bcentroids1d( ++i ) = -2.003;
		Bcentroids1d( ++i ) = 0.509;
		Bcentroids1d( ++i ) = 0.985;
		Bcentroids1d( ++i ) = -2.884;
		Bcentroids1d( ++i ) = 0.714;
		Bcentroids1d( ++i ) = 0.869;
		Bcentroids1d( ++i ) = -2.976;
		Bcentroids1d( ++i ) = 0.796;
		Bcentroids1d( ++i ) = 1.056;
		Bcentroids1d( ++i ) = -3.527;
		Bcentroids1d( ++i ) = 1.221;
		Bcentroids1d( ++i ) = 0.890;
		Bcentroids1d( ++i ) = -3.536;
		Bcentroids1d( ++i ) = 0.909;
		Bcentroids1d( ++i ) = 0.181;
		Bcentroids1d( ++i ) = -1.145;
		Bcentroids1d( ++i ) = -0.603;
		Bcentroids1d( ++i ) = 0.909;
		Bcentroids1d( ++i ) = -3.381;
		Bcentroids1d( ++i ) = 0.849;
		Bcentroids1d( ++i ) = 1.007;
		Bcentroids1d( ++i ) = -3.005;
		Bcentroids1d( ++i ) = 0.869;
		Bcentroids1d( ++i ) = 1.023;
		Bcentroids1d( ++i ) = -3.907;
		Bcentroids1d( ++i ) = 1.401;
		Bcentroids1d( ++i ) = 0.724;
		Bcentroids1d( ++i ) = -3.514;
		Bcentroids1d( ++i ) = 0.821;
		Bcentroids1d( ++i ) = 0.807;
		Bcentroids1d( ++i ) = -3.630;
		Bcentroids1d( ++i ) = 1.159;
		Bcentroids1d( ++i ) = 0.856;
		Bcentroids1d( ++i ) = -3.032;
		Bcentroids1d( ++i ) = 0.725;
		Bcentroids1d( ++i ) = 2.369;
		Bcentroids1d( ++i ) = -1.558;
		Bcentroids1d( ++i ) = -0.506;
		Bcentroids1d( ++i ) = 0.969;
		Bcentroids1d( ++i ) = -3.616;
		Bcentroids1d( ++i ) = 1.133;
		Bcentroids1d( ++i ) = 1.262;
		Bcentroids1d( ++i ) = -4.116;
		Bcentroids1d( ++i ) = 1.763;
		Bcentroids1d( ++i ) = 1.133;
		Bcentroids1d( ++i ) = -2.175;
		Bcentroids1d( ++i ) = 0.870;
		Bcentroids1d( ++i ) = 1.024;
		Bcentroids1d( ++i ) = -2.469;
		Bcentroids1d( ++i ) = 0.751;
		Bcentroids1d( ++i ) = 0.762;
		Bcentroids1d( ++i ) = -2.630;
		Bcentroids1d( ++i ) = 0.816;
		Bcentroids1d( ++i ) = 0.681;
		Bcentroids1d( ++i ) = -3.591;
		Bcentroids1d( ++i ) = 1.247;
		Bcentroids1d( ++i ) = 0.904;
		Bcentroids1d( ++i ) = -3.674;
		Bcentroids1d( ++i ) = 1.016;

//KMa phospho_ser 2006-01
 if ( add_pser() )
 {
		Bcentroids1d( ++i ) = 1.133;//KOSTA_1AR
		Bcentroids1d( ++i ) = -2.175;
		Bcentroids1d( ++i ) = 0.870;
 }
	}

//KMa phospho_ser 2006-01
	FArray2D_double Bxyz( 3, 8 );
	FArray2D_double Bcentroids( 3, param::MAX_AA_PLUS(), Bcentroids_initializer );
}


}
