// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15540 $
//  $Date: 2007-06-19 18:37:31 -0400 (Tue, 19 Jun 2007) $
//  $Author: chu $

#ifndef INCLUDED_ATOM_DESCRIPTOR_CLASS_H_
#define INCLUDED_ATOM_DESCRIPTOR_CLASS_H_

#include <ObjexxFCL/ObjexxFCL.hh>

#include <iosfwd>


class atom_descriptor;

class atom_descriptor
{
public:
	atom_descriptor();
	~atom_descriptor();
	atom_descriptor( const atom_descriptor & rhs);

	atom_descriptor(int atom_type, FArray1Da_float, FArray1Da_float, FArray1Da_float );
  atom_descriptor(int atom_index, int aa, int aav, FArray2DB_float & rotamer_coords );

	float & get_xyz()						{return _xyz[0];}       //implicit inline
	float & get_xyz(int const i)						{return _xyz[i];}
  float & get_orientation_vector()		{return _ovect[0];}
	unsigned char get_atom_type() 			{return _atom_type;}

	bool operator < (const atom_descriptor & rhs) const;
	bool operator == (const atom_descriptor & rhs) const;

	friend std::ostream & operator << ( std::ostream & os, atom_descriptor const & ad );
private:
	float          _xyz[3];
	float          _ovect[3];
	unsigned char  _atom_type;

  void init_atom_descriptor(int atom_type, FArray1Da_float xyz, FArray1Da_float base_xyz, FArray1Da_float base2_xyz );
};

std::ostream & operator << ( std::ostream & os, atom_descriptor const & ad );

#endif

