// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
#ifdef BOINC_GRAPHICS
#ifndef INCLUDED_boinc_rosetta_graphics
#define INCLUDED_boinc_rosetta_graphics

#include "pose_fwd.h"

#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray1D.hh>

#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>

#include <string>
#include <vector>


namespace graphics {
	extern float aspect_width, aspect_height;
	extern float wu_text_box_height;
	extern std::vector<std::string> wu_desc_rows;
	extern int wu_desc_rows_per_small_box;

	enum GraphicsPoseType {
		CURRENT,
		ACCEPTED,
		LOW,
		NATIVE
	};

	extern std::string current_label;

}

namespace boinc_coords {
	extern bool packing_rotamers_now;
	extern FArray3D_float packer_xyz;
	extern FArray1D_bool allow_repack;
}

void
draw_rosetta_screensaver( int width, int height );

void
Structure_display ( graphics::GraphicsPoseType graphics_pose_type );

void
glVertex3fxyz( numeric::xyzVector_float coord);

void
display_wu_desc( float, float );

void
display_text( float, float, float, float, float );

void
writeString( const std::string & text_string) ;

void
writeBigString( const std::string & text_string) ;

void
chain_color( int const res, std::string label, float & red, float & green, float & blue );

void
rainbow_color( float const frac , float & red, float & green, float & blue, bool const mute_color = false );

void
set_show_graphics( bool const show_graphics_input);

void
draw_density_as_isocontour();

#endif
#endif
