// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_cenlist
#define INCLUDED_cenlist


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace cenlist_ns {


extern int const MAX_CENLIST;

//jg cen6(i) is the number of centoids within 6 Angstroms of residue i
//jg cen10(i) is the number of centoids within 10 Angstroms of residue i
//jg cen12(i)+cen6(i) is the number of centoids within 12 Angstroms of residue i

//cems fcenXX() is the real number analog of cenXX()

//jg cenlist(*,i) is the list of residues within 12 Angstroms of residue i
//jg cen12up(i) is the number of residues in cenlist(*,i)


namespace cenlist {
	extern FArray1D_int cen6;
	extern FArray1D_int cen12;
	extern FArray1D_int cen10;
	extern FArray1D_int cen12up;
	extern FArray2D_int cen_list;
	extern FArray1D_float fcen6;
	extern FArray1D_float fcen12;
	extern FArray1D_float fcen10;
}
using namespace cenlist;

//jg cendist(i,j) is the distance between centroids of residue i and j
//jg Although it's symmetric, both halves of the matrix are filled


namespace dists {
	extern FArray2D_float cendist;
	extern FArray2D_float best_cendist;
}
using namespace dists;


//------------------
//car Distance checks
//------------------
//car cutoffs for vdw_compute, hbonds
//car if cen-cen > 144 no atoms is residue can bump (12A)
//car if ca-ca > 49 no atom-atom bumps              (7A)
//car if ca-ca > 60 no atom-centroid bumps          (~7.75)
extern float const cen_dist_cutoff2;
extern float const ca_dist_cutoff2;
//car not in use:
//      float const ca_cen_dist_cutoff2 = 60.0;


//cems transition regions between environment bins
//cems transition is from +/- sqrt(36+pad6) +/- sqrt(100+pad10) etc
extern float const cen_dist5_pad;
extern float const cen_dist7_pad;
extern float const cen_dist6_pad;
extern float const cen_dist10_pad;
extern float const cen_dist12_pad;


}


#endif
