// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_chuck
#define INCLUDED_chuck


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// chuck Function Declarations


void
choose_chuck(
	int size,
	float & cutoff_max,
	int min_begin,
	int max_begin,
	int & best_frag,
	float & cost,
	int & frag_begin
);


void
find_chuck_moves(
	int size,
	float & cutoff,
	int min_begin,
	int max_begin,
	FArray1Da_float cut_cost,
	FArray1Da_int cut_frag,
	int & cut_count,
	int & frag_begin
);


void
cutoff_list(
	float & cutoff_max, // cutoffs for output list
	FArray2Da_float list_cost, // cost in input list
	FArray1Da_int list_frag, // frag # in input list
	int & list_count, // # of frags in input list
	FArray1Da_float cut_cost, // cost in returned list
	FArray1Da_int cut_frag, // fragment number in returned list
	int & count // number of frags in returned list
);


void
insert_frag(
	int length,
	int & size_bin,
	int & frag_begin,
	int & best_frag
);


void
calc_msd_best(
	int begin,
	int end,
	float & sum
);


void
chuck_move(
	int length,
	int & frag_begin,
	int & n_depth,
	FArray2Da_float position1,
	float const phi1,
	FArray2Da_float position2,
	float const phi2,
	FArray2Da_float position3,
	FArray1Da_float atom_weights,
	int & n_atom,
	float cutoff,
	int & best_frag, // index to best frag in align list
	float & cost, // cost of best frag
	FArray2Da_float list_cost,
	FArray1Da_int list_frag,
	int & count // total frags in list
);


FArray2DB_float const &
initialize_coord_sys();


void
compute_frag_move(
	FArray2Da_float position1,
	float const phi1,
	FArray2Da_float position2,
	float const phi2,
	FArray2Da_float G_mat,
	FArray1Da_float U2,
	FArray2Da_float ZtC_mat,
	FArray1Da_float O2
);


void
compute_stub_move(
	FArray2Da_float stub1,
	FArray2Da_float stub2,
	FArray2Da_float G_mat,
	FArray1Da_float U2,
	FArray2Da_float ZtC_mat,
	FArray1Da_float O2
);


void
chuck_recover_stub(
	FArray1Da_float ni2,
	FArray1Da_float ca2,
	FArray1Da_float cc2,
	float const ph,
	FArray1Da_float cc_out
);


void
chuck_choose_insertion(
	int min_begin,
	int max_begin,
	int & begin,
	int size,
	float cutoff,
	float & cutoff_out
);


void
precompute_chuck(
	int const frag_start,
	int const frag_depth,
	int const size_bin,
	FArray1Da_float ca1
);


#endif
