// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15540 $
//  $Date: 2007-06-19 18:37:31 -0400 (Tue, 19 Jun 2007) $
//  $Author: chu $

#include <iostream>
#include <iomanip>
#include "cluster_mutE.h"

int cluster_mutE::n_cluster_ = 0;

//===============================================================================================
// Default Constructor
//===============================================================================================

cluster_mutE::cluster_mutE():
  mutnum_( 0 ),
  mutID_( ++n_cluster_ )
{
}

//===============================================================================================
// Constructor
//===============================================================================================

cluster_mutE::cluster_mutE( int mutnum_a , std::string mut_type_a , Energies & energy_a ):
  mutnum_( mutnum_a ),
  mutID_( ++n_cluster_ ),
  mut_type( mut_type_a ),
  energy_( energy_a )
{
}

//===============================================================================================
// copy Constructor
//===============================================================================================

cluster_mutE::cluster_mutE(const cluster_mutE& thecluster_mutE):
  //  mutID_( thecluster_mutE.mutID()),
  mutnum_( thecluster_mutE.mutnum_ ),
  mut_type( thecluster_mutE.mut_type ),
  energy_( thecluster_mutE.energy_ )
{
}

//===============================================================================================
// Destructor
//===============================================================================================

cluster_mutE::~cluster_mutE()
{
}

void cluster_mutE::setcluster_mutE( int mutnum_a, std::string mut_type_a, Energies & energy_a )
{
  mutnum_ = mutnum_a;
  mut_type = mut_type_a;
  energy_ = energy_a;
}

cluster_mutE& cluster_mutE::operator = (const cluster_mutE &p)
{
  if (this != &p) //no need to assign to itself
    {
      (*this).mutnum_ = p.mutnum();
      (*this).mut_type = p.type();
      (*this).energy_ = p.energy_;
    }
  return (*this);
}

//===============================================================================================
// NON-MEMBER functions,operators
//===============================================================================================

bool operator == ( const cluster_mutE & p1 , const cluster_mutE & p2 )
{
  if (p1.mutnum()!= p2.mutnum())
    return false;
  if (p1.total_energy() != p2.total_energy())
    return false;
  int size1 = p1.number_of_energy_terms();
  int size2 = p1.number_of_energy_terms();
  if (size1 != size2)
    return false;
  for (int i = 0; i < size1; ++i)
    {
      if (p1.each_energy(i) != p2.each_energy(i))
	return false;
    }
  return true;
}

bool operator != ( const cluster_mutE & p1 , const cluster_mutE & p2 )
{
  return !( p1 == p2 );
}

bool display_order( const cluster_mutE *p1, const cluster_mutE *p2 )
{
  if ( (*p1).total_energy() < (*p2).total_energy() )
    return true;
  else if ( (*p1).total_energy() > (*p2).total_energy() )
    return false;
  else if ( (*p1).mutnum() < (*p2).mutnum() )
    return true;
  else if ( (*p1).mutnum() > (*p2).mutnum() )
    return false;
  else if ( (*p1).mutID() < (*p2).mutID() )
    return true;
  else
    return false;
}

std::ostream &
operator << ( std::ostream & os, const cluster_mutE & p )
{
  using std::setw;

  //Save current stream state and set persistent state

  std::ios_base::fmtflags const old_flags = os.flags();
  int const old_precision = os.precision();

  //output array to stream
  os << setw( 4 ) << p.mutID( );
  os.precision( 2 );
  os.setf( std::ios::fixed | std::ios::showpoint );
  int number = p.number_of_energy_terms( );
  for ( int i = 0; i < number; ++i )
    os <<setw(8) << p.each_energy( i );

  os<<setw( 6 ) << p.mutnum() << "  ( "<<p.type() << ")" << '\t';

  //Restore previous stream state
  os.precision( old_precision );
  os.flags( old_flags );
  return os;
}
