// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_connect_templates
#define INCLUDED_connect_templates


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

void
init_jmp_loops();

void
links_to_tree(
  FArray2DB_int const & links,
	int const nlinks,
	FArray1DB_int const & cuts,
	int const ncuts,
	FArray3Da_float Eposition,
	int const total_residue
);

void
connect_template(
	FArray1DB_int & connectableResidues,
	int & N,                // previously linkCounter
	int & D,                // instead of (total_res)^2, it's smaller
	FArray1DB_int & TemplateRegions,
	FArray2DB_int & edgeList,
	int & number_of_edges,
	FArray1DB_int & breaks,
	int & b_count
);


void
setup_links(
	FArray2DB_int & edgeList,
	int & LOEL,   // LOEL is the Legnth of Edge List
	FArray1DB_int & breakpointsList,  // all the breakpoints
	int & LOBL   // LOBL is the Length Of Breakpoints List
);


void
sortDistances(
	int n,               // is the total number of distances
	FArray2Da_float ra
);


void
createEdgeList(
	FArray2DB_float & distMatrix,
	int & LODM,
	int & a,
	FArray2DB_int & edgeList,
	int & N,          // N is the number of edges
	int & index       // which edge we currently are writing
);


void
createDistances(
	FArray2DB_float & chain, // c-alpha chain
	int & M,
	FArray2DB_float & distances,// distances between residues
	FArray1DB_int & TR,         // TemplateRegions
	FArray1DB_int & connectR,   // which regions are connected
	int & N,
	int & actual_length_of_distances_matrix
);


void
calc_distance(
	FArray2DB_float & chain,
	int & M,
	int & res1,
	int & res2,
	float & distance
);


void
connect_template_regions(
	FArray2DB_float & sorted_dist,
	int & L,           // L is number of distances
	FArray1DB_int & TR,  // TemplateRegions
	int & M,           // M is the number of residues
	int & N,        // N is the total # of connectable residues
	int & numTR,       // the number of Template Regions
	int & number_of_edges // the final number of edges linked
);


void
getSecStructAndAssign(
	int & beginTemplate,
	int & endTemplate,
	FArray1DB_int & Template,
	FArray1DB_int & connectableResidues,
	int & linkCounter,
	FArray1DB_int & breakpoint,
	int & b_count        // the breakpoints counter
);


void
connectRegion(
	int & first,
	int & numOf,               // the number of residues
	int & last,
	int & linkCounter,
	FArray1DB_int & Template,
	FArray1DB_int & linkables,   // usually: connectableResidues
	int const center_width         // the parameter middle_width
);


void
findCenter(
	int const begin,
	int const ending,
	int const length_of_middle,
	int & startPoint
);


bool
integer_is_even( int & num );


void
prolineExists(
	int const current_res,
	bool & exists
);

void
hpsort_array(
	int const n,
	FArray2DB_int & ra,
	int const size,
	int const key
);


#endif
