// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 01:39:36 -0500 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

// This code is using linux specific socket libraries
#ifdef __linux__

// Rosetta Headers
#include "analyze_interface_ddg.h"
#include "after_opts.h"
#include "assemble_domains.h"
#include "barcode_stats.h"
#include "constraints.h"
#include "decoystats.h"
#include "design_structure.h"
#include "dock_structure.h"
#include "files_paths.h"
#include "fold_abinitio.h"
#include "fold_abinitio_csa.h"
#include "fold_loops.h"
#include "fold_membrane.h"
#include "fragments_ns.h"
#include "force_barcode.h"
#include "idealize.h"
#include "initialize.h"
#include "namespace_options.h"
#include "output_decoy.h"
#include "param.h"
#include "pdbstats.h"
#include "refine_structure.h"
#include "relax_structure.h"
#include "repeat.h"
#include "score_ns.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <string>
#include <sstream>


// Socket Communication headers
#include <unistd.h>
#include "socketcom.h"


//Utility Headers
#include <utility/basic_sys_util.hh>

////////////////////////////////////////////////////////////////////////////////
/// @begin output_decoy
///
/// @brief
///
/// @detailed
///
/// @param mode - rosetta mode as in main
///        ipadress - string containing the ip address of the server (from -srvip)
///        port     - integer containg the port address of the server (from -srvport)
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////

int
rosetta_client_mode(const std::string &mode,
										const std::string &ipaddress,
										const unsigned port)
{

	using namespace files_paths;
	using namespace options;
	using namespace param;

	using namespace fragments ;
	using namespace choose_frag_parm;

	std::string status;

	bool accepted,fail;

	int num_decoys;
	int attempted_decoys;
	int starting_pdbs_skipped;

	num_decoys = 0;
	attempted_decoys = 0;
	starting_pdbs_skipped = 0;

	int ii = 1, i = 0; // Used outside of loops

	// Initialise server connection etc..

	bool finish=false;
	int  sockfd;
	int  error;
	int  myid = -1;
	int  myid_tries = 0;
	int  irun = 0;
	int  structureid=0;
	int  failures = 0;

	std::cout << "CLNT: Running in client mode "  << std::endl;
	std::cout << "CLNT: Server: " << ipaddress << ":" << port << std::endl;

	std::string newfile;
	std::string filename="";

	std::stringstream *pdbinbuffer=NULL;   // memory buffers to contain the PDB coordinates
	std::stringstream *pdboutbuffer=NULL;

	std::string controlstruct;


	// dont print the contraints into the pdb file to reduce bandwidth (by 50%!)
	classical_constraints::BOUNDARY::set_verbose_pdb_output(false);

	do{
		if((sockfd = setup_connection_to_server(port,ipaddress.c_str(),
			2000,2500))<0){
				std::cerr << "Unable to connect to server after 100000 attempts" << std::endl;
				return -1;
			}
			// first of all request an ID !
			myid = request_new_id(sockfd);
			if(myid < 0){
				std::cerr << "Failed to receive ID  .. attempt " << myid_tries << std::endl;
				myid_tries++;
				sillywait(2000);
			}else{
				std::cout << "Received ID:  " << myid << std::endl;
			}

			close(sockfd);

	}while((myid<0)&&(myid_tries<200));


	// ====== This is the main loop =======================================
	while(!finish){
		if((sockfd = setup_connection_to_server(port,ipaddress.c_str(),
																						2000,2500))<0){
			std::cerr << "Unable to connect to server after 1000 attempts" << std::endl;
			return -1;
		}


		bool havefilename=true;
		if(filename=="") havefilename = false;

		std::string recdatabuffer_stl;
		std::string pdboutbuf_string;
		if(pdboutbuffer != NULL) pdboutbuf_string = pdboutbuffer->str();
		else              		   pdboutbuf_string = "";

		error = request_new_structure(sockfd,
																	pdboutbuf_string,
																	structureid,
																	controlstruct,
																	recdatabuffer_stl);

		start_file = "new";
		close(sockfd);
		switch(error){
			case 0:
				failures=0;
				check_ss = false;
				break;
			case 1:
				std::cout << "CLNT: No further structures .. finishing" << std::endl;
				finish = true;
				failures=0;
				continue;            // jumps to front of 'while' loop, which will then terminat
			case 2:
				start_file = "none"; // will signal to initialize_start(...)
				// to create an extended starting structure
				check_ss = true;
				failures=0;
				break;
			case 3:
				std::cout << "CLNT: Idling .. " << std::endl;
				sillywait(100);      // waste CPU for a bit
				failures=0;
				continue;            // returns to front of 'while' loop
			default:
				failures++;
				std::cout << "CLNT: Error exchanging pdb files - failure "<< failures << std::endl;
				if(failures < 20){
					std::cout << "CLNT: Idling .. " << std::endl;
					sillywait(100); // waste CPU for a bit
					continue;       // returns to front of 'while' loop
				}else{
					std::cout << "CLNT: Failures > 20 - Quitting... " << std::endl;
					return -1;
				}
		}

		if(recdatabuffer_stl.empty()){
			start_file = "none";  // signal to initialize_start to generate an extended structure
			initialize_start( mode, ii, 10000000, status, NULL);
			std::cout << "received extended\n";
		}else{

			std::cout << "received structure\n";
			recdatabuffer_stl += "\n";
			//debug: print the contents of the received file
			//std::cout<<recdatabuffer_stl<<"end"<<std::endl;
			pdbinbuffer = new std::stringstream ( recdatabuffer_stl );
			initialize_start( mode, ii, 10000000, status, pdbinbuffer);
		}

		if ( status == "fail" ) {
			std::cout << "CLNT: ERROR: starting coordinates were not obtained" << std::endl;
			std::cout << "CLNT: ERROR: Requesting new structure" << std::endl;
			continue;
		}

		if( status != "okay" ){
			std::cout << "CLNT: ERROR: Status not okay - does file already exist ?" << std::endl;
			return -1;
		}

		i=myid*1000;

		i++;
		barcode_initialize_decoy(); // should happen before the goto L200

		do{
			initialize_decoy();
			std::cout << "Mode: " << mode << std::endl;
			if ( mode == "loops" ) {
				fold_loops();
			} else if ( mode == "assemble" ) {
				assemble_domains();
			} else if ( mode == "refine" ) {
				refine_structure();
			} else if ( mode == "design" ) {
				design_structure();
			} else if ( mode == "dock" ) {
				dock_structure( fail );
				if ( fail ) continue;
			} else if ( mode == "relax" ) {
				relax_structure();
			} else if ( mode == "idealize" ) {
				idealize(fail);
				if ( fail ) continue;
			} else if ( mode == "membrane" ) {
				fold_membrane();
			} else if ( mode == "abinitio" ) {    // so far only tested with this mode

				if(controlstruct.size() < 64){
					std::cout << "Code Error in csa_main.cc line " << __LINE__ << std::endl;
					utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
				}
				abinitio_control abinitio_struct_ptr;
				memcpy((void*)&abinitio_struct_ptr,(void*)controlstruct.data(), sizeof(abinitio_struct_ptr));
				std::cout<<"DEBUG: Control structure: "<<std::endl;
				std::cout<<abinitio_struct_ptr.stage1_ncycles<<std::endl;
				std::cout<<abinitio_struct_ptr.stage2_ncycles<<std::endl;
				std::cout<<abinitio_struct_ptr.stage3_nloops <<std::endl;
				std::cout<<abinitio_struct_ptr.stage3_ncycles<<std::endl;
				std::cout<<abinitio_struct_ptr.stage4_nloops <<std::endl;
				std::cout<<abinitio_struct_ptr.stage4_ncycles<<std::endl;
				structureid = abinitio_struct_ptr.id;  // remember current structure id
				fold_abinitio_csa(
					abinitio_struct_ptr.stage1_ncycles,
					abinitio_struct_ptr.stage2_ncycles,
					abinitio_struct_ptr.stage3_nloops,
					abinitio_struct_ptr.stage3_ncycles,
					abinitio_struct_ptr.stage4_nloops,
					abinitio_struct_ptr.stage4_ncycles);
			} else if ( mode == "pdbstats" ) {
				get_pdbstats();
			} else if ( mode == "interface" ) {
				analyze_interface_ddg();
			} else if ( mode == "bc_stats" ) {
				get_barcode_stats();
			}

			++attempted_decoys;

			delete pdboutbuffer; // clear previous strstream buffer
			pdboutbuffer = new std::stringstream; // make new one


			// output decoy into buffer
			output_decoy_mem(*pdboutbuffer,accepted);

			if(!accepted){
				structureid = -1; // mark the structure as not accepted
				break;            // mtyka added 171005 - prevents infinite loops
			}


		}while(!accepted);

		++num_decoys;
		irun++;
	}

	if((sockfd = setup_connection_to_server(port,ipaddress.c_str(),
		2000,2500))<0){
			std::cerr << "CLNT: Unable to connect to server after 1000 attempts" << std::endl;
			return -1;
	}
	request_logoff(sockfd,myid);

	delete pdboutbuffer;
	delete pdbinbuffer;

	return 0;  // all ok
}


int
rosetta_client_mode_main(const std::string &mode)
{
	using namespace files_paths;
	using namespace options;
	using namespace param;

	require_start    = false;  // turn this off for all modes

	std::string srvaddr;
	stringafteroption(std::string("srvip"),std::string("127.0.0.1"),srvaddr);
	int  port;
	intafteroption(std::string("srvport"),3940,port);

	if(rosetta_client_mode(mode,srvaddr,port)!=0){
		std::cerr << "CLNT: Error occured in rosetta_client_mode(); " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	return 0;
}

#else



// The above code is using linux specific socket libraries
// When compiled under Windows or Mac OS X and run in the client mode
// this function will output a warning to the user

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>

//Utility Headers
#include <utility/basic_sys_util.hh>

int
rosetta_client_mode_main(const std::string &mode)
{
	std::cerr << "ERROR:  Rosetta client mode ( " << mode
		<< " is currently only implemented on linux platforms " << std::endl;
	utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	return 0;
}


#endif
