// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7523 $
//  $Date: 2006-02-20 15:10:59 -0800 (Mon, 20 Feb 2006) $
//  $Author: jiangl $

//////////////////////////////////////////////

// Rosetta Headers
#include "cst_allow_move.h"
#include "enzyme_ns.h"
#include "pose.h"

// Utility Headers

// ObjexxFCL Headers

// C++ Headers

namespace cst_allow_move_ns {

  /////////////////////////////////////////////////////////////////////////////
  //lin method for set_allow_move by giving the costraint
  //lin for bond length
  void
  set_bond_length_allow_move(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2 )
  {
    kin::Atom const * p_a1( pose.get_atom_tree_atom( a1.atomno(), a1.rsd() ) );
    kin::Atom const * p_a2( pose.get_atom_tree_atom( a2.atomno(), a2.rsd() ) );

// 		std::cout<<"dis_allow_move: "<<a1<<" "<<a2<<" "
// 						 << p_a1->parent->atom_id<<" "<<p_a2->parent->atom_id<<std::endl;

    if( p_a1->parent == p_a2 && p_a2->fixed_downstream(p_a1,kin::RB_TRANSLATION) ) {
      pose.set_allow_move( a1, kin::D, true );
    }else if( p_a2->parent == p_a1 && p_a1->fixed_downstream(p_a2,kin::RB_TRANSLATION) ) {
      pose.set_allow_move( a2, kin::D, true );
    }
  }

  /////////////////////////////////////////////////////////////////////////////
  //lin for bond angle
  void
  set_bond_angle_allow_move(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
    kin::Atom_id const & a3 )
  {

    kin::Atom const * p_a1( pose.get_atom_tree_atom( a1.atomno(), a1.rsd() ) );
    kin::Atom const * p_a2( pose.get_atom_tree_atom( a2.atomno(), a2.rsd() ) );
		kin::Atom const * p_a3( pose.get_atom_tree_atom( a3.atomno(), a3.rsd() ) );

// 		std::cout<<"angle_allow_move: "<<a1<<" "<<a2<<" "<<a3<<" "
// 						 <<p_a1->parent->atom_id<<" "<<p_a3->parent->atom_id<<" "
// 						 <<p_a1->downstream( p_a3 )<<" "<<p_a3->downstream( p_a1 )<<std::endl;

    if( p_a1->parent == p_a2 && //maybe parent relation is not necessary
				( p_a3->fixed_downstream(p_a2,kin::RB_ROTATION) ||
					p_a2->fixed_downstream(p_a3,kin::RB_ROTATION) ) &&
				p_a2->fixed_downstream(p_a1,kin::RB_ROTATION) ) {
      pose.set_allow_move( a1, kin::THETA, true );
    } else if ( p_a3->parent == p_a2 &&
								( p_a1->fixed_downstream(p_a2,kin::RB_ROTATION) ||
									p_a2->fixed_downstream(p_a1,kin::RB_ROTATION) ) &&
								p_a2->fixed_downstream(p_a3,kin::RB_ROTATION) ) {
      pose.set_allow_move( a3, kin::THETA, true );
    }
  }


  /////////////////////////////////////////////////////////////////////////////
  //lin for torsion angle
  void
  set_torsion_angle_allow_move(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
    kin::Atom_id const & a3,
    kin::Atom_id const & a4 )
  {

		if( ( a1.rsd() != a2.rsd() ) && ( a3.rsd() != a4.rsd() ) ) return;

    kin::Atom const * p_a1( pose.get_atom_tree_atom( a1.atomno(), a1.rsd() ) );
    kin::Atom const * p_a2( pose.get_atom_tree_atom( a2.atomno(), a2.rsd() ) );
    kin::Atom const * p_a3( pose.get_atom_tree_atom( a3.atomno(), a3.rsd() ) );
    kin::Atom const * p_a4( pose.get_atom_tree_atom( a4.atomno(), a4.rsd() ) );

// 		std::cout<<"torsion_allow_move: "<<a1<<" "<<a2<<" "<<a3<<" "<<a4<<" "
// 						 <<p_a2->parent->atom_id<<" "<<p_a3->parent->atom_id<<" "
// 						 <<p_a2->downstream( p_a4 )<<" "<<p_a2->fixed_downstream( p_a1, kin::PHI )<<" "
// 						 <<p_a3->downstream( p_a1 )<<" "<<p_a3->fixed_downstream( p_a4, kin::PHI )<<std::endl;

		if(  p_a2->parent == p_a3 && //maybe parent relation is not necessary
				 ( p_a4->fixed_downstream( p_a3, kin::RB_ROTATION ) ||
					 p_a3->fixed_downstream( p_a4, kin::RB_ROTATION ) ) &&
				 p_a3->fixed_downstream( p_a2, kin::RB_ROTATION ) &&
				 p_a2->fixed_downstream( p_a1, kin::RB_ROTATION ) ) {
      //instead of setting a1 allow_move, set the first child of a2 allow_move
      pose.set_allow_move( p_a2->child(0)->atom_id, kin::PHI, true );
    } else if ( p_a3->parent == p_a2 && //maybe parent relation is not necessary
								( p_a1->fixed_downstream( p_a2, kin::RB_ROTATION ) ||
									p_a2->fixed_downstream( p_a1, kin::RB_ROTATION ) ) &&
								p_a2->fixed_downstream( p_a3, kin::RB_ROTATION ) &&
								p_a3->fixed_downstream( p_a4, kin::RB_ROTATION ) ) {
      pose.set_allow_move( p_a3->child(0)->atom_id, kin::PHI, true );
    }
  }

  /////////////////////////////////////////////////////////////////////////////
  //lin method for set_atom_torsion by giving the costraint
  //lin for bond length
  void
  set_bond_length(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
		float dis )
  {
    kin::Atom const * p_a1( pose.get_atom_tree_atom( a1.atomno(), a1.rsd() ) );
    kin::Atom const * p_a2( pose.get_atom_tree_atom( a2.atomno(), a2.rsd() ) );

    if( p_a1->parent == p_a2 && p_a2->fixed_downstream(p_a1,kin::RB_TRANSLATION)  ) {
      pose.set_atom_tree_torsion( a1, kin::D, dis );
    }else if( p_a2->parent == p_a1 && p_a1->fixed_downstream(p_a2,kin::RB_TRANSLATION) ) {
      pose.set_atom_tree_torsion( a2, kin::D, dis );
    }
  }

  /////////////////////////////////////////////////////////////////////////////
  //lin for bond angle
  void
  set_bond_angle(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
    kin::Atom_id const & a3,
		float ang )
  {

    kin::Atom const * p_a1( pose.get_atom_tree_atom( a1.atomno(), a1.rsd() ) );
		kin::Atom const * p_a2( pose.get_atom_tree_atom( a2.atomno(), a2.rsd() ) );
		kin::Atom	const * p_a3( pose.get_atom_tree_atom( a3.atomno(), a3.rsd() ) );

    if( p_a1->parent == p_a2 && //maybe parent relation is not necessary
				( p_a3->fixed_downstream(p_a2,kin::RB_ROTATION) ||
					p_a2->fixed_downstream(p_a3,kin::RB_ROTATION) ) &&
				p_a2->fixed_downstream(p_a1,kin::RB_ROTATION) ) {
      pose.set_atom_tree_torsion( a1, kin::THETA, ang );
    } else if (p_a3->parent == p_a2 &&
								( p_a1->fixed_downstream(p_a2,kin::RB_ROTATION) ||
									p_a2->fixed_downstream(p_a1,kin::RB_ROTATION) ) &&
								p_a2->fixed_downstream(p_a3,kin::RB_ROTATION) ) {
      pose.set_atom_tree_torsion( a3, kin::THETA, ang );
    }
  }


  /////////////////////////////////////////////////////////////////////////////
  //lin for torsion angle
  void
  set_torsion_angle(
    pose_ns::Pose & pose,
    kin::Atom_id const & a1,
    kin::Atom_id const & a2,
    kin::Atom_id const & a3,
    kin::Atom_id const & a4,
		float tor )
  {

		if( ( a1.rsd() != a2.rsd() ) && ( a3.rsd() != a4.rsd() ) ) return;

		kin::Atom const * p_a1( pose.get_atom_tree_atom( a1.atomno(), a1.rsd() ) );
		kin::Atom const * p_a2( pose.get_atom_tree_atom( a2.atomno(), a2.rsd() ) );
		kin::Atom const * p_a3( pose.get_atom_tree_atom( a3.atomno(), a3.rsd() ) );
		kin::Atom const * p_a4( pose.get_atom_tree_atom( a4.atomno(), a4.rsd() ) );

		if(  p_a2->parent == p_a3 && //maybe parent relation is not necessary
				 ( p_a4->fixed_downstream( p_a3, kin::RB_ROTATION ) ||
					 p_a3->fixed_downstream( p_a4, kin::RB_ROTATION ) ) &&
				 p_a3->fixed_downstream( p_a2, kin::RB_ROTATION ) &&
				 p_a2->fixed_downstream( p_a1, kin::RB_ROTATION ) ) {
      //instead of setting a1 allow_move, set the first child of a2 allow_move
			float theta0 ( pose.get_atom_tree_torsion( p_a2->child(0)->atom_id.atomno(),
																								 p_a2->child(0)->atom_id.rsd(),
																								 kin::PHI ) );
			float theta ( pose.get_torsion_angle( p_a4->atom_id, p_a3->atom_id,
																						p_a2->atom_id, p_a1->atom_id ) );
			float offset ( theta-theta0 );
      pose.set_atom_tree_torsion( p_a2->child(0)->atom_id, kin::PHI, tor-offset );
    } else if ( p_a3->parent == p_a2 && //maybe parent relation is not necessary
								( p_a1->fixed_downstream( p_a2, kin::RB_ROTATION ) ||
									p_a2->fixed_downstream( p_a1, kin::RB_ROTATION ) ) &&
								p_a2->fixed_downstream( p_a3, kin::RB_ROTATION ) &&
								p_a3->fixed_downstream( p_a4, kin::RB_ROTATION ) ) {
			float theta0 ( pose.get_atom_tree_torsion( p_a3->child(0)->atom_id.atomno(),
																								 p_a3->child(0)->atom_id.rsd(),
																								 kin::PHI ) );
			float theta ( pose.get_torsion_angle( p_a1->atom_id, p_a2->atom_id,
																						p_a3->atom_id, p_a4->atom_id ) );
			float offset ( theta-theta0 );
      pose.set_atom_tree_torsion( p_a3->child(0)->atom_id, kin::PHI, tor-offset );
    }
  }


  /////////////////////////////////////////////////////////////////////////////
	void Allow_move_set::set_pose_allow_move( pose_ns::Pose & pose ) const
	{
		for( int ii=0,ie=dis_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( dis_allow_move_[ii].atom1 ) &&
					pose.match_aa_aav( dis_allow_move_[ii].atom2 ) ){
				set_bond_length_allow_move( pose, dis_allow_move_[ii].atom1, dis_allow_move_[ii].atom2 );
			}
		}

		for( int ii=0,ie=angle_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( angle_allow_move_[ii].atom1 ) &&
					pose.match_aa_aav( angle_allow_move_[ii].atom2 ) &&
					pose.match_aa_aav( angle_allow_move_[ii].atom3 ) ){
				set_bond_angle_allow_move( pose, angle_allow_move_[ii].atom1,
																	 angle_allow_move_[ii].atom2, angle_allow_move_[ii].atom3 );
			}
		}

		for( int ii=0,ie=torsion_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( torsion_allow_move_[ii].atom1) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom2 ) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom3 ) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom4 ) ) {
				set_torsion_angle_allow_move( pose, torsion_allow_move_[ii].atom1,
							torsion_allow_move_[ii].atom2, torsion_allow_move_[ii].atom3,
							torsion_allow_move_[ii].atom4 );
			}
		}
	}

  /////////////////////////////////////////////////////////////////////////////
	int Allow_move_set::conformer_counter( pose_ns::Pose & pose )
	{
		int counter (1);
		int dimension (0);
		conf_dimension_list_.clear();

		for( int ii=0,ie=dis_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( dis_allow_move_[ii].atom1 ) &&
					pose.match_aa_aav( dis_allow_move_[ii].atom2 ) ){
				if( dis_allow_move_[ii].conf_N > 0 ) {
					dimension = 2*dis_allow_move_[ii].conf_N+1 ;
					conf_dimension_list_.push_back(dimension);
					counter *= dimension;
				}
			}
		}

		for( int ii=0,ie=angle_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( angle_allow_move_[ii].atom1 ) &&
					pose.match_aa_aav( angle_allow_move_[ii].atom2 ) &&
					pose.match_aa_aav( angle_allow_move_[ii].atom3 ) ){
				if( angle_allow_move_[ii].conf_N > 0 ) {
					dimension = 2*angle_allow_move_[ii].conf_N+1;
					conf_dimension_list_.push_back(dimension);
					counter *= dimension;
				}
				if( angle_allow_move_[ii].ang_N > 0 ) {
					dimension = angle_allow_move_[ii].ang_N+1;
					conf_dimension_list_.push_back(dimension);
					counter *= dimension;
				}
			}
		}

		for( int ii=0,ie=torsion_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( torsion_allow_move_[ii].atom1) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom2 ) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom3 ) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom4 ) ) {
				if( torsion_allow_move_[ii].conf_N > 0 ) {
					dimension = 2*torsion_allow_move_[ii].conf_N+1;
					conf_dimension_list_.push_back(dimension);
					counter *= dimension;
				}
				if( torsion_allow_move_[ii].tor_N > 0 ) {
					dimension = torsion_allow_move_[ii].tor_N+1;
					conf_dimension_list_.push_back(dimension);
					counter *= dimension;
				}
			}
		}

		if( enzyme::safety_check ) {
			std::cout<<"counter_list:";
			for( int ii=0,ie=conf_dimension_list_.size();ii<ie;ii++) {
				std::cout<<" "<<conf_dimension_list_[ii];
			}
			std::cout<<std::endl;
		}

		//resert the internal index;
		conf_index_=0;
		conf_counter_=counter;

		return counter;
	}

  /////////////////////////////////////////////////////////////////////////////
	void Allow_move_set::conformer( pose_ns::Pose & pose )
	{
		float const pi( numeric::constants::d::pi );
		int degree =0;
		int counter_index ( conf_index_ );
		for( int ii=0,ie=dis_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( dis_allow_move_[ii].atom1 ) &&
					pose.match_aa_aav( dis_allow_move_[ii].atom2 ) ){
				if( dis_allow_move_[ii].conf_N > 0 && dis_allow_move_[ii].dis_sd > 0. ) {
					float const increase ( dis_allow_move_[ii].dis_sd/float(dis_allow_move_[ii].conf_N) );
					int const i ( counter_index % conf_dimension_list_[degree] );
					counter_index /= conf_dimension_list_[degree]; degree++;
					if( enzyme::safety_check ) std::cout<<"set_bond_length: "<<dis_allow_move_[ii].dis
									 <<" "<<dis_allow_move_[ii].dis_sd<<" "
									 <<conf_index_<<" "<<i<<" "<<increase<<std::endl;
					set_bond_length( pose, dis_allow_move_[ii].atom1, dis_allow_move_[ii].atom2,
													 dis_allow_move_[ii].dis - dis_allow_move_[ii].dis_sd + i*increase );
				}
			}
		}

		for( int ii=0,ie=angle_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( angle_allow_move_[ii].atom1 ) &&
					pose.match_aa_aav( angle_allow_move_[ii].atom2 ) &&
					pose.match_aa_aav( angle_allow_move_[ii].atom3 ) ){
				if( ( angle_allow_move_[ii].conf_N > 0  && angle_allow_move_[ii].ang_sd > 0. )
						|| angle_allow_move_[ii].ang_N > 0  ) {
					int i=0, j=0;
					float increase=0., period=0.;
					if( angle_allow_move_[ii].conf_N > 0 && angle_allow_move_[ii].ang_sd > 0. ) {
						increase = angle_allow_move_[ii].ang_sd/float(angle_allow_move_[ii].conf_N) ;
						i = counter_index % conf_dimension_list_[degree] ;
						counter_index /= conf_dimension_list_[degree]; degree++;
					}
					if( angle_allow_move_[ii].ang_N > 0 ) {
						period = 2*pi/float(angle_allow_move_[ii].ang_N+1) ;
						j = counter_index % conf_dimension_list_[degree] ;
						counter_index /= conf_dimension_list_[degree]; degree++;
					}
					if( enzyme::safety_check ) std::cout<<"set_bond_angle: "<<angle_allow_move_[ii].ang
									 <<" "<<angle_allow_move_[ii].ang_sd<<" "
									 <<conf_index_<<" "<<i<<" "<<increase<<" "<<j<<" "<<period<<std::endl;
					set_bond_angle( pose, angle_allow_move_[ii].atom1, angle_allow_move_[ii].atom2,
													angle_allow_move_[ii].atom3,
													angle_allow_move_[ii].ang - angle_allow_move_[ii].ang_sd
													+ i*increase + j*period );
				}
			}
		}

		for( int ii=0,ie=torsion_allow_move_.size(); ii<ie; ++ii ) {
			if( pose.match_aa_aav( torsion_allow_move_[ii].atom1 ) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom2 ) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom3 ) &&
					pose.match_aa_aav( torsion_allow_move_[ii].atom4 ) ) {
				if( ( torsion_allow_move_[ii].conf_N > 0 && torsion_allow_move_[ii].tor_sd > 0. )
						|| torsion_allow_move_[ii].tor_N > 0  ) {
					int i=0, j=0;
					float increase=0., period=0.;
					if( torsion_allow_move_[ii].conf_N > 0 ) {
						increase = torsion_allow_move_[ii].tor_sd/float(torsion_allow_move_[ii].conf_N) ;
						i = counter_index % conf_dimension_list_[degree] ;
						counter_index /= conf_dimension_list_[degree]; degree++;
					}
					if( torsion_allow_move_[ii].tor_N > 0 ) {
						period = 2*pi/float(torsion_allow_move_[ii].tor_N+1) ;
						j = counter_index % conf_dimension_list_[degree] ;
						counter_index /= conf_dimension_list_[degree]; degree++;
					}
					if( enzyme::safety_check ) std::cout<<"set_torsion_angle: "<<torsion_allow_move_[ii].tor
									 <<" "<<torsion_allow_move_[ii].tor_sd<<" "
									 <<conf_index_<<" "<<i<<" "<<increase<<" "<<j<<" "<<period<<std::endl;
					set_torsion_angle( pose, torsion_allow_move_[ii].atom1, torsion_allow_move_[ii].atom2,
													torsion_allow_move_[ii].atom3, torsion_allow_move_[ii].atom4,
													torsion_allow_move_[ii].tor - torsion_allow_move_[ii].tor_sd
													+ i*increase + j*period );
				}
			}
		}

		conf_index_++;
	}

	////////////////////////////////////////////////////////////////////////////
	std::ostream& operator<< ( std::ostream& s, const Allow_move_set& d ) {
		s<<"ALLOW_MOVE information: "<<std::endl;
		s<<"\tdis_allow_mov: \n";
		for( int ii=0,ie=d.dis_allow_move_.size(); ii<ie; ++ii ) {
			s<<"\t\t( "<<d.dis_allow_move_[ii].atom1<<" , "
			 <<d.dis_allow_move_[ii].atom2<<" ) dis "<<d.dis_allow_move_[ii].dis
			 <<" sd "<<d.dis_allow_move_[ii].dis_sd<<" conf_N "
			 <<d.dis_allow_move_[ii].conf_N<<std::endl;
		}
		s<<"\n\tangle_allow_move: \n";
		for( int ii=0,ie=d.angle_allow_move_.size(); ii<ie; ++ii ) {
			s<<"\t\t( "<<d.angle_allow_move_[ii].atom1<<" , "
			 <<d.angle_allow_move_[ii].atom2 <<" , "
			 <<d.angle_allow_move_[ii].atom3<<" ) ang "<<d.angle_allow_move_[ii].ang
			 <<" sd "<<d.angle_allow_move_[ii].ang_sd<<" conf_N "
			 <<d.angle_allow_move_[ii].conf_N<<" ang_N "
			 <<d.angle_allow_move_[ii].ang_N<<std::endl;
		}
		s<<"\n\ttorison_allow_move: \n";
		for( int ii=0,ie=d.torsion_allow_move_.size(); ii<ie; ++ii ) {
			s<<"\t\t( "<<d.torsion_allow_move_[ii].atom1<<" , "
			 <<d.torsion_allow_move_[ii].atom2 <<" , "
			 <<d.torsion_allow_move_[ii].atom3 <<" , "
			 <<d.torsion_allow_move_[ii].atom4<<" ) tor "<<d.torsion_allow_move_[ii].tor
			 <<" sd "<<d.torsion_allow_move_[ii].tor_sd<<" conf_N "
			 <<d.torsion_allow_move_[ii].conf_N<<" tor_N "
			 <<d.torsion_allow_move_[ii].tor_N<<std::endl;
		}
		return s;
	}
}
