// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7523 $
//  $Date: 2006-02-20 15:10:59 -0800 (Mon, 20 Feb 2006) $
//  $Author: jiangl $

//////////////////////////////////////////////
#ifndef INCLUDED_cst_descriptor
#define INCLUDED_cst_descriptor

// Rosetta Headers
#include "cst_countpair.h"
#include "cst_packer.h"
#include "cst_set.h"
#include "param_aa.h"
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/Fstring.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/string.functions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Numeric Headers
#include <numeric/conversions.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <map>
#include <list>
#include <vector>

//////////////////////////////////
//lin  the Cst_descriptor object holds data which is used to define the
//lin  constraint set contacting with the pose and packer
//

namespace cst_descriptor_ns {

	//lin define the template atoms
  class template_atom {
  public:
    template_atom(){};
    template_atom(int ta1, int ta2, int ta3, int aa_in, int aav_in):
      aa( aa_in ),
      aav( aav_in )
      { template_id.assign(ta1,ta2,ta3);  cleanup(); };
    template_atom(
      numeric::xyzVector_int const & template_id_in,
      int aa_in, int aav_in):
      aa( aa_in ),
      aav( aav_in )
      { template_id=template_id_in; cleanup(); };
    void cleanup();
    friend std::ostream& operator<< ( std::ostream& s, const template_atom& d );

    numeric::xyzVector_int template_id;
    int aa, aav, type;
    float bond12, bond23, ang123;
    //std::vector<numeric::xyzVector_float> template_fullcoords;
  };

	//lin  define the geometrical constraint parameters
  class cst_parameters {
  public:

    cst_parameters(){zero_cstparam();};

		inline void set_all_move(bool const setting) {
			move_disAB=setting;move_angA=setting;
			move_angB=setting;move_dihA=setting;move_dihB=setting;move_dihAB=setting;

		}

    void zero_cstparam( ) {
			is_covalent=false;
			set_all_move(false);
      disAB = 0.; angA = 0.; angB = 0.;
      dihA = 0.;  dihB = 0.; dihAB = 0.;
      disAB_sd = 0.; angA_sd = 0.; angB_sd = 0.;
      dihA_sd = 0.;  dihB_sd = 0.; dihAB_sd = 0.;
      disAB_k = 0.; angA_k = 0.; angB_k = 0.;
      dihA_k = 0.;  dihB_k = 0.; dihAB_k = 0.;
      angA_periodic = 180.; angB_periodic = 180.;
      dihA_periodic = 180.;  dihB_periodic = 180.; dihAB_periodic = 180.;
			dihA_func = "HARMONIC"; dihB_func = "HARMONIC"; dihAB_func = "HARMONIC";
    };

    inline bool empty() const {
      return ( disAB_k == 0. && angA_k == 0. && angB_k == 0. &&
	  dihA_k == 0. && dihB_k == 0. && dihAB_k == 0. ) ;
    }

    void read( std::istringstream &line_stream );
    friend std::ostream& operator<< ( std::ostream& s, const cst_parameters& d );

		bool is_covalent;
		bool move_disAB,move_angA,move_angB,move_dihA,move_dihB,move_dihAB;
    float disAB, disAB_sd, disAB_k;
    float angA, angA_sd, angA_k, angA_periodic;
    float angB, angB_sd, angB_k, angB_periodic;
    float dihA, dihA_sd, dihA_k, dihA_periodic;
    float dihB, dihB_sd, dihB_k, dihB_periodic;
    float dihAB,dihAB_sd,dihAB_k,dihAB_periodic;
		std::string dihA_func, dihB_func, dihAB_func;
  };

	//lin  define the geometrical conformer parameters
  class cst_conformers {
  public:

    cst_conformers(){erase();};

    void erase( ) {
			disAB=0.;angA=0.;angB=0.;dihA=0.;dihB=0.;dihAB=0.;
      disAB_conf_sd = 0.; angA_conf_sd = 0.; angB_conf_sd = 0.;
      dihA_conf_sd = 0.;  dihB_conf_sd = 0.; dihAB_conf_sd = 0.;
      disAB_conf_N = 0; angA_conf_N = 0; angB_conf_N = 0;
      dihA_conf_N = 0;  dihB_conf_N = 0; dihAB_conf_N = 0;
			angA_N = 0; angB_N = 0;
      dihA_N = 0;  dihB_N = 0; dihAB_N = 0;
    };

    bool empty() {
      if( disAB_conf_sd == 0. && angA_conf_sd == 0. && angB_conf_sd == 0. &&
					dihA_conf_sd == 0. && dihB_conf_sd == 0. && dihAB_conf_sd == 0. &&
					angA_N == 0 && angB_N == 0 && dihA_N == 0 && dihB_N == 0 && dihAB_N == 0 ) return true ;
      else return false;
    };

    void read( std::istringstream &line_stream );
    friend std::ostream& operator<< ( std::ostream& s, const cst_conformers& d );

    float disAB, disAB_conf_sd, angA, angA_conf_sd, angB, angB_conf_sd;
    float dihA, dihA_conf_sd, dihB, dihB_conf_sd, dihAB,dihAB_conf_sd;
    int disAB_conf_N, angA_conf_N, angB_conf_N;
    int dihA_conf_N, dihB_conf_N, dihAB_conf_N;
    int angA_N, angB_N, dihA_N, dihB_N, dihAB_N;
  };

	//lin  define the template atom groups
  class template_residue {
  public:
    template_residue(){};
    void erase( ) {
      template_id_list.clear();
      atype_list.clear();
      seqpos_list.clear();
      res_list.clear();
      template_atom_list.clear();
    };
    void read( std::istringstream &line_stream );
    bool cleanup( int total_res );
    friend std::ostream& operator<< ( std::ostream& s, const template_residue& d );

		bool insert_atype_list(int const atom_type);
		bool insert_seqpos_list(int const seqpos);
		bool insert_res_list(int const aa_type);
		bool insert_template_id_list(numeric::xyzVector_int const & b);

    //bool use_id, use_name, use_seqpos, use_reslist;
    std::vector<numeric::xyzVector_int> template_id_list;
    std::vector<int> atype_list;
    //std::vector<int> acent_list;
    std::vector<int> seqpos_list;
    std::vector<int> res_list;
    //std::vector<int> variant;
    std::vector<template_atom> template_atom_list;
  };


	//lin  define the constraint
  class cst_descriptor {
  public:

    cst_descriptor(){ erase(); };

    inline void erase( ) {
      template_A.erase();
      template_B.erase();
      fix_coord= false;
      cst_parameter.zero_cstparam( );
      cst_conformer.erase( );
    }

		inline bool empty() const { return cst_parameter.empty(); }

		inline bool stat_cst() const {
			return ( //template_A.res_list[0] != param_aa::aa_gly &&
							 //template_B.res_list[0] != param_aa::aa_gly &&
				// comment out the above lines since they are obsolete
				// chu /2008/01/16
							 template_A.seqpos_list.size() == 1 &&
							 template_B.seqpos_list.size() <= 1 );
		}

		bool is_local_ligand_cst() const ;
		bool is_local_ligand_cst( int const LG, bool const attach_by_file = false ) const ;

    bool cleanup( int total_res );

		void find_covalent_pair() ;
		//lin method for filling the cst set and the pose allow_move
		void fill_cst_allow_move_set(
				   packer_cst_ns::Packer_cst_set & packer_cst,
					 cst_allow_move_ns::Allow_move_set & allow_move ) const ;

		//lin packer constraint setup of single constraint
		void fill_packer_cst_set(
					 kin::Fullatom_id const & a1,
					 kin::Fullatom_id const & a2,
					 kin::Fullatom_id const & a3,
					 kin::Fullatom_id const & b1,
					 kin::Fullatom_id const & b2,
					 kin::Fullatom_id const & b3,
				   packer_cst_ns::Packer_cst_set & packer_cst,
					 bool cst_init = false ) const ;

		//lin pose constraint setup of single constraint
		void fill_pose_cst_set(
					 kin::Fullatom_id const & a1,
					 kin::Fullatom_id const & a2,
					 kin::Fullatom_id const & a3,
					 kin::Fullatom_id const & b1,
					 kin::Fullatom_id const & b2,
					 kin::Fullatom_id const & b3,
					 cst_set_ns::Cst_set & cst_set ) const ;

	//lin pose constraint setup of single constraint
		void fill_allow_move_set(
					 kin::Fullatom_id const & a1,
					 kin::Fullatom_id const & a2,
					 kin::Fullatom_id const & a3,
					 kin::Fullatom_id const & b1,
					 kin::Fullatom_id const & b2,
					 kin::Fullatom_id const & b3,
					 cst_allow_move_ns::Allow_move_set & allow_move ) const ;

    friend std::ostream& operator<< ( std::ostream& s, const cst_descriptor& d );

    //pairwise constraint
    template_residue template_A, template_B;
    //coordinate constraint
    numeric::xyzVector_float coord;
    bool fix_coord;

    //constraint geometrical parameters
    cst_parameters cst_parameter;

    //conformer geometrical parameters
    cst_conformers cst_conformer;

  private:
    void build_templateB_atoms();

  };

	//lin  define the constraint set
  class cst_set_descriptor {
  public:
    cst_set_descriptor(){ erase(); };
    void erase( ) {
      cst_list.clear( );
			cstmap_string.clear();
    };
		bool empty() { return cst_list.empty(); }

		void cleanup( int total_res = 0 ) ;//lin default is 0

		// read the constraint file
    bool read_cstfile( std::string const & filename_in );
		//lin read the old enzyme constraint format
    bool read_enzyme_constraint(std::string const & filename_in );

		//lin read the catalytic map
		void read_catalytic_map( std::string const & filename_in );
		void read_old_catalytic_map( std::string const & filename_in );
		void write_catalytic_map( std::ostream & out ) const ;

		bool is_catpos( int const seqpos ) const;

		bool is_cstpos( int const seqpos ) const;

		void get_ligand_anchor_atoms(
						 pose_ns::Pose & pose,
						 int & ligaa,
						 FArray2Da_float lig_coord,
						 int & anchor_atomno,
						 int & anchor_rsd,
						 int & lig_root_atomno,
						 bool & attach_by_jump
				 ) const ;

		// method for filling the packer cst set, the pose allow_move
		// and count pair information
		void fill_cst_allow_move_set(
						packer_cst_ns::Packer_cst_set & packer_cst,
						cst_allow_move_ns::Allow_move_set & allow_move ) const ;

    friend std::ostream& operator<< ( std::ostream& s, const cst_set_descriptor& d );

  private:
		std::vector<std::string> cstmap_string;
    std::vector<cst_descriptor> cst_list;
  };

	//lin  read the seqpose from file
  void read_posfile( std::string const & filename_in, std::vector<int> & poslist ) ;

	//lin convert the virtual atom name to real atom,aa type
	void
	atom_from_virtual_name(
     std::string const & name, int & type,
		 std::vector<int> & res_list );

	//lin convert the pdb res to rosetta res
	void pdbres2rosettares( char const chain_id, int const pdbres, int & seqpos );

	std::string get_filename(
           std::string const & filename_in,
					 std::string const & default_name
					 );

}//namespace cst_descriptor_ns

#endif
