// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7523 $
//  $Date: 2006-02-20 15:10:59 -0800 (Mon, 20 Feb 2006) $
//  $Author: jiangl $

//////////////////////////////////////////////
#ifndef INCLUDED_cst_function
#define INCLUDED_cst_function

// Rosetta Headers

// ObjexxFCL Headers


// C++ Headers
#include <cstdlib>
#include <vector>
#include <string>

//////////////////////////////////
//lin  the Cst_function object holds data which is used to define the
//lin  energy function ( score and derivative ) for constraints
//

namespace cst_functions_ns {

  // deallocate memory by calling "erase"
  void cst_memory_cleanup();

  // number cst function types
  const size_t numer_cstE_types = 2;
  // cst function type
  enum Cst_func_type { HARMONIC, PERIODIC };

  ////////////////////////////////////////////////////////////////////
  //lin a single constraint potential and derivative
  ////////////////////////////////////////////////////////////////////
  class Cst_function {
  public:

    virtual
    float cstE( float const delta_val, float const sd, float const k1, float const k2 ) const = 0;

    virtual
    float cstE_deriv( float const delta_val, float const sd, float const k1, float const k2 ) const = 0;

    virtual
    Cst_func_type func_type() const = 0; // get the cst function type

    virtual
    std::string func_name() const = 0; // get the cst function name

    virtual
    ~Cst_function() { }; // destructor
  };


  class Cst_harmonic_function : public Cst_function {
  public:

    Cst_harmonic_function() {} ;

    virtual
    float cstE( float const delta_val, float const sd, float const k1, float const k2 ) const;

    virtual
    float cstE_deriv( float const delta_val, float const sd, float const k1, float const k2 ) const;

    virtual
    Cst_func_type func_type() const { return HARMONIC; }; // get the cst function type

    virtual
    std::string func_name() const { return "HARMONIC"; }; // get the cst function name

  };

  class Cst_periodic_function : public Cst_function {
  public:

    Cst_periodic_function() {} ;

    virtual
    float cstE( float const val, float const val0, float const n_periodic, float const k ) const;

    virtual
    float cstE_deriv( float const val, float const val0, float const n_periodic, float const k ) const;

    virtual
    Cst_func_type func_type() const { return PERIODIC; }; // get the cst function type

    virtual
    std::string func_name() const { return "PERIODIC"; }; // get the cst function name

  };

  class CstE_manager {//lin cst func manager
  private:
    static std::vector< Cst_function* > func_map_;
    static bool func_map_init;
    static void initialize_func_map();

  public:
    CstE_manager();
    ~CstE_manager();

		static void erase() {
			for( int ii=0,ie=func_map_.size(); ii<ie; ii++ ) {
				delete func_map_[ii];
			}
			func_map_.clear();
			//func_map_init=false;
		};

    static const Cst_function*
    get_cst_function( Cst_func_type const type );

    static const Cst_function*
    get_cst_function( std::string const & name );

  };

	//lin
	const Cst_function*
	GetCstFunction( Cst_func_type const type );

	const Cst_function*
	GetCstFunction( std::string const & name );

}
#endif
