// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 01:39:36 -0500 (Sun, 18 Mar 2007) $
//  $Author: stuartm $


// Rosetta Headers
#include "current_pose.h"
#include "pose.h"

// ObjexxFCL Headers

// C++ Headers
#include <cstdlib>
#include <cstdio>
#include <fstream>

//Utility Headers
#include <utility/basic_sys_util.hh>

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
namespace current_score_pose {
	pose_ns::Pose * pose(0);
}

// set
void
score_set_current_pose(
	pose_ns::Pose & pose
)
{
	assert( current_score_pose::pose == 0 );
	pose.copy_to_misc();
	current_score_pose::pose = &pose;
}

// get
pose_ns::Pose &
score_get_current_pose(
)
{
	if ( current_score_pose::pose == 0 ) {
		std::cout << "score_get_current_pose called with uninit pose" <<
			std::endl;
		assert(false);
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return *(current_score_pose::pose);
}

// check
bool
score_check_current_pose(
)
{
	return ( current_score_pose::pose != 0 );
}

// reset
void
score_reset_current_pose(
)
{
	current_score_pose::pose = 0;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
namespace current_pack_pose {
	pose_ns::Pose * pose(0);
}

// set
void
pack_set_current_pose(
	pose_ns::Pose & pose
)
{
	assert( current_pack_pose::pose == 0 );
	current_pack_pose::pose = &pose;
}

// get
pose_ns::Pose &
pack_get_current_pose(
)
{
	if ( current_pack_pose::pose == 0 ) {
		std::cout << "pack_get_current_pose called with uninit pose" <<
			std::endl;
		assert(false);
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return *(current_pack_pose::pose);
}

// check
bool
pack_check_current_pose(
)
{
	return ( current_pack_pose::pose != 0 );
}

// reset
void
pack_reset_current_pose(
)
{
	current_pack_pose::pose = 0;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
namespace current_refold_pose {
	pose_ns::Pose const * pose(0);
}

// set
void
refold_set_current_pose(
	pose_ns::Pose const & pose
)
{
	assert( current_refold_pose::pose == 0 );
	current_refold_pose::pose = &pose;
}

// get
const pose_ns::Pose &
refold_get_current_pose(
)
{
	if ( current_refold_pose::pose == 0 ) {
		std::cout << "refold_get_current_pose called with uninit pose" <<
			std::endl;
		assert(false);
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return *(current_refold_pose::pose);
}

// check
bool
refold_check_current_pose(
)
{
	return ( current_refold_pose::pose != 0 );
}

// reset
void
refold_reset_current_pose(
)
{
	current_refold_pose::pose = 0;
}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
namespace current_moves_pose {
	pose_ns::Pose const * pose(0); // const-ref
}

// set
void
moves_set_current_pose(
	pose_ns::Pose const & pose
)
{
	assert( current_moves_pose::pose == 0 );
	pose.copy_to_misc();
	current_moves_pose::pose = &pose;
}

// get
pose_ns::Pose const &
moves_get_current_pose(
)
{
	if ( current_moves_pose::pose == 0 ) {
		std::cout << "moves_get_current_pose called with uninit pose" <<
			std::endl;
		assert(false);
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return *(current_moves_pose::pose);
}

// check
bool
moves_check_current_pose(
)
{
	return ( current_moves_pose::pose != 0 );
}

// reset
void
moves_reset_current_pose(
)
{
	current_moves_pose::pose = 0;
}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
namespace current_minimize_pose {
	pose_ns::Pose * pose(0);
}

// set
void
minimize_set_current_pose(
	pose_ns::Pose & pose
)
{
	assert( current_minimize_pose::pose == 0 );
	pose.copy_to_misc();
	current_minimize_pose::pose = &pose;
}

// get
pose_ns::Pose &
minimize_get_current_pose(
)
{
	if ( current_minimize_pose::pose == 0 ) {
		std::cout << "minimize_get_current_pose called with uninit pose" <<
			std::endl;
		assert(false);
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return *(current_minimize_pose::pose);
}


// check
bool
minimize_check_current_pose(
)
{
	return ( current_minimize_pose::pose != 0 );
}


// reset
void
minimize_reset_current_pose(
)
{
	current_minimize_pose::pose = 0;
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

