// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_decoystats_interface
#define INCLUDED_decoystats_interface


// Rosetta Headers
#include "decoystats_classes.h"
#include "decoystats_interface_classes.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>
#include <list>
#include <vector>
#include <string>

// Forward declarations
namespace pose_ns { class Pose; }

namespace energy_quantifier_ns {
	enum energy_quantifier {
		ATR, REP, SOL, HB, PROB, DUN, PAIR, INTRARES, GB, CST, PLANE,
		H2O, H2OHB, WSOL, UNF, TOT, SASAPACK, SASAPROB
	};
}

// Function Declarations

void
set_interface_ds_flag( bool setting );


bool
get_interface_ds_flag();


// jk Class definition for interface_ds
class interface_ds
{

private:

	// jk pointer to a pose
	pose_ns::Pose * pose;

	// jk definition of the interface
	int num_interface_res;
	int num_core_interface_res;
	int num_interface_atom;
	int num_interface_water;
	FArray1D_bool interface_res;
	FArray1D_bool core_interface_res;
	FArray2D_bool interface_atom;
	FArray1D_float res_sasa_complex;
	FArray2D_float atom_sasa_complex;
	FArray1D_float res_sasa_diff;
	FArray2D_float atom_sasa_diff;

	// jk measure of interface size
	float delta_sasa;

	// jk measures of composition
	int num_interface_aromatics;
	float sasa_interface_aromatics;
	int num_polar_atoms;
	int num_atoms;
	int met_sc_atoms;

	// jk energetic measures
	bool energies_initialized;
	std::vector < interface_energy_quantifier > energy_quantifiers;

	// jk measures of packing
	int interface_num_tight;

	// jk uns lists
	std::list < unsatisfied_buried_polar > bound_uns_list;
	std::list < unsatisfied_buried_group > bound_group_uns_list;
	std::list < unsatisfied_buried_polar > unbound_uns_list;
	std::list < unsatisfied_buried_group > unbound_group_uns_list;
	std::list < unsatisfied_buried_polar > exempt_uns_list;
	std::list < unsatisfied_buried_group > exempt_group_uns_list;
	std::list < unsatisfied_buried_polar > interface_strict_uns_list;
	std::list < unsatisfied_buried_group > interface_strict_group_uns_list;
	std::list < unsatisfied_buried_polar > interface_delta_uns_list;
	std::list < unsatisfied_buried_group > interface_delta_group_uns_list;

	void define_interface();

	void count_interface_waters(
		float const probe_radius,
		float const interface_diff_thres
  );

	void setup_energetic_quantifiers();

	void compute_quantifiers();

	float compute_delta_sasa();

	void compute_composition();

	void compute_energies();

	int compute_tight_core_packing();

public:

	interface_ds( pose_ns::Pose * input_pose_ptr );

	void report_core_uns(
    std::string const tag,
    std::list < unsatisfied_buried_polar > & uns_list
  );

	void report_core_uns(
    std::string const tag,
    std::list < unsatisfied_buried_polar > & uns_list,
    std::list < unsatisfied_buried_group > & group_uns_list
  );

	void write_all_quantifiers_to_PDB();

	void list_interface_res();

	void list_interface_atoms();

	void find_CBCB();

	void compute_delta_UNS(
    bool const do_repack,
		bool const compare_to_polyAla,
		bool const refine_loops
  );

	void reset_noninterface_bfactors( float const reset_val );

	inline float get_delta_sasa() { return delta_sasa; };

	inline int count_interface_delta_group_uns_list()
	{ return interface_delta_group_uns_list.size(); };

};



#endif
