// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 20570 $
//  $Date: 2008-02-22 22:05:24 -0500 (Fri, 22 Feb 2008) $
//  $Author: johnk $


// Rosetta Headers
#include "design.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include "ConformerLibHandler.h"
// Using
using namespace param;


//bk command line arguments specific to the design module


namespace design {

RotamerOptions active_rotamer_options;

// jk flag determines whether sc/bb energies are counted as 1-body or 2-body
bool eval_sc_bbE_for_energy1b = { true };

//ds parameter values for design_from_mut_list and get_redesign_mutation_list
int const max_sim = { 100 };
int const max_mut_per_sim = { 10 };
int const max_num_chains = { 26 };
int const max_filename = { 100 };

namespace design_commands {

	bool identify_interface_UNS_flag = { false };
	bool build_Ala_interface = { false };
	int ndruns = { 1 };
	bool onlypack = { false };
	bool optE = { false };
	bool optE_ctsa = { false };
	bool optE_jk = { false };
	bool optE_rep_cut = { false };
	float optE_rep_cut_val = { 500. };
	bool fixbb = { false };
	bool natrot = { false };
	bool fixseq = { false };
	bool mvbb = { false };
	bool shakenbake = { false };
	bool design_in_pieces = { false };
	bool dna_interface = { false };
	bool explicit_h2o = { false };
	bool solvate = { false };
	bool try_both_his_tautomers = { false };
	bool hydrate_dna = { false };
	bool ex_dna_waters = { false };
	bool rotamerize = { false };
	bool minimize_rot = { false };
	bool desock = { false };   // design and dock_mcm protocol
	bool design_inter = { false };
	bool repack_inter = { false };
	bool point_mutation = { false };
	float interface_residue_cutoff = { 5.5 };
	FArray1D_bool interface_residue( MAX_RES() );
	int n_interface_residues;
	FArray1D_int interface_residue_list( MAX_RES() );
	int fix_target_seq = { 0 };
	bool optE_inter = { false };
	bool alter_spec = { false };
	bool chain_limit = { false };
	char chain_choose;
	bool design_trials = { false };
	FArray2D_bool design_matrix( MAX_AA(), MAX_RES() );
	bool use_design_matrix = { false };
	bool mut_list = { false };
	FArray1D_bool automatic_behavior( MAX_RES(), false );
	bool no_his_his_pairE = { false };
	bool use_electrostatic_repulsion = { false };
	bool safety = { false };
	bool dna_motifs = { false };
	bool multistate = { false };
	bool tail = { false };
	bool tail_fix_helix = { false };
	int tail_begin;
	int tail_end;
	bool design_loops_dock = { false };
	bool design_min_inter = { false };
	bool dock_des_min_inter = { false };
  bool flex_peptide = { false }; // SJF
	bool mcmin_trials = { false };
	bool linmin_trials = { false };
	bool design_dock_pert = { false };
	bool ligand_filter = { false };
	float ligand_filter_score = { 0.0 };
	int   ligand_filter_count = { 0 };
	bool output_design_movie = { false };
	int num_movie_frames = { -1 };
	bool no_new_CG = { false };
	bool auto_resfile = { false };
	bool mutate_cluster = { false };
	bool output_pdb = { false };
	bool pack_in_parallel = {false};
	int conv_limit_mod = { 3 };
	std::string chain_in_preferred_state;
	std::string chain_in_ref_state;
	bool reverse_comp = {false};
	bool use_directed_design = { false };
	std::string directed_design_filename;
	int timelimit = 180;
	bool design_interface_electrostatic_complementarity = { false };
	float interface_electrostatic_complementarity_shift = { 0. };

	bool debug_annealer_design = {false};
}

namespace design_cluster {
	bool cluster_design;
	bool use_cluster_size = {false};
	int  cluster_size={1};
	bool use_real_cluster_only = {false};
	float cluster_dis_cut1={5.0};
	float cluster_dis_cut2={8.0};
	float cluster_dis_cut3={12.0};
	float design_dis_cut1={5.0};
	float design_dis_cut2={8.0};
	float repack_dis_cut1={5.0};
	float repack_dis_cut2={8.0};
	float high_nb;
	float low_nb;
	bool check_point = {false};
	int  last_cpts_size={1};
	int  n_mutatpos;
	bool debug_output = { false };
	bool minimize_structures = { false };
	bool minimize_wt_struct = { false };
	bool output_structures = { false };
	bool minimize_bb = { false };
	std::string mutenergy_out;
	bool fix_mut = {false};
	std::string mutenergy_in;
	std::string design_mutlist;
	bool design_neighbors = { false };
}

namespace design_loops_flags{
	bool design_loops = { false };
	std::string design_loops_option;
	bool design_loops_dock = { false };
	bool design_loops_hold = { false };
}

namespace conformer {
	ConformerLibHandler confLibHandler;
	std::string confLibChoice;
}

} // namespace design

