// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_diagnostics_rosetta
#define INCLUDED_diagnostics_rosetta


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>
#include <string>


// diagnostics Function Declarations


void
increment_trial_counters( int cycle_number );


void
get_trial_stats_by_type(
	std::string & type,
	int & trials,
	int & accepts
);


void
reset_trial_counters();


void
output_trial_counters( std::ostream & iunit );


void
output_accepted_trial_stats(
	int & j,
	int & num // num of the scoring function used
);


void
check_cendist();


void
compare_cendist(
	FArray2Da_float old_cendist,
	FArray2Da_float cendist,
	int max_res,
	int total_residue,
	FArray2Da_bool pair_moved
);


void
write_res(
	std::ostream & iunit,
	int res_x
);


void
write_res_coords(
	std::ostream & iunit,
	int res_x
);


void
write_fullcoord_atom(
	std::ostream & iunit,
	int res_x,
	int atom_x
);


void
write_fullcoord_atom_coords(
	std::ostream & iunit,
	int res_x,
	int atom_x
);


#endif
