// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16636 $
//  $Date: 2007-08-21 18:47:16 -0400 (Tue, 21 Aug 2007) $
//  $Author: ashworth $


// Rosetta Headers
#include "dna_ns.h"
#include "dna_classes.h"
#include "param.h" // 'MAX' dimensions
#include "param_aa.h" // is_DNA

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh> // Dimension
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// C++ Headers
#include <iostream>
#include <list>

using namespace param; // 'MAX' dimensions for FArrays

namespace dna_variables {

	// global mode flags
	bool enable_dna = { false };
	bool dna_verbose = { false };
	bool design_by_base = { false };

	//cmd give bonuses for DNA contact during simulated annealing
	bool favor_designed_bases = { false };
	float dna_bonus_value = { 0.0 }; //cmd
	float total_intxn_bonus = { 0.0 }; //cmd

	float const empty_value = { -999 };
	// global version of an array to track amino acid neighbors of DNA
	std::list< ResInfo > interface_list;

	// keep track of missing atoms
	FArray1D_bool no_sidechain( MAX_RES(), false );
	FArray1D_bool na_missing_phosphate( MAX_RES(), false );

/// Morozov's globals follow... ///

	DnaSeqInfo basepairs; // here only so that dna_am_min will compile

	// storage for DNA dihedrals, order: [alpha beta gamma delta epsilon xi chi]
	FArray2D_float dna_dihedrals( 7, MAX_RES() );
	// storage for prot chi angles
	FArray2D_float prot_chi_dihedrals( MAX_CHI, MAX_RES() );
	// storage for base-step parameters, order:
	// [twist roll tilt shift slide rise]
	FArray2D_float basestep_prms( 6, MAX_RES() );
	// storage for base-pair parameters, order:
	// [propeller buckle opening shear stretch stagger]
	FArray2D_float basepair_prms( 6, MAX_RES() );
	// storage for basestep resnums (i->j)
	FArray1D_int basestep_nums( MAX_RES() );
	// storage for basestep resnums (j->i)
	FArray1D_int basestep_nums_inv( MAX_RES() );
	// base atoms + C1* for A,C,G,T. Atom order same as in icoor
	FArray3D_float triad_icoor( 3, MAX_ATOM(), 4 );
	// natoms in the triad_icoor (natoms over which fitting is done)
	FArray1D_int triad_icoor_natoms( 4 );
	// set of vectors for the 5'-3' direction of "leading" strands
	FArray2D_float chain_dir( 3, MAX_RES() );
	// flag affecting scoring behavior upon base flip: base flip allowed (but penalized) during minimization, MC search etc.  Not allowed during initial scoring and setup (as initial structures should not have base flips)
	bool base_flip_allowed;
	// array marking which basepairs flipped during minimization, MC search etc.
	FArray1D_bool flip_occured( MAX_RES() );
	// Params for effective DNA potential:
	FArray2D_float means_bs(16, 6);
	FArray2D_float stddevs_bs(16, 6);
	FArray3D_float Fij(16, 6, 6);
	FArray2D_float means_bp(4, 6);
	FArray2D_float stddevs_bp(4, 6);
	FArray3D_float Gij(4, 6, 6);
	// Minimization selectors:
	// true if aa/na is to be minimized
	FArray1D_bool res2minim( MAX_RES() );
	// first dimension is ? (MAX_CHI+2) : 7
	FArray2D_bool ang2minim( 7, MAX_RES() );
  // Order of angles:
	// nchi(aa,1) followed by phi & psi for prot, same as in dna_dihedrals for dna
	// [k,cluster_map(k)] give clusters of residues to minimize
	FArray1D_int cluster_map( MAX_RES() );
	// true if at least 1 of those clusters is a cluster of dna bases
	bool dna_cluster_present;
	// If true, dna setup stuff is done in pack_rotamers
	bool do_dna_setup = true;
	// number of dihedral angles allowed to move during minimization
	int nangles;
	// max number of dihedral angles
	Dimension const MAX_ANGLES( 7 * MAX_RES() );
	// residue number from which minimization starts
	int minimize_start;
	// Refold selector:
	bool fixed_prot_bb_refold; // true if protein backbone is to be copied over rather than refolded at each step
	// (useful if only sidechains are moved)
	// DNA scores:
	FArray1D_float dna_bp_score( MAX_RES(), 0.0 );
	FArray1D_float dna_bs_score( MAX_RES(), 0.0 );
	float dna_bp_total;
	float dna_bs_total;
	// Total energy:
	float total_minim_energy; // total minimizer energy in a previous step
	//float total_minim_energy_with_penalty; // total minimizer energy in a previous step, including the degeneracy penalty
	float chiral_deviation;
	//////////////////////////////////////
	// debugging flag:
	int const dna_debug = { 0 };
	// Atom number aliases, for increased code readability:
	int const p   = { 1 };
	int const o1p = { 2 };
	int const o2p = { 3 };
	int const o5star = { 4 };
	int const c5star = { 5 };
	int const c4star = { 6 };
	int const o4star = { 7 };
	int const c3star = { 8 };
	int const o3star = { 9 };
	int const c2star = { 10 };
	int const c1star = { 11 };
	int const n1  = { 12 }; // valid for A,C,G,T
	int const c2  = { 13 }; // valid for A,C,G,T
	int const c4A  = { 15 }; // valid for A only!!
	int const c8A  = { 20 }; // valid for A only!!
	int const n9A  = { 21 }; // valid for A only!!
	int const c4G  = { 16 }; // valid for G only!!
	int const c8G  = { 21 }; // valid for G only!!
	int const n9G  = { 22 }; // valid for G only!!
	int const n1C  = { 12 }; // valid for C only!!
	int const n3C  = { 15 }; // valid for C only!!
	int const c6C  = { 19 }; // valid for C only!!
	int const n1T  = { 12 }; // valid for T only!!
	int const n3T  = { 15 }; // valid for T only!!
	int const c6T  = { 20 }; // valid for T only!!

	//ja added these for RNA support by Phil's basepairing function
	int const rna_n1 = n1 + 1;
	int const rna_n3pyr = n3C + 1;
	int const rna_c4rA = c4A + 1;
	int const rna_c4rG = c4G + 1;
	int const rna_c6rC = c6C + 1;
	int const rna_c6rU = c6T;

}

//rhiju Following may be redundant with ja's addition above.
namespace rna_variables {
	bool enable_rna = { false };

	// Atom number aliases, for increased code readability:
	int const p   = { 1 };
	int const o1p = { 2 };
	int const o2p = { 3 };
	int const o5star = { 4 };
	int const c5star = { 5 };
	int const c4star = { 6 };
	int const o4star = { 7 };
	int const c3star = { 8 };
	int const o3star = { 9 };
	int const c2star = { 10 };
	int const o2star = { 11 };
	int const c1star = { 12 };
	int const n1  = { 13 }; // valid for A,C,G,T
	int const c2  = { 14 }; // valid for A,C,G,T
	int const c4A  = { 16 }; // valid for A only!!
	int const c6A  = { 18 }; // valid for A only!!
	int const c8A  = { 21 }; // valid for A only!!
	int const n9A  = { 22 }; // valid for A only!!
	int const c4G  = { 17 }; // valid for G only!!
	int const c6G  = { 19 }; // valid for G only!!
	int const c8G  = { 22 }; // valid for G only!!
	int const n9G  = { 23 }; // valid for G only!!
	int const n1C  = { 13 }; // valid for C only!!
	int const n3C  = { 16 }; // valid for C only!!
	int const c4C  = { 17 }; // valid for C only!!
	int const c6C  = { 20 }; // valid for C only!!
	int const n1U  = { 13 }; // valid for U only!!
	int const n3U  = { 16 }; // valid for U only!!
	int const c4U  = { 17 }; // valid for U only!!
	int const c6U  = { 20 }; // valid for U only!!

	int const ho2starA = { 28 };
	int const ho2starG = { 30 };
	int const ho2starC = { 26 };
	int const ho2starU = { 26 };

}

////////////////////////////////////////////////////////////////////////////////
/// @begin IsDnaDomain
///
/// @brief
/// for DNA - checks if a given PDB chain is DNA
/// (paranoid)
///
/// @authors
/// Alex Morozov
///
////////////////////////////////////////////////////////////////////////////////
bool
IsDnaDomain(
	int const domain_finish,
	FArray1DB_int const & res
)
{
	int dna( res(domain_finish) );
	bool b1( param_aa::is_DNA(dna) ),
	     b2( ( param_aa::aa_name3(dna) == "  A" ||
	           param_aa::aa_name3(dna) == "  C" ||
	           param_aa::aa_name3(dna) == "  G" ||
	           param_aa::aa_name3(dna) == "  T" ) );
	return (b1 && b2);
}

////////////////////////////////////////////////////////////////////////////////
/// @begin IsRnaDomain
///
/// @authors
/// ashworth (copied from above)
///
////////////////////////////////////////////////////////////////////////////////
bool
IsRnaDomain(
	int const domain_finish,
	FArray1DB_int const & res
)
{
	int rna( res(domain_finish) );
	bool b1( param_aa::is_RNA(rna) ),
	     b2( ( param_aa::aa_name3(rna) == " rA" ||
	           param_aa::aa_name3(rna) == " rC" ||
	           param_aa::aa_name3(rna) == " rG" ||
	           param_aa::aa_name3(rna) == " rU" ) );
	return (b1 && b2);
}

