// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7412 $
//  $Date: 2006-02-06 18:27:25 -0500 (Mon, 06 Feb 2006) $
//  $Author: aroop$
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   rosetta++/dle_ns.h
///
/// @brief  Namespace that handles all options, global variables for the files
///         dle.cc & antibody_modeling.cc. The global variable
///         is designed to hold upto five loop ensembles. The loop_begin &
///         loop_end information is also stored in the global arrays specified.
/// @author Aroop Sircar (aroop@jhu.edu)

// Rosetta header
#include "fragment_class.h"
#include "loop_class.h"
#include "pose.h"
#include "pose_loops.h"

#ifndef INCLUDED_dle_ns
#define INCLUDED_dle_ns

// Maximum number of loops that can be built in a simulation
#define DOCK_MAX_LOOPS 6

/// @brief Namespace for dle and antibody_modeling
namespace dle_ns {
	/// @brief Loop library for flexible docking
	extern std::vector< Fragment > dock_loop[DOCK_MAX_LOOPS];
	/// @brief Total number of loops to be modelled
	extern int dock_flex_total_loops;
	/// @brief Loop Begins
	extern int dock_flex_loop_begin[DOCK_MAX_LOOPS];
	/// @brief Corresponding Loop Ends
	extern int dock_flex_loop_end[DOCK_MAX_LOOPS];
	/// @brief Chu's new loop class
	extern pose_ns::Loops dle_loops;
	/// @brief  Should loop rmsg be calculated
	extern bool dle_calc_rmsg_flag;
	/// @brief default light chain identifier
	extern char light_chain;
	/// @brief only refinement of loops in loop lib
	extern bool dle_refine;
	/// @brief only build loops
	extern bool dle_build;
	/// @brief only cluster loops
	extern bool dle_cluster;
	/// @brief fold tree with 2 cutpoints for H3 & dock rg-body jump
	extern bool simultaneous_minimization;
	/// @brief insert one loop at a time and do a local refine
	extern bool insert_all_loops_with_local_refine;
	/// @brief do not enforce any filters while outputing decoy
	extern bool output_with_no_filters;
	/// @brief four letter pdb filename
	extern std::string pdb_filename;
	/// @brief repack neighbors of loop
	extern bool repack_loop_neighbors;
	/// @brief loop relax with small/shear moves
	extern bool fullatom_loop_relax;
	/// @brief file containing loop definition
	extern std::string loop_def_filename;
	/// @brief length of c-terminal to be modeled
	extern int cter_modeling_size;
	/// @brief  cter flexibility in dock
	extern bool dle_cter_flag;
	/// @brief flag to switch on H3 filter
	extern bool dle_model_H3;
	/// @brief actually enables H3 filter for H3 operations
	extern bool dle_H3_filter;
	/// @brief flag to switch on frags of
	///        loop length only
	extern bool loop_frags;
	/// @brief frag offset for frag file
	extern int loop_frag_offset;
	/// @brief do not idealize any bonds
	extern bool freeze_bonds;
	/// @brief cutpoint whose separation is computed in scorefile
	extern int decoy_loop_cutpoint;
	/// @brief just refine input loop
	extern bool refine_input_loop;
	/// @brief pose with starting sidechains
	extern pose_ns::Pose starting_sidechain_pose;
	/// @brief enable filter for decoys
	extern bool decoy_filter;
	/// @brief idealization of modeled regions
	///        in native structures for comparison
	extern bool idealize_native;
	/// @brief refine loops more than default
	extern bool refine_more;
}

namespace fv_loop_insert_ns {
	/// @brief Sequential residue number where linker starts
	extern int fv_loop_insert_begin;
	/// @brief Sequential residue number where linker terminates
	extern int fv_loop_insert_end;
}

// Namespace specific for antibody modeling mode
namespace antibody_ns {
	/// @brief build H3 only
	extern bool antibody_build;
	/// @brief refine H3 only
	extern bool antibody_refine;
	/// @brief cluster H3 only
	extern bool antibody_cluster;
	/// @brief only calculate H3 base dihedrals
	extern bool H3_base_mode;
	/// @brief H3 base dihedrals
	extern std::vector< Fragment > H3_base_library;
	/// @brief H3 nter dihedrals
	extern std::vector< Fragment > H3_nter_library;
	/// @brief graft in l1 from default file l1.pdb
	extern bool graft_l1;
	/// @brief graft in l2 from default file l2.pdb
	extern bool graft_l2;
	/// @brief graft in l3 from default file l3.pdb
	extern bool graft_l3;
	/// @brief graft in h1 from default file h1.pdb
	extern bool graft_h1;
	/// @brief graft in h2 from default file h2.pdb
	extern bool graft_h2;
	/// @brief graft in h3 from default file h3.pdb
	extern bool graft_h3;
	/// @brief  model h3 loop from fragments
	extern bool model_h3;
	/// @brief file from which to copy stem coords for light loop
	extern std::string unaligned_framework_light_monomer_filename;
	/// @brief file from which to copy stem coords for heavy loop
	extern std::string unaligned_framework_heavy_monomer_filename;
	/// @brief Flag to turn on mode for builing Fv linker
	extern bool fv_linker_mode;
	/// @brief enable use of nter frags
	extern bool use_nter_frags;
	/// @brief do not use cter frags
	extern bool dont_use_cter_frags;
	/// @brief Number of ADDITIONAL residues modeled from H3_NTERM
	///        These residues normally range from H:92-95
	extern int nter;
	/// @brief Number of ADDITIONAL residues modeled from H3_CTERM
	///        These residues range from H:n-2,n-1,n,n+1 of H3
	extern int base;
	/// @brief flag to trigger loading of native and computation
  ///        of H3 rmsg from native
	extern bool use_native;
	/// @brief Number of flanking cdr residues to graft in template
	extern int deep_graft;
	/// @brief Fragment sizes of H3 nter fragment files
	extern int h3_nter_frag_size;
	/// @brief Fragment sizes of H3 base fragment files
	extern int h3_base_frag_size;
	/// @brief switch to fast_ccd based loop closure instead of
  ///        default ccd_moves
	extern bool fast_ccd;
	/// @brief use random cutpoints for h3 modeling
	extern bool h3_random_cut;
	/// @brief lower amplitude during base relaxation
	extern bool min_base_relax;
	/// @brief bias use of antibody fragments
	extern bool bias_frags;
	/// @brief bias weight of antibody fragments
	extern float bias_fraction;
	/// @brief enforces strand ss in base
	extern bool enforce_base_strand;
	/// @brief select base based on kink/extended match only
	extern bool select_all_kink_match;
	/// @brief Storing cdrs in Chu's new loop class
	extern pose_ns::Loops all_cdrs;
	/// @brief Pose with loops grafted in
	extern pose_ns::Pose grafted_pose;
	/// @brief check to see if cdrs already grafted in or not
	extern bool already_grafted;
	/// @brief unaligned framework heavy monomer
	///        in absence of nter flag is used to read
	///        psi-omega angles of begin-1 residues
	extern pose_ns::Pose unaligned_framework_heavy_monomer;
	/// @brief unaligned framework light monomer
	///        in absence of nter flag is used to read
	///        psi-omega angles of begin-1 residues
	extern pose_ns::Pose unaligned_framework_light_monomer;
	/// @brief sequential numbering of h3 begin
  ///        in unaligned heavy chain monomer
	extern int unaligned_h3_loop_begin;
	/// @brief sequential numbering of h3 end
  ///        in unaligned heavy chain monomer
	extern int unaligned_h3_loop_end;
	/// @brief graft cdr by superimposing stems of cdr
	extern bool superimpose_cdr;
	/// @brief insert all h3's from library
	///        just repack, nothing else
	extern bool antibody_insert_all_h3;
	/// @brief stores library of putative h3 conformations
	extern std::vector< Fragment > h3_library;
	/// @brief flag to prevent extensive repacking
	extern bool norepack_antibody;
	/// @brief force hbond computation
	extern bool compute_hbond;
	/// @brief enable docking local refine of L-H chains & simultaneous H3 min
	extern bool snug_fit;
	/// @brief relax all cdrs after CDR-H3 modeling
	extern bool relax_cdrs;
	/// @brief relax all cdrs while docking
	extern bool relax_dock;
	/// @brief freeze h3 during all cdr relax and local refine
	extern bool freeze_h3;
	/// @brief relax flanking regions of h3
	extern bool	flank_relax;
	/// @brief number of flanking residues
	extern int h3_flank;
	/// @brief sequential residue number of end of light chain
	extern int L_end;
	/// @brief enable cdr minimization during snugdock
	extern bool snugloop;
	/// @brief relax h3 during snugdock
	extern bool snugh3;
	/// @brief load native for snugdock calculations
	extern bool snugnative;
	/// @brief populate both VL-VH & Ab-Ag interfaces in intrf list
	extern bool LH_AbAg_interface;
}

// Namespace specific for grafting cdrs in antibody modeling mode
namespace cdr_ns {
	/// @brief pdb containing CDR-L1 to be grafted in
	extern pose_ns::Pose cdr_l1;
	/// @brief pdb containing CDR-L2 to be grafted in
	extern pose_ns::Pose cdr_l2;
	/// @brief pdb containing CDR-L3 to be grafted in
	extern pose_ns::Pose cdr_l3;
	/// @brief pdb containing CDR-H1 to be grafted in
	extern pose_ns::Pose cdr_h1;
	/// @brief pdb containing CDR-H2 to be grafted in
	extern pose_ns::Pose cdr_h2;
	/// @brief Sequential Residue Number of CDR-L1 begin
	extern int cdr_l1_begin;
	/// @brief Sequential Residue Number of CDR-L1 end
	extern int cdr_l1_end;
	/// @brief Sequential Residue Number of CDR-L2 begin
	extern int cdr_l2_begin;
	/// @brief Sequential Residue Number of CDR-L2 end
	extern int cdr_l2_end;
	/// @brief Sequential Residue Number of CDR-L3 begin
	extern int cdr_l3_begin;
	/// @brief Sequential Residue Number of CDR-L3 end
	extern int cdr_l3_end;
	/// @brief Sequential Residue Number of CDR-H1 begin
	extern int cdr_h1_begin;
	/// @brief Sequential Residue Number of CDR-H1 end
	extern int cdr_h1_end;
	/// @brief Sequential Residue Number of CDR-H2 begin
	extern int cdr_h2_begin;
	/// @brief Sequential Residue Number of CDR-H2 end
	extern int cdr_h2_end;
	/// @brief Sequential Residue Number of CDR-H3 begin
	extern int cdr_h3_begin;
	/// @brief Sequential Residue Number of CDR-H3 end
	extern int cdr_h3_end;
}

// Namespace to store native information
// used mainly for protocol testing
namespace native_cdr {
	/// @brief native antibody filename
	extern std::string native_pdb_filename;
	/// @brief native antibody fv
	extern pose_ns::Pose native_fv;
	/// @brief Sequential Residue Number of end of light
  ///        chain in native antibody fv
	extern int native_chain_L_end;
	/// @brief Sequential Residue Number of CDR-L1 begin
  ///        in native antibofy fv
	extern int native_l1_begin;
	/// @brief Sequential Residue Number of CDR-L1 end
	///        in native antibody fv
	extern int native_l1_end;
	/// @brief Sequential Residue Number of CDR-L2 begin
  ///        in native antibofy fv
	extern int native_l2_begin;
	/// @brief Sequential Residue Number of CDR-L2 end
	///        in native antibody fv
	extern int native_l2_end;
	/// @brief Sequential Residue Number of CDR-L3 begin
  ///        in native antibofy fv
	extern int native_l3_begin;
	/// @brief Sequential Residue Number of CDR-L3 end
	///        in native antibody fv
	extern int native_l3_end;
	/// @brief Sequential Residue Number of CDR-H1 begin
  ///        in native antibofy fv
	extern int native_h1_begin;
	/// @brief Sequential Residue Number of CDR-H1 end
	///        in native antibody fv
	extern int native_h1_end;
	/// @brief Sequential Residue Number of CDR-H2 begin
  ///        in native antibofy fv
	extern int native_h2_begin;
	/// @brief Sequential Residue Number of CDR-H2 end
	///        in native antibody fv
	extern int native_h2_end;
	/// @brief Sequential Residue Number of CDR-H3 begin
  ///        in native antibofy fv
	extern int native_h3_begin;
	/// @brief Sequential Residue Number of CDR-H3 end
	///        in native antibody fv
	extern int native_h3_end;
	/// @brief Start positions of framework region in
	///        light chain
	extern int L_framework_begin[7];
	/// @brief End positions of framework region in
	///        light chain
	extern int L_framework_end[7];
	/// @brief Start positions of framework region in
	///        heavy chain
	extern int H_framework_begin[6];
	/// @brief End positions of framework region in
	///        heavy chain
	extern int H_framework_end[6];
}

void
dle_ns_main();

#endif
