// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "dock_pivot_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

// Using
using namespace param;


//------------------------------------------------------------------------------
//
// Variables necessary to define and manipulate
// pivot residues (for dock_pivot)
//
//------------------------------------------------------------------------------


namespace dock_pivot {


int const max_pivot_residue_count = { 5 };


namespace pivot_residues {
	bool pivot_residues_loaded = { false };
	FArray1D_int pivot_residue_list( max_pivot_residue_count, -1 );
	int pivot_residue_list_size = 0;
	int pivot_residue_accepts;
	int pivot_residue_trials;
	bool using_pivot_residue_file;
	bool using_pivot_residues = { false };
	std::string pivot_residue_filename;
	float low_resolution_sc;
	float low_resolution_vdw;
	float low_resolution_dcontact;
}


namespace pivot_minimize {
	float pivot_rmsd;
	float pivot_min_fret;
	FArray1D_float pivot_min_list( max_pivot_residue_count * 2 );
	int pivot_moves;
}


namespace pivot_data {
	FArray1D_bool pvt_res8( MAX_RES() );
}


}
