// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_dock_pivot_ns
#define INCLUDED_dock_pivot_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


//------------------------------------------------------------------------------
//
// Variables necessary to define and manipulate
// pivot residues (for dock_pivot)
//
//------------------------------------------------------------------------------


namespace dock_pivot {


extern int const max_pivot_residue_count;


namespace pivot_residues {
	extern bool pivot_residues_loaded;
	extern FArray1D_int pivot_residue_list;
	extern int pivot_residue_list_size;
	extern int pivot_residue_accepts;
	extern int pivot_residue_trials;
	extern bool using_pivot_residue_file;
	extern bool using_pivot_residues;
	extern std::string pivot_residue_filename;
	extern float low_resolution_sc;
	extern float low_resolution_vdw;
	extern float low_resolution_dcontact;
}
using namespace pivot_residues;


namespace pivot_minimize {
	extern float pivot_rmsd;
	extern float pivot_min_fret;
	extern FArray1D_float pivot_min_list;
	extern int pivot_moves;
}
using namespace pivot_minimize;


namespace pivot_data {
	extern FArray1D_bool pvt_res8;
}
using namespace pivot_data;


}


#endif
