// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10040 $
//  $Date: 2006-08-29 03:01:52 -0400 (Tue, 29 Aug 2006) $
//  $Author: chu $

#ifndef INCLUDED_dock_structure
#define INCLUDED_dock_structure


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Types
typedef  float (*Scoring_Function)();


// dock_structure Function Declarations


void
dock_structure( bool & fail );


void
docking_prepack_protocol();


void
error_stop( std::string const & message );


void
docking_perturb_decoy();


void
docking_gaussian_perturbation();


void
docking_reset_tracking();


void
docking_store_initial_rms();


float
docking_get_initial_rms();


void
docking_store_cenmode_rms();


float
docking_get_cenmode_rms();


float
docking_get_score_before_mcm();


float
docking_get_score_after_one_min();


float
docking_get_score_after_5_mcm();


void
make_named_numbered_pdb(
	std::string const & filebase,
	int number,
	bool fullatom
);


void
make_named_labelled_pdb(
	std::string const & filebase,
	bool fullatom
);


void
make_named_pdb(
	std::string const & filename,
	bool const fullatom
);


void
rigid_body_MC_cycle_adaptive(
	int cycles_in, // number of MC cycles to run
	int c_attempts_in, // number of steps per cycle
	float trans_magnitude_in, // initial magnitude of rigid-body translation
	float rot_magnitude_in, // initial magnitude of rigid-body rotation
	bool fullatom, // flag for fullatom mode
	Scoring_Function scorefxn
);


void
rigid_body_MC_cycle(
	int const attempts, // number of MC moves to attempt
	float const trans_magnitude, // magnitude of rigid-body translation
	float const rot_magnitude, // magnitude of rigid-body rotation
	float const pivot_magnitude, // magnitude of pivot residue phi/psi perturbation
	bool const fullatom, // flag for fullatom mode
	Scoring_Function scorefxn,
	float & success_rate, // ratio of accepted to total moves
	float & pivot_success_rate // pivot MC success rate
);


#endif
