// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 01:39:36 -0500 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_docking_constraints
#define INCLUDED_docking_constraints

#include "pdb.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

#include <utility/vector1.fwd.hh>
// docking_constraints Function Declarations


void
docking_read_dist_constraint();


void
docking_print_dist_constraint();


bool
docking_dist_constr_filter();


float
docking_dist_constr_bonus();


void
docking_read_site_constraints();


void
res_num_from_pdb_res_num_chain(
	int & res_num_out,
	int const pdb_res_num_in,
	char const pdb_chain_in
);


void
res_num_from_pdb_res_num_chain(
	int & res_num_out,
	Pdb_info pdb_info,
	int const pdb_res_num_in,
	char const pdb_chain_in,
	int const size
);


void
docking_print_site_constraints();


void
docking_evaluate_site_score();


void
docking_evaluate_site_matchup(
	FArray1Da< utility::vector1_int > site_residues,
	FArray1Da_float site_bonus,
	float & score
);


bool
docking_site_constr_filter();


void
docking_fab_read_sites();


void
docking_fab_print_sites();


void
docking_calc_fab_score();


bool
docking_fab_filter();


void
docking_load_fab_env_table();


#endif
