// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "docking_unbound.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;


namespace docking_unbound {


//     Variables for docking native unbound structure.
//     parallel to those in misc.h
//                                    chu 2003.08.13


namespace unbound_pose {
	int unbound_total_res;
	FArray1D_int unbound_res( MAX_RES() );
	FArray1D_int unbound_res_variant( MAX_RES() );
	FArray1D_float unbound_phi( MAX_RES() );
	FArray1D_float unbound_psi( MAX_RES() );
	FArray1D_float unbound_omega( MAX_RES() );
	FArray3D_float unbound_fullcoord( 3, MAX_ATOM(), MAX_RES() );
	FArray2D_float unbound_actcoord( 3, MAX_RES() );
	FArray2D_int unbound_rotarray( MAX_CHI, MAX_RES() );
	FArray2D_float unbound_chiarray( MAX_CHI, MAX_RES() );
}

//chu   Currently two situations needs unbound structure to be aligned
//     with native
//     1. Adding unbound rotamers to native bound backbone
//     2. Use unbound backbone as starting to do docking simulation.
//     There are several flags to bookkeeping align status:
//     unbound_start -- command line flag to indicate unbound backbone
//                      has been used as the starting structure.
//     unboundrot    -- command line flag to indicate extra rotamers
//                      from unbound structure should be included in
//                      side-chain packing.
//     The above two flags are defined  in docking.h
//     unbound_map_set -- internal flag indicating native and unbound
//                        structure share the same sequence, therefore
//                        no align map is necessary.
//     use_mapped_rmsd -- internal flag indicating whether mapping should
//                        be done before rmsd and I_rmsd are calculated,
//                        for example, when native seq is still in current
//                        array or unbound seq is the same as the native,
//                        this flag should be set as false


namespace docking_align {
	FArray1D_int unbound_seq_align_map( MAX_RES() );
	bool unbound_map_set = { false };
	bool use_mapped_rmsd = { false };
}


}
