#ifndef INCLUDED_domins_fullatom
#define INCLUDED_domins_fullatom

// Rosetta Headers
#include "pose_fwd.h"
#include "loop_class.h"

// C++ Headers
#include <string>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

namespace pose_ns { class Loops; }

void
domins_fullatom_protocol(
		pose_ns::Pose & pose,
		pose_ns::Pose & save_fullatom_pose,
		bool const input
		);

void
rigid_body_mcm_protocol(
		pose_ns::Pose & docking_pose,
		int & n_accepted,
		int const cycle,
		pose_ns::Monte_carlo & mc
		);

void
insertion_fast_relax(
		pose_ns::Pose & pose,
		pose_ns::Score_weight_map & weight_map,
		pose_ns::Monte_carlo & mc
		);

void
loop_refinement_move(
		pose_ns::Pose & pose,
		pose_ns::Score_weight_map & weight_map,
		int const nmoves,
		std::string const move_type
		);

void
domins_select_loop_and_interface(
		pose_ns::Pose & pose,
		bool const use_nblist,
		FArray1D_bool & allow_repack
		);

void
recover_all_sidechains( pose_ns::Pose & pose );

void
domins_read_prepacked();
#endif
