// /////////////////////////////////////////////////////////////////////////////////////
// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
// @domins_ns.cc
//
// @brief
// Namespace to keep track of domins pieces
//
// @detailed:
// To use this mode, enter -switch_test, -loop_end and -loop_begin followed by
// the start and end of the loop you would like created
//
// @authors: Monica Berrondo
//
// @last_modified: March 21 2006
// /////////////////////////////////////////////////////////////////////////////////////

#include "domins_ns.h"
#include "loop_class.h"
#include "pose.h"

// numeric Headers
#include "numeric/xyzVector.hh"

// namespace
namespace domins_ns {

	//
	//
	// domins_ns: variables for domain insertion calculations using Rosetta
	//
	//

	// keeps track of the information about the host
	namespace domins_host{
		pose_ns::Pose host_protein_pose;
		pose_ns::Pose host_ppk_pose;
		int hostp_combined_begin;
		int hostp_combined_end;
		int hostp_begin;
		int hostp_end;
		int hostp_start_res;
		int hostp_end_res;
		int hostp_com;
		int hostp_part1_com;
		int hostp_part2_com;
		int hostp_nres;
		std::vector < numeric::xyzVector<double> > hostp_part1;
		std::vector < numeric::xyzVector<double> > hostp_part2;
		std::vector < numeric::xyzVector<double> > hostp_positions;
	}
	using namespace domins_host;

	// keeps track of the information about the insert
	namespace domins_insert{
		pose_ns::Pose insert_protein_pose;
		pose_ns::Pose insert_ppk_pose;
		int insertp_combined_begin;
		int insertp_combined_end;
		int insertp_begin;
		int insertp_end;
		int insertp_start_res;
		int insertp_end_res;
		int insertp_com;
		int insertp_nres;
		std::vector < numeric::xyzVector<double> > insertp_positions;
	}
	using namespace domins_insert;

	// keeps track of the information about the loops
	namespace domins_loops{
		pose_ns::Loops loops;
		int linker_size;
		int loops_com;
	}
	using namespace domins_loops;

	// maps and spliced protein information
	namespace domins_maps{
		std::map<std::string,std::string> params;
		SplicedProtein spliced_protein_map;
		std::vector<SplicedProtein> spliced_protein_res_info;
	}
	using namespace domins_maps;

	// everything that is stored that will later be called from the status file
	namespace domins_scores{
		float start_rmsd (0.0);
		float centroid_rmsd (0.0);
		float insert_rmsd (0.0);
		float rb_rmsd (0.0);
		float loop_rmsd (0.0);
		float loop1_rmsd (0.0);
		float loop2_rmsd (0.0);
		float rmsd_to_native (0.0);
		float centroid_score (0.0);
		int centroid_rejected (0);
	}
	using namespace domins_scores;

	// all the flags specific for domain insertion mode
	namespace domins_flags{
		bool fa_input_flag (false);
		bool fa_set (false);
		bool rb_relax (false);
		bool do_main_protocol (false);
		bool do_insertion_flop (false);
		bool fast_relax (false);
		bool repack_relax (false);
		bool loop_only (false);
		bool small_perturbation (false);
		bool no_loop (false);
		bool no_frags (false);
		bool no_perturb (false);
		bool prepack_read (false);
	}
	using namespace domins_flags;

	float initial_vdw;
	int nres;
}
