// /////////////////////////////////////////////////////////////////////////////////////
// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
// @domins_ns.cc
//
// @brief
// Namespace to keep track of domins pieces
//
// @detailed:
// To use this mode, enter -switch_test, -loop_end and -loop_begin followed by
// the start and end of the loop you would like created
//
// @authors: Monica Berrondo
//
// @last_modified: March 21 2006
// /////////////////////////////////////////////////////////////////////////////////////

#ifndef INCLUDED_domins_ns
#define INCLUDED_domins_ns

#include "pose_fwd.h"
#include "SplicedProtein.h"

// numeric Headers
#include "numeric/xyzVector.hh"

#include <map>

// forward declarations
namespace pose_ns { class Loops; }

// namespace
namespace domins_ns {

	//
	//
	// domins_ns: variables for domain insertion calculations using Rosetta
	//
	//

	// keeps track of the information about the host
	namespace domins_host{
		extern pose_ns::Pose host_protein_pose;
		extern pose_ns::Pose host_ppk_pose;
		extern int hostp_combined_begin;
		extern int hostp_combined_end;
		extern int hostp_begin;
		extern int hostp_end;
		extern int hostp_start_res;
		extern int hostp_end_res;
		extern int hostp_com;
		extern int hostp_part1_com;
		extern int hostp_part2_com;
		extern int hostp_nres;
		extern std::vector < numeric::xyzVector<double> > hostp_part1;
		extern std::vector < numeric::xyzVector<double> > hostp_part2;
		extern std::vector < numeric::xyzVector<double> > hostp_positions;
	}
	using namespace domins_host;

	// keeps track of the information about the insert
	namespace domins_insert{
		extern pose_ns::Pose insert_protein_pose;
		extern pose_ns::Pose insert_ppk_pose;
		extern int insertp_combined_begin;
		extern int insertp_combined_end;
		extern int insertp_begin;
		extern int insertp_end;
		extern int insertp_start_res;
		extern int insertp_end_res;
		extern int insertp_com;
		extern int insertp_nres;
		extern std::vector < numeric::xyzVector<double> > insertp_positions;
	}
	using namespace domins_insert;

	// keeps track of the information about the loops
	namespace domins_loops{
		extern pose_ns::Loops loops;
		extern int linker_size;
		extern int loops_com;
	}
	using namespace domins_loops;

	// maps and spliced protein information
	namespace domins_maps{
		extern std::map<std::string,std::string> params;
		extern SplicedProtein spliced_protein_map;
		extern std::vector<SplicedProtein> spliced_protein_res_info;
	}
	using namespace domins_maps;

	// everything that is stored that will later be called from the status file
	namespace domins_scores{
		extern float start_rmsd;
		extern float centroid_rmsd;
		extern float insert_rmsd;
		extern float rb_rmsd;
		extern float loop_rmsd;
		extern float loop1_rmsd;
		extern float loop2_rmsd;
		extern float rmsd_to_native;
		extern float centroid_score;
		extern int centroid_rejected;
	}
	using namespace domins_scores;

	// all the flags specific for domain insertion mode
	namespace domins_flags{
		extern bool fa_input_flag;
		extern bool fa_set;
		extern bool rb_relax;
		extern bool do_main_protocol;
		extern bool do_insertion_flop;
		extern bool fast_relax;
		extern bool repack_relax;
		extern bool loop_only;
		extern bool small_perturbation;
		extern bool no_loop;
		extern bool no_frags;
		extern bool no_perturb;
		extern bool prepack_read;
	}
	using namespace domins_flags;

	extern float initial_vdw;
	extern int nres;
}
#endif
