// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 01:39:36 -0500 (Sun, 18 Mar 2007) $
//  $Author: stuartm $


// Rosetta Headers
#include "dunbrack_pack.h"
#include "Dunbrack4D.h"
#include "Dunbrack5D.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/byte.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/FArray5D.hh>
#include <ObjexxFCL/Fmath.hh>

// Utility headers
#include <utility/vector1.hh>

// C++ Headers
#include <cmath>

// Using
using namespace param;


// bk contains namespace with variables that contain info
// bk about dunbrack"s rotamers
// ctsa mod to read in newest dunbrack rotamer set w/ all bb dep chi angles and sds


namespace dunbrack_pack {


int const rot_per_chi = { 3 };

// exception for ASN chi2
int const max_rot_per_chi2 = { 6 };

// exception for GLN chi3
int const max_rot_per_chi3 = { 4 };

int const max_rot_per_bin = { nint( std::pow( static_cast< double >( rot_per_chi ), MAX_CHI ) ) };

Dimension & nbins() { static Dimension d; return d; } // Number of phi & psi angle bins

Dimension & max_packed_rotno() { static Dimension d; return d; }


namespace dunbrack {
	FArray5D_short aa_rotno_to_packedrotno( MAX_AA(), DRange( 0, rot_per_chi ),
	 DRange( 0, max_rot_per_chi2 ), DRange( 0, max_rot_per_chi3 ),
	 DRange( 0, rot_per_chi ) );
	Dunbrack4D dun_chi;
	 //Objexx:SGM Replaced FArray4D_float dun_chi( 36, 36, max_packed_rotno, MAX_CHI, 0.0f );
	Dunbrack4D dun_sd;
	 //Objexx:SGM Replaced FArray4D_float dun_sd( 36, 36, max_packed_rotno, MAX_CHI, 0.0f );
	FArray3D_float dun_prob( nbins(), nbins(), max_packed_rotno(), 0.0f );
	Dunbrack5D dun_group_rotno_to_rotno;
	 //Objexx:SGM Replaced FArray5D_byte dun_group_rotno_to_rotno( 36, 36, MAX_AA(), max_rot_per_bin, MAX_CHI, byte( 0 ) );
	FArray3D_float highest_dun_prob( nbins(), nbins(), MAX_AA() );
}


// extra rotamers in addition to the canonical library
namespace dunbrack_extra {
	utility::vector1< std::list< FArray1D_float > > total_chi_set_db(20);
}


} // namespace dunbrack_pack
