// -*-
// mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t
// -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8698 $
//  $Date: 2006-06-05 22:50:03 -0700 (Mon, 05 Jun 2006) $
//  $Author: pbradley $

//#ifndef INCLUDED_electron_density
//#define INCLUDED_electron_density

// Rosetta++ headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray4Da.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray1Da.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>
#include <numeric/xyzMatrix.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>

	class ElectronDensity {
		public:
		//constructor
			ElectronDensity():
				min_(0),
				max_(0),
				mean_(0),
				rms_(0)
			{}
			~ElectronDensity(){}

		void
		set_cell_origin(
			FArray1DB_int const & origin
		);

		void
    set_grid_dimension(
			FArray1DB_int const & grid_size
		);

		void
    set_data_point_size(
			FArray1DB_int const & data_size
		);

		void
		set_cell_dimension(
			FArray1DB_float const & cell_dimension
		);

		void
    set_cell_angle(
			FArray1DB_float const & angles
		);

		void
    set_grid_step(
			FArray1DB_float const & step
		);

		void
		set_threshold(
			float & threshold
		);

		void
		set_min(
			float const & min
		);

		void
		set_max(
			float & max
		);

		void
		set_mean(
			float & mean
		);

		void
		set_rms(
			float & rms
		);

		void
		set_density(
			FArray3DB_float const & density
		);

		void
		set_principal_component(
			numeric::xyzMatrix_float & principal_components
		);

		void
		set_center_of_mass(
			numeric::xyzVector_float & center_of_mass
		);

		FArray3D_float const &
		density() const;

		FArray4D_float const &
    grid_xyz() const;

		FArray1D_int const &
		data_point_size() const;

		FArray1D_int const &
    cell_origin() const;

		FArray1D_float const &
    cell_dimension() const;

		FArray1D_float const &
    cell_angle() const;

		FArray1D_int const &
    grid_dimension() const;

		FArray1D_float const &
    grid_step() const;

		float const &
		threshold() const;

		float const &
		min() const;

		float const &
    max() const;

		float const &
    mean() const;

		float const &
    rms() const;

		numeric::xyzMatrix_float const &
		principal_component() const;

		numeric::xyzVector_float const &
    center_of_mass() const;

		void
		print();

		FArray1D_float const
		index_to_xyz(
		int const i,
		int const j,
		int const k
		) const;

	void
	set_grid_xyz();

	void
	find_center();

	void
	rotate_to_principal_frame();

	void
	principal_moments_of_inertia_electron_density();

	void
	get_moment_of_inertia(
		numeric::xyzVector_float & center_of_mass,
		numeric::xyzMatrix_float & I
	);

	void
	find_n_fold_axis(
		int const N,
		numeric::xyzVector_float & symm_axis
	);

		//destructor
		private:
		FArray3D_float density_;
		FArray4D_float grid_xyz_;
		FArray1D_int data_point_size_;
		FArray1D_int cell_origin_;
		FArray1D_float cell_dimension_;
		FArray1D_float cell_angle_;
		FArray1D_int grid_dimension_;
		FArray1D_float grid_step_;
		numeric::xyzMatrix_float principal_component_;
		numeric::xyzVector_float center_of_mass_;
		float threshold_;
		float min_;
		float max_;
		float mean_;
		float rms_;
	};

void
read_electron_density_map();

void
set_cell_origin(
	ElectronDensity & ED,
	int *origin
	);

void
set_grid_dimension(
	ElectronDensity & ED,
	int *grid
	);

void
set_data_point_size(
  ElectronDensity & ED,
  int *size
  );

void
set_cell_dimension(
  ElectronDensity & ED,
  float *cell_data
  );

void
set_grid_step(
  ElectronDensity & ED
  );

void
fill_density(
  ElectronDensity & ED,
  float ***map
);

void
set_min_max_mean_rms(
  ElectronDensity & ED,
  float min,
  float max,
  float mean,
  float rms
  );

void
principal_moments_of_inertia(
  pose_ns::Pose & pose,
	numeric::xyzVector_float & center_of_mass,
	numeric::xyzMatrix_float & principal_components
);

void
principal_moments_of_inertia(
  pose_ns::Pose const & pose,
  numeric::xyzVector_float & center_of_mass,
  numeric::xyzMatrix_float & principal_components
);

void
principal_moments_of_inertia(
	pose_ns::Pose & pose,
	numeric::xyzMatrix_float & principal_components
	);

void
principal_moments_of_inertia(
  FArray3Da_float Epos,
  int const nres,
  numeric::xyzVector_float & center_of_mass,
  numeric::xyzMatrix_float & principal_components
);

void
sort_eigenvectors(
	numeric::xyzVector_float & eigenvalues,
	numeric::xyzMatrix_float & eigenvectors
	);


void
transform_to_principal_frame(
			     pose_ns::Pose & pose
			     );

void
transform_to_principal_frame(
	FArray2Da_float Epos,
	int const nres,
	numeric::xyzVector_float & center_of_mass,
	numeric::xyzMatrix_float & principal_component,
	int const i = 1,
	int const j = 1,
	int const k = 1
);


void
transform_to_principal_frame(
	pose_ns::Pose & pose,
	numeric::xyzVector_float & center_of_mass,
	numeric::xyzMatrix_float & principal_component,
	int const i = 1,
  int const j = 1,
  int const k = 1
);

float
eval_electron_density_score(
 pose_ns::Pose const & pose
);

float
score_electron_density(
	FArray2Da_float Epos_ca,
	int const nres
);

namespace electron_density_map{
  extern bool density_map_initialized;
  extern bool density_map_present;
  extern ElectronDensity native_electron_density;
  extern numeric::xyzVector_float center_of_mass;
  extern numeric::xyzMatrix_float principal_components;
  extern int axis1_flip;
  extern int axis2_flip;
  extern int axis3_flip;
}


void
electron_density_score_test();

bool
get_electron_density_file_flag();


