// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14003 $
//  $Date: 2007-04-06 14:24:40 -0400 (Fri, 06 Apr 2007) $
//  $Author: snoeyink $


// Rosetta Headers
#include "etable.h"
#include "param.h"
#include "param_pack.h"


// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

// Using
using namespace param;


//------------------------------------------------------------------------------
//
//  etable include file:
//
//    initialization of all parameters and tables used to generate
//      lj vdw and lk solv energy tables
//
//    ctsa - note that this file was assembled to support the etable
//      calculation functions run at fullatom mode startup - don't
//      store variables here unless they are exclusively used to
//      setup the etable, and don't include this file elsewhere
//
//------------------------------------------------------------------------------


namespace etable {


//car cvs revision and date
//car DO NOT CHANGE THESE!! SET AUTOMATICALLY BY CVS
std::string const fa_etable_revision( "$Revision: 14003 $" );
std::string const fa_etable_date( "$Date: 2007-04-06 14:24:40 -0400 (Fri, 06 Apr 2007) $" );


//car declaration of variables for values precomputed from adjustable parameters

namespace fa_etable_precompute {
	double fa_lj_switch_sigma2dis;
	double fa_lj_switch_value2wdepth;
	double fa_lj_switch_slope_sigma2wdepth;
}


//------------------------------------------------------------------------------
//  adjustable parameters
//------------------------------------------------------------------------------
//   parameter set identification:
std::string const fa_etable_label( "polh_aroh " );

//
//  global modification to CHarMM radii
//
float fa_Wradius = { 1.00 };

//
//  distance at which two S are considered diS
//
float const fa_disulfide_dis_thresh = { -1.0 }; // take the disulfide scheme out

//
//  lj vdw radius between disulfide cysteines
//
float const fa_disulfide_radius = { 1.04 };

	//// ctsa - when the distance/sigma ratio is below the
	////   switchover threshold: fa_lj_switch_dis2sigma, then
	////   the potential is calculated from a linear projection of the
	////   lj value rather than the true lj value.
	////


namespace etable_runtime_parameters {
	float fa_lj_switch_dis2sigma; // actual value used
}

float highres_lj_lin_sig = { 0.60 }; // default
float const lowres_lj_lin_sig = { 0.89 };

//
// if true, use the lj deriv as slope from sigma linear start point
//
bool const fa_lj_use_lj_deriv_slope = { true };

//
//  if not, then force the y-axis intercept here
//
float const fa_lj_slope_intercept = { 0.00 };

//
//  if true, use special radii for hbond donor acceptor pairs
//
bool const fa_lj_use_hbond_radii = { true };

//
//  special radius for hbond donor acceptor pairs,and polar H acceptors
//
float const fa_lj_hbond_dis = { 3.0 };
float const fa_lj_hbond_hdis = { 1.95 };
//pb  special radius for hbond donor acceptor pairs with neutral O donor and charged O acceptor
float const fa_lj_hbond_accOch_dis = { 2.80 };
//pb  special radius for polar hydrogen donor and charged O acceptor
float const fa_lj_hbond_accOch_hdis = { 1.75 };

//
//  if true, use special radii for water-polar pairs
//
bool const fa_lj_use_water_radii = { true };

//
//  special radius for water-polar atom pairs
//
float const fa_lj_water_dis = { 3.0 };
float const fa_lj_water_hdis = { 1.95 };


	//// ctsa - when the distance/sigma ratio is below
	////   the switchover ratio: fa_lk_min_dis2sigma,
	////   then the lk solvation is constant, with a value
	////   equal to the solvation value at the switchover ratio
	////
float const fa_lk_min_dis2sigma = { 0.89 };

	//// an interatomic distance less than fa_min_dis
	////   will be set to fa_min_dis
	////
float const fa_min_dis = { 0.01 };

	//// derived from fa_min_dis...
double const fa_min_dis2 = { fa_min_dis * fa_min_dis };


//
//  if true, add a linear smooth to 0. at the max distance range
//    for all lj and lk terms
//
bool const fa_add_long_range_damping = { true };


//
//  if damping is turned on, then...
//    at fa_max_dis - fa_long_range_damping_length, set lj and lk to
//    a linear slope to reach 0. at fa_max_dis
//
float const fa_long_range_damping_length = { 0.5 };


//
//  lj, lk, hbond tables: initializers
//


//------------------------------------------------------------------------------
//  values
// lj vdw parameters
//
//bk lj radii are intended to be used with explicit hydrogens
//bk lj radius determined by fitting 12-6 potential to
//bk the log probability of seeing two atom types at a particular
//bk distance in the pdb.  The fitting was done by eye and the
//bk distances were picked so that the repulsive parts of the 12-6
//bk and the log probability overlapped.
void
fa_lj_radius_initializer( FArray1D_float & fa_lj_radius )
{
	if ( fa_lj_radius.u() == 0 ) return;
	int i = 0;
	fa_lj_radius( ++i ) = 2.0000; // 1  carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_lj_radius( ++i ) = 2.0000; // 2  carboxyl C in Asp and Glu
	fa_lj_radius( ++i ) = 2.0000; // 3  aliphatic C with one H (Val, Ile, Thr)
	fa_lj_radius( ++i ) = 2.0000; // 4  aliphatic C with two H (other residues)
	fa_lj_radius( ++i ) = 2.0000; // 5  aliphatic C with three H (Ala)
	fa_lj_radius( ++i ) = 2.0000; // 6  aromatic ring C (His, Phe, Tyr, Trp)
	fa_lj_radius( ++i ) = 1.7500; // 7  N in Trp side-chain
	fa_lj_radius( ++i ) = 1.7500; // 8  N in His side-chain
	fa_lj_radius( ++i ) = 1.7500; // 9  N in Asn and Gln side-chain
	fa_lj_radius( ++i ) = 1.7500; // 10 N in Lys side-chain; N-terminus?
	fa_lj_radius( ++i ) = 1.7500; // 11 N in Arg side-chain
	fa_lj_radius( ++i ) = 1.7500; // 12 N in Pro backbone
	fa_lj_radius( ++i ) = 1.5500; // 13 hydroxyl O in Ser, Thr and Tyr
	fa_lj_radius( ++i ) = 1.5500; // 14 carbonyl O in Asn and Gln
	fa_lj_radius( ++i ) = 1.5500; // 15 carboyxl O in Asp and Glu
	fa_lj_radius( ++i ) = 1.9000; // 16 sulfur in Cys and Met
	fa_lj_radius( ++i ) = 1.7500; // 17 backbone N'
	fa_lj_radius( ++i ) = 2.0000; // 18 backbone CA
	fa_lj_radius( ++i ) = 2.0000; // 19 backbone C'
	fa_lj_radius( ++i ) = 1.5500; // 20 backbone O'
	fa_lj_radius( ++i ) = 2.1500; // 21 P in Phosphate ;  CHARMM27 for DNA, MacKerell 2004;kosta makrodimitris
	fa_lj_radius( ++i ) = 1.0000; // 22 polar H // cmd modified in DNA mode
	fa_lj_radius( ++i ) = 1.2000; // 23 nonpolar H // cmd modified in DNA mode
	fa_lj_radius( ++i ) = 1.2000; // 24 aromatic H // cmd modified in DNA mode
	fa_lj_radius( ++i ) = 1.0000; // 25 backbone HN // cmd modified in DNA mode
	if ( fa_lj_radius.u() == 25 ) return;
	fa_lj_radius( ++i ) = 1.4000; // H2O
	if ( fa_lj_radius.u() == 26 ) return;
	fa_lj_radius( ++i ) = 1.7100; // F  taken from MM3 forcefield
	fa_lj_radius( ++i ) = 2.0700; // Cl taken from MM3 forcefield
	fa_lj_radius( ++i ) = 2.2200; // Br taken from MM3 forcefield
	fa_lj_radius( ++i ) = 2.3600; // I  taken from MM3 forcefield
	fa_lj_radius( ++i ) = 1.0900; // Zn2p ion radius CHARMM27
	fa_lj_radius( ++i ) = 0.7800; // Fe2p ion radius CHARMM27
	fa_lj_radius( ++i ) = 0.6500; // Fe3p ion radius CHARMM27
	fa_lj_radius( ++i ) = 1.1850; // Mg2p ion radius CHARMM27
	fa_lj_radius( ++i ) = 1.3670; // Ca2p, Marchard 1998 Proteins;CHARMM27, MacKerell 2004;kosta makrodimitris
	fa_lj_radius( ++i ) = 1.3638; // Na1p ion radius CHARMM27
	fa_lj_radius( ++i ) = 1.7638; // K1p  ion radius CHARMM27
	fa_lj_radius( ++i ) = 1.6450; // Au; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_radius( ++i ) = 1.6000; // O in ice; Modified TIP3P Neria et al
	fa_lj_radius( ++i ) = 0.8000; // H in ice; Modified TIP3P Neria et al
	fa_lj_radius( ++i ) = 2.1475; // Si in quartz; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_radius( ++i ) = 1.7500; // O in quartz; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_radius( ++i ) = 1.7000; // OP  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 1.7700; // OH OC in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 0.2245; // HOP in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 2.1500; // P/HA ;  CHARMM27 for DNA, MacKerell 2004;kosta makrodimitris
	fa_lj_radius( ++i ) = 1.7000; // OP/HA ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 1.7700; // OH/HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 0.2245; // HOP/HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 2.2750; // CS1; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 2.2750; // CS2; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 2.2750; // CS5; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 2.2750; // CS6; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 1.7700; // O5;  CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 0.0000; // V01
	fa_lj_radius( ++i ) = 0.0000; // V02
	fa_lj_radius( ++i ) = 0.0000; // V03
	fa_lj_radius( ++i ) = 0.0000; // V04
	fa_lj_radius( ++i ) = 0.0000; // V05
	fa_lj_radius( ++i ) = 0.0000; // V06
	fa_lj_radius( ++i ) = 0.0000; // V07
	fa_lj_radius( ++i ) = 0.0000; // V08
	fa_lj_radius( ++i ) = 0.0000; // V09
	fa_lj_radius( ++i ) = 0.0000; // V10
	fa_lj_radius( ++i ) = 0.0000; // V11
	fa_lj_radius( ++i ) = 0.0000; // V12
	fa_lj_radius( ++i ) = 0.0000; // V13
	fa_lj_radius( ++i ) = 0.0000; // V14
	fa_lj_radius( ++i ) = 0.0000; // V15
	fa_lj_radius( ++i ) = 0.0000; // V16
	fa_lj_radius( ++i ) = 0.0000; // V17
//******************************************************************************
//vats Vatsan Raman
//vats Nucleic acid vdw radius from CHARMM 27  (NA=Nucleic acid)
// Foloppe et al Journal of Comp. Chem 21:86-104 (2000)
// Mackerell,Jr et al Journal of Comp. Chem 21:105-120 (2000)
//******************************************************************************
//	fa_lj_radius( ++i ) = 1.9000; // CN1  carbonyl carbon
//	fa_lj_radius( ++i ) = 1.9000; // CN2  aromatic carbon to amide
//	fa_lj_radius( ++i ) = 1.9000; // CN3  aromatic carbon
//	fa_lj_radius( ++i ) = 1.9000; // CN4  purine C8 and ADE C2
//	fa_lj_radius( ++i ) = 1.9000; // CN5  purine C4 and C5
//	fa_lj_radius( ++i ) = 1.9000; // CN7  carbon (C1',C2',C3',C4')
//	fa_lj_radius( ++i ) = 2.0000; // CN8  carbon (C5')
//	fa_lj_radius( ++i ) = 2.0000; // CN9  carbon (C5M)
//	fa_lj_radius( ++i ) = 1.8500; // NN1  amide nitrogen
//	fa_lj_radius( ++i ) = 1.8500; // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//	fa_lj_radius( ++i ) = 1.8500; // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//	fa_lj_radius( ++i ) = 1.8500; // NN4  purine N7
//	fa_lj_radius( ++i ) = 1.7000; // ON1  carbonyl oxygen
//	fa_lj_radius( ++i ) = 1.7700; // ON2  phosphate ester oxygen
//	fa_lj_radius( ++i ) = 1.7000; // ON3  =O in phosphate
//	fa_lj_radius( ++i ) = 1.7700; // ON4  phosphate hydroxyl oxygen
//	fa_lj_radius( ++i ) = 1.7700; // ON5  ribose hydroxyl oxygen
//	fa_lj_radius( ++i ) = 1.7700; // ON6  deoxyribose, ribose ring oxygen
//	fa_lj_radius( ++i ) = 1.3400; // H    polar hydrogen
//	fa_lj_radius( ++i ) = 1.2000; // H    non-polar hydrogen
}

//------------------------------------------------------------------------------
//  values
// lj vdw parameters for jjh's soft potentials
void
fa_lj_soft_initializer( FArray1D_float & fa_lj_radius )
{
	if ( fa_lj_radius.u() == 0 ) return;
	int i = 0;
	fa_lj_radius( ++i ) = 2.0000; // 1  carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_lj_radius( ++i ) = 2.0000; // 2  carboxyl C in Asp and Glu
	fa_lj_radius( ++i ) = 2.1400; // 3  aliphatic C with one H (Val, Ile, Thr)
	fa_lj_radius( ++i ) = 2.1400; // 4  aliphatic C with two H (other residues)
	fa_lj_radius( ++i ) = 2.1400; // 5  aliphatic C with three H (Ala)
	fa_lj_radius( ++i ) = 2.1400; // 6  aromatic ring C (His, Phe, Tyr, Trp)
	fa_lj_radius( ++i ) = 1.7500; // 7  N in Trp side-chain
	fa_lj_radius( ++i ) = 1.7500; // 8  N in His side-chain
	fa_lj_radius( ++i ) = 1.7500; // 9  N in Asn and Gln side-chain
	fa_lj_radius( ++i ) = 1.7500; // 10 N in Lys side-chain; N-terminus?
	fa_lj_radius( ++i ) = 1.7500; // 11 N in Arg side-chain
	fa_lj_radius( ++i ) = 1.8725; // 12 N in Pro backbone
	fa_lj_radius( ++i ) = 1.6585; // 13 hydroxyl O in Ser, Thr and Tyr
	fa_lj_radius( ++i ) = 1.5500; // 14 carbonyl O in Asn and Gln
	fa_lj_radius( ++i ) = 1.5500; // 15 carboyxl O in Asp and Glu
	fa_lj_radius( ++i ) = 2.0330; // 16 sulfur in Cys and Met
	fa_lj_radius( ++i ) = 1.8725; // 17 backbone N'
	fa_lj_radius( ++i ) = 2.1400; // 18 backbone CA
	fa_lj_radius( ++i ) = 2.1400; // 19 backbone C'
	fa_lj_radius( ++i ) = 1.6585; // 20 backbone O'
	fa_lj_radius( ++i ) = 2.1500; // 21 P in Phosphate ;  CHARMM27 for DNA,MacKerell 2004;kosta makrodimitris
	fa_lj_radius( ++i ) = 1.0700; // 22 polar H      // Mod by get_dna_packer_weights
	fa_lj_radius( ++i ) = 1.2840; // 23 nonpolar H   // Mod by get_dna_packer_weights
	fa_lj_radius( ++i ) = 1.2840; // 24 aromatic H   // Mod by get_dna_packer_weights
	fa_lj_radius( ++i ) = 1.0700; // 25 backbone HN  // Mod by get_dna_packer_weights
	if ( fa_lj_radius.u() == 25 ) return;
	fa_lj_radius( ++i ) = 1.4000; // H2O
	if ( fa_lj_radius.u() == 26 ) return;
	fa_lj_radius( ++i ) = 1.7100; // F  taken from MM3 forcefield
	fa_lj_radius( ++i ) = 2.0700; // Cl taken from MM3 forcefield
	fa_lj_radius( ++i ) = 2.2200; // Br taken from MM3 forcefield
	fa_lj_radius( ++i ) = 2.3600; // I  taken from MM3 forcefield
	fa_lj_radius( ++i ) = 1.0900; // Zn2p ion radius CHARMM27
	fa_lj_radius( ++i ) = 0.7800; // Fe2p ion radius CHARMM27
	fa_lj_radius( ++i ) = 0.6500; // Fe3p ion radius CHARMM27
	fa_lj_radius( ++i ) = 1.1850; // Mg2p ion radius CHARMM27
	fa_lj_radius( ++i ) = 1.4630; // Ca2p i,Marchard 1998 Proteins;CHARMM27, MacKerell 2004;kosta makrodimitris
	fa_lj_radius( ++i ) = 1.3638; // Na1p ion radius CHARMM27
	fa_lj_radius( ++i ) = 1.7638; // K1p  ion radius CHARMM27
	fa_lj_radius( ++i ) = 1.7600; // Au; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_radius( ++i ) = 1.7120; // O in ice; Modified TIP3P Neria et al
	fa_lj_radius( ++i ) = 0.8560; // H in ice; Modified TIP3P Neria et al
	fa_lj_radius( ++i ) = 2.3000; // Si in quartz; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_radius( ++i ) = 1.8700; // O in quartz; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_radius( ++i ) = 1.8200; // OP  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 1.8900; // OH OC  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 0.2400; // HOP in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 2.3000; // P/HA;  CHARMM27 for DNA,MacKerell 2004;kosta makrodimitris
	fa_lj_radius( ++i ) = 1.8200; // OP/HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 1.8900; // OH/HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 0.2400; // HOP/HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_radius( ++i ) = 2.2750; // CS1; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 2.2750; // CS2; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 2.2750; // CS5; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 2.2750; // CS6; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 1.7700; // O5;  CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_radius( ++i ) = 0.0000; // V01
	fa_lj_radius( ++i ) = 0.0000; // V02
	fa_lj_radius( ++i ) = 0.0000; // V03
	fa_lj_radius( ++i ) = 0.0000; // V04
	fa_lj_radius( ++i ) = 0.0000; // V05
	fa_lj_radius( ++i ) = 0.0000; // V06
	fa_lj_radius( ++i ) = 0.0000; // V07
	fa_lj_radius( ++i ) = 0.0000; // V08
	fa_lj_radius( ++i ) = 0.0000; // V09
	fa_lj_radius( ++i ) = 0.0000; // V10
	fa_lj_radius( ++i ) = 0.0000; // V11
	fa_lj_radius( ++i ) = 0.0000; // V12
	fa_lj_radius( ++i ) = 0.0000; // V13
	fa_lj_radius( ++i ) = 0.0000; // V14
	fa_lj_radius( ++i ) = 0.0000; // V15
	fa_lj_radius( ++i ) = 0.0000; // V16
	fa_lj_radius( ++i ) = 0.0000; // V17
//******************************************************************************
//vats Vatsan Raman
//vats Nucleic acid vdw radius from CHARMM 27  (NA=Nucleic acid)
// Foloppe et al Journal of Comp. Chem 21:86-104 (2000)
// Mackerell,Jr et al Journal of Comp. Chem 21:105-120 (2000)
//******************************************************************************
//	fa_lj_radius( ++i ) = 1.9000; // CN1  carbonyl carbon
//	fa_lj_radius( ++i ) = 1.9000; // CN2  aromatic carbon to amide
//	fa_lj_radius( ++i ) = 1.9000; // CN3  aromatic carbon
//	fa_lj_radius( ++i ) = 1.9000; // CN4  purine C8 and ADE C2
//	fa_lj_radius( ++i ) = 1.9000; // CN5  purine C4 and C5
//	fa_lj_radius( ++i ) = 1.9000; // CN7  carbon (C1',C2',C3',C4')
//	fa_lj_radius( ++i ) = 2.0000; // CN8  carbon (C5')
//	fa_lj_radius( ++i ) = 2.0000; // CN9  carbon (C5M)
//	fa_lj_radius( ++i ) = 1.8500; // NN1  amide nitrogen
//	fa_lj_radius( ++i ) = 1.8500; // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//	fa_lj_radius( ++i ) = 1.8500; // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//	fa_lj_radius( ++i ) = 1.8500; // NN4  purine N7
//	fa_lj_radius( ++i ) = 1.7000; // ON1  carbonyl oxygen
//	fa_lj_radius( ++i ) = 1.7700; // ON2  phosphate ester oxygen
//	fa_lj_radius( ++i ) = 1.7000; // ON3  =O in phosphate
//	fa_lj_radius( ++i ) = 1.7700; // ON4  phosphate hydroxyl oxygen
//	fa_lj_radius( ++i ) = 1.7700; // ON5  ribose hydroxyl oxygen
//	fa_lj_radius( ++i ) = 1.7700; // ON6  deoxyribose, ribose ring oxygen
//	fa_lj_radius( ++i ) = 1.3400; // H    polar hydrogen
//	fa_lj_radius( ++i ) = 1.2000; // H    non-polar hydrogen
}

//******************************************************************************
//**   Well Depth from CHAARM 19
//**   Neria et al. J. Chem. Phys., 105, pg 1902 (1996)
//bk   carboxyl O has been reduced so that buried Glu and Asp
//bk   are not favored.
//------------------------------------------------------------------------------
void
fa_lj_wdepth_initializer( FArray1D_float & fa_lj_wdepth )
{
	if ( fa_lj_wdepth.u() == 0 ) return;
	int i = 0;
	fa_lj_wdepth( ++i ) = 0.1200; // carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_lj_wdepth( ++i ) = 0.1200; // carboxyl C in Asp and Glu
	fa_lj_wdepth( ++i ) = 0.0486; // aliphatic C with one H (Val, Ile, Thr)
	fa_lj_wdepth( ++i ) = 0.1142; // aliphatic C with two H (other residues)
	fa_lj_wdepth( ++i ) = 0.1811; // aliphatic C with three H (Ala)
	fa_lj_wdepth( ++i ) = 0.1200; // aromatic ring C (His, Phe, Tyr, Trp)
	fa_lj_wdepth( ++i ) = 0.2384; // N in Trp side-chain
	fa_lj_wdepth( ++i ) = 0.2384; // N in His side-chain
	fa_lj_wdepth( ++i ) = 0.2384; // N in Asn and Gln side-chain
	fa_lj_wdepth( ++i ) = 0.2384; // N in Lys side-chain; N-terminus?
	fa_lj_wdepth( ++i ) = 0.2384; // N in Arg side-chain
	fa_lj_wdepth( ++i ) = 0.2384; // N in Pro backbone
	fa_lj_wdepth( ++i ) = 0.1591; // hydroxyl O in Ser, Thr and Tyr
	fa_lj_wdepth( ++i ) = 0.1591; // carbonyl O in Asn and Gln
	fa_lj_wdepth( ++i ) = 0.2100; // carboyxl O in Asp and Glu
	fa_lj_wdepth( ++i ) = 0.1600; // sulfur in Cys and Met
	fa_lj_wdepth( ++i ) = 0.2384; // backbone N'
	fa_lj_wdepth( ++i ) = 0.0486; // backbone CA
	fa_lj_wdepth( ++i ) = 0.1400; // backbone C'
	fa_lj_wdepth( ++i ) = 0.1591; // backbone O'
	fa_lj_wdepth( ++i ) = 0.5850; // P in Phosphate;CHARMM27 for DNA,MacKerell 2004;kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.0500; // polar H
	fa_lj_wdepth( ++i ) = 0.0500; // nonpolar H
	fa_lj_wdepth( ++i ) = 0.0500; // aromatic H
	fa_lj_wdepth( ++i ) = 0.0500; // backbone HN
	if ( fa_lj_wdepth.u() == 25 ) return;
	fa_lj_wdepth( ++i ) = 0.0500; // H2O
	if ( fa_lj_wdepth.u() == 26 ) return;
	fa_lj_wdepth( ++i ) = 0.0750; // F  taken from MM3 forcefield
	fa_lj_wdepth( ++i ) = 0.2400; // Cl taken from MM3 forcefield
	fa_lj_wdepth( ++i ) = 0.3200; // Br taken from MM3 forcefield
	fa_lj_wdepth( ++i ) = 0.4240; // I  taken from MM3 forcefield
	fa_lj_wdepth( ++i ) = 0.2500; // Zn2p taken from CHARMM27
	fa_lj_wdepth( ++i ) = 0.0000; // Fe2p taken from CHARMM27
	fa_lj_wdepth( ++i ) = 0.0000; // Fe3p taken from CHARMM27
	fa_lj_wdepth( ++i ) = 0.0150; // Mg2p taken from CHARMM27
	fa_lj_wdepth( ++i ) = 0.1200; // Ca2p Marchard 1998 Proteins;CHARMM27, MacKerell 2004;kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.0469; // Na1p taken from CHARMM27
	fa_lj_wdepth( ++i ) = 0.0870; // K1p  taken from CHARMM27
	fa_lj_wdepth( ++i ) = 0.0390; // Au; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_wdepth( ++i ) = 0.1591; // O in ice; Modified TIP3P water oxygen Neria et al
	fa_lj_wdepth( ++i ) = 0.0498; // H in ice; Modified TIP3P water hydrogen Neria et al
	fa_lj_wdepth( ++i ) = 0.4020; // Si in quartz; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_wdepth( ++i ) = 0.0600; // O in quartz; UFF table J. Am. Chem. Soc. 1992, 114
	fa_lj_wdepth( ++i ) = 0.1200; // OP  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.1521; // POH in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.0460; // HOP in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.5850; // P/HA;CHARMM27 for DNA,MacKerell 2004;kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.1200; // OP/HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.1521; // POH/HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.0460; // HOP/HA;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
	fa_lj_wdepth( ++i ) = 0.0200; // CS1; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_wdepth( ++i ) = 0.0200; // CS2; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_wdepth( ++i ) = 0.0200; // CS5; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_wdepth( ++i ) = 0.0200; // CS6; CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_wdepth( ++i ) = 0.1521; // O5;  CHARMM for sugar, liang and brady 95, bkidd
	fa_lj_wdepth( ++i ) = 0.0000; // V01
	fa_lj_wdepth( ++i ) = 0.0000; // V02
	fa_lj_wdepth( ++i ) = 0.0000; // V03
	fa_lj_wdepth( ++i ) = 0.0000; // V04
	fa_lj_wdepth( ++i ) = 0.0000; // V05
	fa_lj_wdepth( ++i ) = 0.0000; // V06
	fa_lj_wdepth( ++i ) = 0.0000; // V07
	fa_lj_wdepth( ++i ) = 0.0000; // V08
	fa_lj_wdepth( ++i ) = 0.0000; // V09
	fa_lj_wdepth( ++i ) = 0.0000; // V10
	fa_lj_wdepth( ++i ) = 0.0000; // V11
	fa_lj_wdepth( ++i ) = 0.0000; // V12
	fa_lj_wdepth( ++i ) = 0.0000; // V13
	fa_lj_wdepth( ++i ) = 0.0000; // V14
	fa_lj_wdepth( ++i ) = 0.0000; // V15
	fa_lj_wdepth( ++i ) = 0.0000; // V16
	fa_lj_wdepth( ++i ) = 0.0000; // V17
//******************************************************************************
//vats LJ well-depth for Nucleic acids from CHARMM 27
// Foloppe et al Journal of Comp. Chem 21:86-104 (2000)
// Mackerell,Jr et al Journal of Comp. Chem 21:105-120 (2000
//******************************************************************************
//	fa_lj_wdepth( ++i ) = 0.1000; // CN1  carbonyl carbon
//	fa_lj_wdepth( ++i ) = 0.1000; // CN2  aromatic carbon to amide
//	fa_lj_wdepth( ++i ) = 0.0900; // CN3  aromatic carbon
//	fa_lj_wdepth( ++i ) = 0.0750; // CN4  purine C8 and ADE C2
//	fa_lj_wdepth( ++i ) = 0.0750; // CN5  purine C4 and C5
//	fa_lj_wdepth( ++i ) = 0.0200; // CN7  carbon (C1',C2',C3',C4')
//	fa_lj_wdepth( ++i ) = 0.0560; // CN8  carbon (C5')
//	fa_lj_wdepth( ++i ) = 0.0780; // CN9  carbon (C5M)
//	fa_lj_wdepth( ++i ) = 0.2000; // NN1  amide nitrogen
//	fa_lj_wdepth( ++i ) = 0.2000; // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//	fa_lj_wdepth( ++i ) = 0.2000; // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//	fa_lj_wdepth( ++i ) = 0.2000; // NN4  purine N7
//	fa_lj_wdepth( ++i ) = 0.1200; // ON1  carbonyl oxygen
//	fa_lj_wdepth( ++i ) = 0.1521; // ON2  phosphate ester oxygen
//	fa_lj_wdepth( ++i ) = 0.1200; // ON3  =O in phosphate
//	fa_lj_wdepth( ++i ) = 0.1521; // ON4  phosphate hydroxyl oxygen
//	fa_lj_wdepth( ++i ) = 0.1521; // ON5  ribose hydroxyl oxygen
//	fa_lj_wdepth( ++i ) = 0.1521; // ON6  deoxyribose, ribose ring oxygen
//	fa_lj_wdepth( ++i ) = 0.0460; // H    polar hydrogen
//	fa_lj_wdepth( ++i ) = 0.0220; // H    non-polar hydrogen
}


//------------------------------------------------------------------------------
// lk solv parameters
//
//** volumes and dGfree from
//**  Lazaridis et al, Proteins 1999
//bk some values have been changed to better reproduce native
//bk sequences when redesigning protein backbones
//------------------------------------------------------------------------------

void
fa_lk_volume_initializer( FArray1D_float & fa_lk_volume )
{
	if ( fa_lk_volume.u() == 0 ) return;
	int i = 0;
	fa_lk_volume( ++i ) = 14.7; // carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_lk_volume( ++i ) =  8.3; // carboxyl C in Asp and Glu
	fa_lk_volume( ++i ) = 23.7; // aliphatic C with one H (Val, Ile, Thr)
	fa_lk_volume( ++i ) = 22.4; // aliphatic C with two H (other residues)
	fa_lk_volume( ++i ) = 30.0; // aliphatic C with three H (Ala)
	fa_lk_volume( ++i ) = 18.4; // aromatic ring C (His, Phe, Tyr, Trp)
	fa_lk_volume( ++i ) =  4.4; // N in Trp side-chain
	fa_lk_volume( ++i ) =  4.4; // N in His side-chain
	fa_lk_volume( ++i ) = 11.2; // N in Asn and Gln side-chain
	fa_lk_volume( ++i ) = 11.2; // N in Lys side-chain, N-terminus?
	fa_lk_volume( ++i ) = 11.2; // N in Arg side-chain
	fa_lk_volume( ++i ) =  0.0; // N in Pro backbone
	fa_lk_volume( ++i ) = 10.8; // hydroxyl O in Ser, Thr and Tyr
	fa_lk_volume( ++i ) = 10.8; // carbonyl O in Asn and Gln
	fa_lk_volume( ++i ) = 10.8; // carboyxl O in Asp and Glu
	fa_lk_volume( ++i ) = 14.7; // sulfur in Cys and Met
	fa_lk_volume( ++i ) =  4.4; // backbone N'
	fa_lk_volume( ++i ) = 23.7; // backbone CA
	fa_lk_volume( ++i ) = 14.7; // backbone C'
	fa_lk_volume( ++i ) = 10.8; // backbone O'
	fa_lk_volume( ++i ) = 34.8; // P in Phosphate ; CHARMM27 for DNA, MacKerell 2004;kosta makrodimitris 10/2005
	fa_lk_volume( ++i ) =  0.0; // polar H
	fa_lk_volume( ++i ) =  0.0; // nonpolar H
	fa_lk_volume( ++i ) =  0.0; // aromatic H
	fa_lk_volume( ++i ) =  0.0; // backbone HN
	if ( fa_lk_volume.u() == 25 ) return;
	fa_lk_volume( ++i ) =  0.0; // H2O
	if ( fa_lk_volume.u() == 26 ) return;
	fa_lk_volume( ++i ) = 11.5; // F    wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) = 24.4; // Cl   wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) = 35.5; // Br   wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) = 44.6; // I    wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) =  5.4; // Zn2p wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) =  2.0; // Fe2p wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) =  1.2; // Fe3p wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) =  7.0; // Mg2p wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) = 10.7; // Ca2p wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) = 10.6; // Na1p wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) = 23.0; // K1p  wild guess 4/3 pi r^3
	fa_lk_volume( ++i ) = 12.4; // Au; approximation: atomic volume - overlap volume
	fa_lk_volume( ++i ) = 14.3; // O in ice; approx: atomic volume - overlap volume
	fa_lk_volume( ++i ) =  2.0; // H in ice; approx: atomic volume - overlap volume
	fa_lk_volume( ++i ) = 34.7; // Si in quartz; approx: atomic volume - overlap volume
 	fa_lk_volume( ++i ) = 20.4; // O in quartz;  approx: atomic volume - overlap volume
	fa_lk_volume( ++i ) = 10.8; // OP in Phosphate ; CARBONYL C=O; kosta makrodimitris
	fa_lk_volume( ++i ) = 21.1; // OH in Phosphate; LAZARIDIS 1999; kosta makrodimitris 10/2005
	fa_lk_volume( ++i ) =  2.0; // HO in Phosphate ; H in ice; kosta makrodimitris
	fa_lk_volume( ++i ) = 37.9; // P/HA; CHARMM27 for DNA, MacKerell 2004;kosta makrodimitris 11/2005
	fa_lk_volume( ++i ) = 10.8; // OP/HA; CARBON(X)YL C=O; kosta makrodimitris  11/2005
	fa_lk_volume( ++i ) = 22.1; // OH/HA; LAZARIDIS 1999; kosta makrodimitris 11/2005
	fa_lk_volume( ++i ) =  2.0; // HO/HA; H in ice; kosta makrodimitris 11/2005
	fa_lk_volume( ++i ) = 18.4; // CS1; modeled after extended aromatic with 1H (CR1E), bkidd
	fa_lk_volume( ++i ) = 18.4; // CS2; modeled after extended aromatic with 1H (CR1E), bkidd
	fa_lk_volume( ++i ) = 18.4; // CS5; modeled after extended aromatic with 1H (CR1E), bkidd
	fa_lk_volume( ++i ) = 18.4; // CS6; modeled after CR1E Lazaridis, bkidd
	fa_lk_volume( ++i ) = 10.8; // O5;  modeled after O from Lazaridis, bkidd
	fa_lk_volume( ++i ) =  0.0; // V01
	fa_lk_volume( ++i ) =  0.0; // V02
	fa_lk_volume( ++i ) =  0.0; // V03
	fa_lk_volume( ++i ) =  0.0; // V04
	fa_lk_volume( ++i ) =  0.0; // V05
	fa_lk_volume( ++i ) =  0.0; // V06
	fa_lk_volume( ++i ) =  0.0; // V07
	fa_lk_volume( ++i ) =  0.0; // V08
	fa_lk_volume( ++i ) =  0.0; // V09
	fa_lk_volume( ++i ) =  0.0; // V10
	fa_lk_volume( ++i ) =  0.0; // V11
	fa_lk_volume( ++i ) =  0.0; // V12
	fa_lk_volume( ++i ) =  0.0; // V13
	fa_lk_volume( ++i ) =  0.0; // V14
	fa_lk_volume( ++i ) =  0.0; // V15
	fa_lk_volume( ++i ) =  0.0; // V16
	fa_lk_volume( ++i ) =  0.0; // V17
//******************************************************************************
//vats Volume Vi for nucleic acids. Taken from the above paper by Lazaridis et al.
// The Vi for protein were co-opted for nucleic acid atom types
//******************************************************************************
//	fa_lk_volume( ++i ) = 14.7; // CN1  carbonyl carbon
//	fa_lk_volume( ++i ) =  8.3; // CN2  aromatic carbon to amide
//	fa_lk_volume( ++i ) = 18.4; // CN3  aromatic carbon
//	fa_lk_volume( ++i ) = 18.4; // CN4  purine C8 and ADE C2
//	fa_lk_volume( ++i ) =  8.3; // CN5  purine C4 and C5
//	fa_lk_volume( ++i ) = 23.7; // CN7  carbon (C1',C2',C3',C4')
//	fa_lk_volume( ++i ) = 22.4; // CN8  carbon (C5')
//	fa_lk_volume( ++i ) = 30.0; // CN9  carbon (C5M)
//	fa_lk_volume( ++i ) =  4.4; // NN1  amide nitrogen
//	fa_lk_volume( ++i ) =  4.4; // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//	fa_lk_volume( ++i ) =  4.4; // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//	fa_lk_volume( ++i ) =  4.4; // NN4  purine N7
//	fa_lk_volume( ++i ) = 10.8; // ON1  carbonyl oxygen
//	fa_lk_volume( ++i ) = 10.8; // ON2  phosphate ester oxygen
//	fa_lk_volume( ++i ) = 10.8; // ON3  =O in phosphate
//	fa_lk_volume( ++i ) = 10.8; // ON4  phosphate hydroxyl oxygen
//	fa_lk_volume( ++i ) = 10.8; // ON5  ribose hydroxyl oxygen
//	fa_lk_volume( ++i ) = 10.8; // ON6  deoxyribose, ribose ring oxygen
//	fa_lk_volume( ++i ) =  0.0; // H    polar hydrogen
//	fa_lk_volume( ++i ) =  0.0; // H    non-polar hydrogen
}

void
fa_lk_lambda_initializer( FArray1D_float & fa_lk_lambda )
{
	if ( fa_lk_lambda.u() == 0 ) return;
	int i = 0;
	fa_lk_lambda( ++i ) =    3.5; // carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_lk_lambda( ++i ) =    3.5; // carboxyl C in Asp and Glu
	fa_lk_lambda( ++i ) =    3.5; // aliphatic C with one H (Val, Ile, Thr)
	fa_lk_lambda( ++i ) =    3.5; // aliphatic C with two H (other residues)
	fa_lk_lambda( ++i ) =    3.5; // aliphatic C with three H (Ala)
	fa_lk_lambda( ++i ) =    3.5; // aromatic ring C (His, Phe, Tyr, Trp)
	fa_lk_lambda( ++i ) =    3.5; // N in Trp side-chain
	fa_lk_lambda( ++i ) =    3.5; // N in His side-chain
	fa_lk_lambda( ++i ) =    3.5; // N in Asn and Gln side-chain
	fa_lk_lambda( ++i ) =    6.0; // N in Lys side-chain, N-terminus?
	fa_lk_lambda( ++i ) =    6.0; // N in Arg side-chain
	fa_lk_lambda( ++i ) =    3.5; // N in Pro backbone
	fa_lk_lambda( ++i ) =    3.5; // hydroxyl O in Ser, Thr and Tyr
	fa_lk_lambda( ++i ) =    3.5; // carbonyl O in Asn and Gln
	fa_lk_lambda( ++i ) =    6.0; // carboyxl O in Asp and Glu
	fa_lk_lambda( ++i ) =    3.5; // sulfur in Cys and Met
	fa_lk_lambda( ++i ) =    3.5; // backbone N'
	fa_lk_lambda( ++i ) =    3.5; // backbone CA
	fa_lk_lambda( ++i ) =    3.5; // backbone C'
	fa_lk_lambda( ++i ) =    3.5; // backbone O'
	fa_lk_lambda( ++i ) =    3.5; // nucleic acid P /6.0 Lazaridis private communication; kosta makrodimitris;
	fa_lk_lambda( ++i ) =    3.5; // polar H
	fa_lk_lambda( ++i ) =    3.5; // nonpolar H
	fa_lk_lambda( ++i ) =    3.5; // aromatic H
	fa_lk_lambda( ++i ) =    3.5; // backbone HN
	if ( fa_lk_lambda.u() == 25 ) return;
	fa_lk_lambda( ++i ) =    3.5; // H2O
	if ( fa_lk_lambda.u() == 26 ) return;
	fa_lk_lambda( ++i ) =    3.5; // F
	fa_lk_lambda( ++i ) =    3.5; // Cl
	fa_lk_lambda( ++i ) =    3.5; // Br
	fa_lk_lambda( ++i ) =    3.5; // I
	fa_lk_lambda( ++i ) =    3.5; // Zn2p
	fa_lk_lambda( ++i ) =    3.5; // Fe2p
	fa_lk_lambda( ++i ) =    3.5; // Fe3p
	fa_lk_lambda( ++i ) =    3.5; // Mg2p
	fa_lk_lambda( ++i ) =    2.0; // Ca2p // ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_lk_lambda( ++i ) =    3.5; // Na1p
	fa_lk_lambda( ++i ) =    3.5; // K1p
	fa_lk_lambda( ++i ) =    3.7; // Au; Surf sci rep 7, 211
	fa_lk_lambda( ++i ) =    3.5; // O in ice; hydroxyl O from above
	fa_lk_lambda( ++i ) =    3.5; // H in ice; polar H from above
	fa_lk_lambda( ++i ) =    2.2; // Si in Quartz; j phys chem 103, 1270
	fa_lk_lambda( ++i ) =    1.6; // O  in Quartz; j phys chem 103, 1270
	fa_lk_lambda( ++i ) =    3.5; // OP ; Lazaridis 1999 PROTEINS; kosta makrodimitris
	fa_lk_lambda( ++i ) =    3.5; // OH OC in phosphate; Lazaridis 1999 PROTEINS; kosta makrodimitris
	fa_lk_lambda( ++i ) =    3.5; // HOP in phosphate; Lazaridis 1999 PROTEINS; kosta makrodimitris
	fa_lk_lambda( ++i ) =    6.0; // nucleic acid P;Lazaridis 1999 PROTEINS; kosta makrodimitris;
	fa_lk_lambda( ++i ) =    1.7; // OP/HA ; ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_lk_lambda( ++i ) =    3.5; // OH/HA; Lazaridis 1999 PROTEINS; kosta makrodimitris
	fa_lk_lambda( ++i ) =    3.5; // HOP/HA; Lazaridis 1999 PROTEINS; kosta makrodimitris
	fa_lk_lambda( ++i ) =    3.5; // CS1 sugar atoms, bkidd
	fa_lk_lambda( ++i ) =    3.5; // CS2 sugar atoms, bkidd
	fa_lk_lambda( ++i ) =    3.5; // CS5 sugar atoms, bkidd
	fa_lk_lambda( ++i ) =    3.5; // CS6 sugar atoms, bkidd
	fa_lk_lambda( ++i ) =    3.5; // O5 sugar atoms, bkidd
	fa_lk_lambda( ++i ) = 1000.0; // V01
	fa_lk_lambda( ++i ) = 1000.0; // V02
	fa_lk_lambda( ++i ) = 1000.0; // V03
	fa_lk_lambda( ++i ) = 1000.0; // V04
	fa_lk_lambda( ++i ) = 1000.0; // V05
	fa_lk_lambda( ++i ) = 1000.0; // V06
	fa_lk_lambda( ++i ) = 1000.0; // V07
	fa_lk_lambda( ++i ) = 1000.0; // V08
	fa_lk_lambda( ++i ) = 1000.0; // V09
	fa_lk_lambda( ++i ) = 1000.0; // V10
	fa_lk_lambda( ++i ) = 1000.0; // V11
	fa_lk_lambda( ++i ) = 1000.0; // V12
	fa_lk_lambda( ++i ) = 1000.0; // V13
	fa_lk_lambda( ++i ) = 1000.0; // V14
	fa_lk_lambda( ++i ) = 1000.0; // V15
	fa_lk_lambda( ++i ) = 1000.0; // V16
	fa_lk_lambda( ++i ) = 1000.0; // V17
//******************************************************************************
//vats lambda for Nucleic acids. Refer to paper by Lazaridis et al
// Lambda for proteins used here for nucleic acids
//******************************************************************************
//	fa_lk_lambda( ++i ) =    3.5; // CN1  carbonyl carbon
//	fa_lk_lambda( ++i ) =    3.5; // CN2  aromatic carbon to amide
//	fa_lk_lambda( ++i ) =    3.5; // CN3  aromatic carbon
//	fa_lk_lambda( ++i ) =    3.5; // CN4  purine C8 and ADE C2
//	fa_lk_lambda( ++i ) =    3.5; // CN5  purine C4 and C5
//	fa_lk_lambda( ++i ) =    3.5; // CN7  carbon (C1',C2',C3',C4')
//	fa_lk_lambda( ++i ) =    3.5; // CN8  carbon (C5')
//	fa_lk_lambda( ++i ) =    3.5; // CN9  carbon (C5M)
//	fa_lk_lambda( ++i ) =    3.5; // NN1  amide nitrogen
//	fa_lk_lambda( ++i ) =    3.5; // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//	fa_lk_lambda( ++i ) =    3.5; // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//	fa_lk_lambda( ++i ) =    3.5; // NN4  purine N7
//	fa_lk_lambda( ++i ) =    3.5; // ON1  carbonyl oxygen
//	fa_lk_lambda( ++i ) =    6.0; // ON2  phosphate ester oxygen
//	fa_lk_lambda( ++i ) =    3.5; // ON3  =O in phosphate
//	fa_lk_lambda( ++i ) =    3.5; // ON4  phosphate hydroxyl oxygen
//	fa_lk_lambda( ++i ) =    3.5; // ON5  ribose hydroxyl oxygen
//	fa_lk_lambda( ++i ) =    3.5; // ON6  deoxyribose, ribose ring oxygen
//	fa_lk_lambda( ++i ) =    3.5; // H    polar hydrogen
//	fa_lk_lambda( ++i ) =    3.5; // H    non-polar hydrogen
}

void
fa_lk_dgfree_initializer( FArray1D_float & fa_lk_dgfree )
{
	if ( fa_lk_dgfree.u() == 0 ) return;
	int i = 0;
	fa_lk_dgfree( ++i ) =    0.0; // carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_lk_dgfree( ++i ) =  -1.40; // carboxyl C in Asp and Glu
	fa_lk_dgfree( ++i ) =  -0.25; // aliphatic C with one H (Val, Ile, Thr)
	fa_lk_dgfree( ++i ) =   0.52; // aliphatic C with two H (other residues)
	fa_lk_dgfree( ++i ) =   1.50; // aliphatic C with three H (Ala)
	fa_lk_dgfree( ++i ) =   0.08; // aromatic ring C (His, Phe, Tyr, Trp)
	fa_lk_dgfree( ++i ) =   -8.9; // N in Trp side-chain
	fa_lk_dgfree( ++i ) =   -4.0; // N in His side-chain
	fa_lk_dgfree( ++i ) =  -10.0; // N in Asn and Gln side-chain
	fa_lk_dgfree( ++i ) =  -20.0; // N in Lys side-chain, N-terminus?
	fa_lk_dgfree( ++i ) =  -11.0; // N in Arg side-chain   **** -7.0, 07/08/01 ... too many buried Arg
	fa_lk_dgfree( ++i ) =  -1.55; // N in Pro backbone
	fa_lk_dgfree( ++i ) =  -6.77; // hydroxyl O in Ser, Thr and Tyr, // 6.7 LAZARIDIS 1999, kosta makrodimitris
	fa_lk_dgfree( ++i ) =  -10.0; // carbonyl O in Asn and Gln  **** -5.85, 07/08/01 ... too many buried Asn,Arg
	fa_lk_dgfree( ++i ) =  -10.0; // carboyxl O in Asp and Glu
	fa_lk_dgfree( ++i ) =   -4.1; // sulfur in Cys and Met
	fa_lk_dgfree( ++i ) =   -5.0; // backbone N'
	fa_lk_dgfree( ++i ) =    1.0; // backbone CA
	fa_lk_dgfree( ++i ) =    1.0; // backbone C'
	fa_lk_dgfree( ++i ) =   -5.0; // backbone O'
	fa_lk_dgfree( ++i ) =  -24.0; // P in phosphate; Lazaridis JPCb 2005, 109, 15098; kosta makrodimitris
	fa_lk_dgfree( ++i ) =    0.0; // polar H
	fa_lk_dgfree( ++i ) =    0.0; // nonpolar H
	fa_lk_dgfree( ++i ) =    0.0; // aromatic H
	fa_lk_dgfree( ++i ) =    0.0; // backbone HN
	if ( fa_lk_dgfree.u() == 25 ) return;
	fa_lk_dgfree( ++i ) =    0.0; // H2O
	if ( fa_lk_dgfree.u() == 26 ) return;
	fa_lk_dgfree( ++i ) =   -6.0; // F    wild guess
	fa_lk_dgfree( ++i ) =   -5.0; // Cl   wild guess
	fa_lk_dgfree( ++i ) =   -4.0; // Br   wild guess
	fa_lk_dgfree( ++i ) =   -3.0; // I    wild guess
	fa_lk_dgfree( ++i ) =   -5.0; // Zn2p wild guess
	fa_lk_dgfree( ++i ) =   -5.0; // Fe2p wild guess
	fa_lk_dgfree( ++i ) =   -5.0; // Fe3p wild guess
	fa_lk_dgfree( ++i ) =   -5.0; // Mg2p wild guess
	fa_lk_dgfree( ++i ) =    0.0; // Ca2p // HOP /HA; Lazaridis 1999 PROTEINS; kosta makrodimitris
	fa_lk_dgfree( ++i ) =   -5.0; // Na1p wild guess
	fa_lk_dgfree( ++i ) =   -5.0; // K1p  wild guess
	fa_lk_dgfree( ++i ) =   -2.5; // Au;
	fa_lk_dgfree( ++i ) =  -6.70; // O in ice; hydroxyl O from above
	fa_lk_dgfree( ++i ) =    0.0; // H in ice; polar H from above
	fa_lk_dgfree( ++i ) =   -3.9; // Si in Quartz; j phys chem 103, 1270
	fa_lk_dgfree( ++i ) =   -3.9; // O  in Quartz; j phys chem 103, 1270
	fa_lk_dgfree( ++i ) =    0.0; // OP in phosphate; Lazaridis JPCb 2005, 109, 15098;kosta makrodimitris
	fa_lk_dgfree( ++i ) =    0.0; // OH in phosphate; Lazaridis JPCb 2005, 109, 15098;kosta makrodimitris
	fa_lk_dgfree( ++i ) =    0.0; // HOP in phosphate; Lazaridis 1999 PROTEINS; kosta makrodimitris
	fa_lk_dgfree( ++i ) =  -24.0; // P/HA; Lazaridis JPCb 2005, 109, 15098; kosta makrodimitris
	fa_lk_dgfree( ++i ) =    0.0; // OP/HAe; Lazaridis JPCb 2005, 109, 15098;kosta makrodimitris
	fa_lk_dgfree( ++i ) =    0.0; // OH/HA; Lazaridis JPCb 2005, 109, 15098;kosta makrodimitris
	fa_lk_dgfree( ++i ) =    0.0; // HOP /HA; Lazaridis 1999 PROTEINS; kosta makrodimitris
	fa_lk_dgfree( ++i ) =   0.08; // CS1, modeled after CR1E
	fa_lk_dgfree( ++i ) =   0.08; // CS2, modeled after CR1E
	fa_lk_dgfree( ++i ) =   0.08; // CS5, modeled after CR1E
	fa_lk_dgfree( ++i ) =   0.08; // CS6, modeled after CR1E
	fa_lk_dgfree( ++i ) =  -5.85; // O5, modeled after CR1E
	fa_lk_dgfree( ++i ) =    0.0; // V02
	fa_lk_dgfree( ++i ) =    0.0; // V02
	fa_lk_dgfree( ++i ) =    0.0; // V03
	fa_lk_dgfree( ++i ) =    0.0; // V04
	fa_lk_dgfree( ++i ) =    0.0; // V05
	fa_lk_dgfree( ++i ) =    0.0; // V06
	fa_lk_dgfree( ++i ) =    0.0; // V07
	fa_lk_dgfree( ++i ) =    0.0; // V08
	fa_lk_dgfree( ++i ) =    0.0; // V09
	fa_lk_dgfree( ++i ) =    0.0; // V10
	fa_lk_dgfree( ++i ) =    0.0; // V11
	fa_lk_dgfree( ++i ) =    0.0; // V12
	fa_lk_dgfree( ++i ) =    0.0; // V13
	fa_lk_dgfree( ++i ) =    0.0; // V14
	fa_lk_dgfree( ++i ) =    0.0; // V15
	fa_lk_dgfree( ++i ) =    0.0; // V16
	fa_lk_dgfree( ++i ) =    0.0; // V17
//******************************************************************************
//vats Nucleic acid dGfree. Used the dGfree for protein (Ref Lazaridis et al paper)
// and substituted it for similar atom type for nucleic acid
//******************************************************************************
//	fa_lk_dgfree( ++i ) =  0.000; // CN1  carbonyl carbon
//	fa_lk_dgfree( ++i ) = -0.890; // CN2  aromatic carbon to amide
//	fa_lk_dgfree( ++i ) =  0.057; // CN3  aromatic carbon
//	fa_lk_dgfree( ++i ) =  0.057; // CN4  purine C8 and ADE C2
//	fa_lk_dgfree( ++i ) = -0.890; // CN5  purine C4 and C5
//	fa_lk_dgfree( ++i ) = -0.187; // CN7  carbon (C1',C2',C3',C4')
//	fa_lk_dgfree( ++i ) =  0.372; // CN8  carbon (C5')
//	fa_lk_dgfree( ++i ) =  1.089; // CN9  carbon (C5M)
//	fa_lk_dgfree( ++i ) = -5.950; // NN1  amide nitrogen
//	fa_lk_dgfree( ++i ) = -5.950; // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//	fa_lk_dgfree( ++i ) = -3.820; // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//	fa_lk_dgfree( ++i ) = -3.820; // NN4  purine N7
//	fa_lk_dgfree( ++i ) = -5.330; // ON1  carbonyl oxygen
//	fa_lk_dgfree( ++i ) = -10.00; // ON2  phosphate ester oxygen
//	fa_lk_dgfree( ++i ) = -5.330; // ON3  =O in phosphate
//	fa_lk_dgfree( ++i ) = -5.920; // ON4  phosphate hydroxyl oxygen
//	fa_lk_dgfree( ++i ) = -5.920; // ON5  ribose hydroxyl oxygen
//	fa_lk_dgfree( ++i ) = -5.920; // ON6  deoxyribose, ribose ring oxygen
//	fa_lk_dgfree( ++i ) =  0.000; // H    polar hydrogen
//	fa_lk_dgfree( ++i ) =  0.000; // H    non-polar hydrogen
}


//------------------------------------------------------------------------------
//bk  hydrogen bond acceptors and donors
//jss these are primarily used in non-amino acid hbonds;
//jss amino acids use the aaproperties of Hpos_polar HNpos for donors; accpt_pos HApos for acceptors

void
fa_acceptor_initializer( FArray1D_bool & fa_acceptor )
{
	if ( fa_acceptor.u() == 0 ) return;
	int i = 0;
	fa_acceptor( ++i ) = false; // carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_acceptor( ++i ) = false; // carboxyl C in Asp and Glu
	fa_acceptor( ++i ) = false; // aliphatic C with one H (Val, Ile, Thr)
	fa_acceptor( ++i ) = false; // aliphatic C with two H (other residues)
	fa_acceptor( ++i ) = false; // aliphatic C with three H (Ala)
	fa_acceptor( ++i ) = false; // aromatic ring C (His, Phe, Tyr, Trp)
	fa_acceptor( ++i ) = false; // N in Trp side-chain / other protonated ring nitrogen
	fa_acceptor( ++i ) = true; // N in His side-chain / deprotonated ring nitrogen
	fa_acceptor( ++i ) = false; // N in Asn and Gln side-chain
	fa_acceptor( ++i ) = false; // N in Lys side-chain, N-terminus?
	fa_acceptor( ++i ) = false; // N in Arg side-chain
	fa_acceptor( ++i ) = false; // N in Pro backbone
	fa_acceptor( ++i ) = true; // hydroxyl O in Ser, Thr and Tyr
	fa_acceptor( ++i ) = true; // carbonyl O in Asn and Gln
	fa_acceptor( ++i ) = true; // carboyxl O in Asp and Glu
	fa_acceptor( ++i ) = false; // sulfur in Cys and Met
	fa_acceptor( ++i ) = false; // backbone N'
	fa_acceptor( ++i ) = false; // backbone CA
	fa_acceptor( ++i ) = false; // backbone C'
	fa_acceptor( ++i ) = true; // backbone O'
	fa_acceptor( ++i ) = false; // nucleic acid P
	fa_acceptor( ++i ) = false; // polar H
	fa_acceptor( ++i ) = false; // nonpolar H
	fa_acceptor( ++i ) = false; // aromatic H
	fa_acceptor( ++i ) = false; // backbone HN
	if ( fa_acceptor.u() == 25 ) return;
	fa_acceptor( ++i ) = true; // H2O : need to check elsewhere to see if hbonds to water are being used
	if ( fa_acceptor.u() == 26 ) return;
	fa_acceptor( ++i ) = false; // F
	fa_acceptor( ++i ) = false; // Cl
	fa_acceptor( ++i ) = false; // Br
	fa_acceptor( ++i ) = false; // I
	fa_acceptor( ++i ) = false; // Zn2p
	fa_acceptor( ++i ) = false; // Fe2p
	fa_acceptor( ++i ) = false; // Fe3p
	fa_acceptor( ++i ) = false; // Mg2p
	fa_acceptor( ++i ) = false; // Ca2p
	fa_acceptor( ++i ) = false; // Na1p
	fa_acceptor( ++i ) = false; // K1p
	fa_acceptor( ++i ) = true;  // Au
	fa_acceptor( ++i ) = true;  // O in ice
	fa_acceptor( ++i ) = false; // H in ice
	fa_acceptor( ++i ) = false; // Si in Quartz
	fa_acceptor( ++i ) = true;  // O in Quartz
	fa_acceptor( ++i ) = true;  // OP ; phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_acceptor( ++i ) = false; // OH ; phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_acceptor( ++i ) = false; // HOP ; phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_acceptor( ++i ) = false; // P/ha ; phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_acceptor( ++i ) = true;  // OP/ha ; phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_acceptor( ++i ) = true;  // OH/ha; phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris //KMa
	fa_acceptor( ++i ) = false; // HO/ha ; phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_acceptor( ++i ) = false; // CS1
	fa_acceptor( ++i ) = false; // CS2
	fa_acceptor( ++i ) = false; // CS5
	fa_acceptor( ++i ) = false; // CS6
	fa_acceptor( ++i ) = true;  // O5
	fa_acceptor( ++i ) = false; // V01
	fa_acceptor( ++i ) = false; // V02
	fa_acceptor( ++i ) = false; // V03
	fa_acceptor( ++i ) = false; // V04
	fa_acceptor( ++i ) = false; // V05
	fa_acceptor( ++i ) = false; // V06
	fa_acceptor( ++i ) = false; // V07
	fa_acceptor( ++i ) = false; // V08
	fa_acceptor( ++i ) = false; // V09
	fa_acceptor( ++i ) = false; // V10
	fa_acceptor( ++i ) = false; // V11
	fa_acceptor( ++i ) = false; // V12
	fa_acceptor( ++i ) = false; // V13
	fa_acceptor( ++i ) = false; // V14
	fa_acceptor( ++i ) = false; // V15
	fa_acceptor( ++i ) = false; // V16
	fa_acceptor( ++i ) = false; // V17
//******************************************************************************
//vats Acceptor atom list for Nucleic Acids
//******************************************************************************
//	fa_acceptor( ++i ) = false; // 1  CN1
//	fa_acceptor( ++i ) = false; // 2  CN2
//	fa_acceptor( ++i ) = false; // 3  CN3
//	fa_acceptor( ++i ) = false; // 4  CN4
//	fa_acceptor( ++i ) = false; // 5  CN5
//	fa_acceptor( ++i ) = false; // 6  CN7
//	fa_acceptor( ++i ) = false; // 7  CN8
//	fa_acceptor( ++i ) = false; // 8  CN9
//	fa_acceptor( ++i ) = false; // 9  NN1
//	fa_acceptor( ++i ) = false; // 10 NN2
//	fa_acceptor( ++i ) =  true; // 11 NN3, sp2
//	fa_acceptor( ++i ) =  true; // 12 NN4, sp2
//	fa_acceptor( ++i ) =  true; // 13 ON1, sp2
//	fa_acceptor( ++i ) =  true; // 14 ON2, sp3
//	fa_acceptor( ++i ) =  true; // 15 ON3, sp2/sp3
//	fa_acceptor( ++i ) =  true; // 16 ON4, sp2/sp3
//	fa_acceptor( ++i ) =  true; // 17 ON5, sp3
//	fa_acceptor( ++i ) =  true; // 18 ON6, sp3
//	fa_acceptor( ++i ) = false; // 20 H (polar)
//	fa_acceptor( ++i ) = false; // 21 H (non-polar)
}

void
fa_donor_initializer( FArray1D_bool & fa_donor )
{
	if ( fa_donor.u() == 0 ) return;
	int i = 0;
	fa_donor( ++i ) = false; // carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_donor( ++i ) = false; // carboxyl C in Asp and Glu
	fa_donor( ++i ) = false; // aliphatic C with one H (Val, Ile, Thr)
	fa_donor( ++i ) = false; // aliphatic C with two H (other residues)
	fa_donor( ++i ) = false; // aliphatic C with three H (Ala)
	fa_donor( ++i ) = false; // aromatic ring C (His, Phe, Tyr, Trp)
	fa_donor( ++i ) =  true; // N in Trp side-chain // protonated ring N
	fa_donor( ++i ) = false; // N in His side-chain // deprotonated ring N
	fa_donor( ++i ) =  true; // N in Asn and Gln side-chain
	fa_donor( ++i ) =  true; // N in Lys side-chain, N-terminus?
	fa_donor( ++i ) =  true; // N in Arg side-chain
	fa_donor( ++i ) =  true; // N in Pro backbone
	fa_donor( ++i ) =  true; // hydroxyl O in Ser, Thr and Tyr
	fa_donor( ++i ) = false; // carbonyl O in Asn and Gln
	fa_donor( ++i ) = false; // carboyxl O in Asp and Glu
	fa_donor( ++i ) = false; // sulfur in Cys and Met
	fa_donor( ++i ) =  true; // backbone N'
	fa_donor( ++i ) = false; // backbone CA
	fa_donor( ++i ) = false; // backbone C'
	fa_donor( ++i ) = false; // backbone O'
	fa_donor( ++i ) = false; // nucleic acid P
	fa_donor( ++i ) = false; // polar H
	fa_donor( ++i ) = false; // nonpolar H
	fa_donor( ++i ) = false; // aromatic H
	fa_donor( ++i ) = false; // backbone HN
	if ( fa_donor.u() == 25 ) return;
	fa_donor( ++i ) =  true; // H2O
	if ( fa_donor.u() == 26 ) return;
	fa_donor( ++i ) = false; // F
	fa_donor( ++i ) = false; // Cl
	fa_donor( ++i ) = false; // Br
	fa_donor( ++i ) = false; // I
	fa_donor( ++i ) = false; // Zn2p
	fa_donor( ++i ) = false; // Fe2p
	fa_donor( ++i ) = false; // Fe3p
	fa_donor( ++i ) = false; // Mg2p
	fa_donor( ++i ) = false; // Ca2p
	fa_donor( ++i ) = false; // Na1p
	fa_donor( ++i ) = false; // K1p
	fa_donor( ++i ) = false; // Au
	fa_donor( ++i ) = true;  // O in ice
	fa_donor( ++i ) = false; // H in ice
	fa_donor( ++i ) = false; // Si in Quartz
	fa_donor( ++i ) = false; // O in Quartz
	fa_donor( ++i ) = false; // OP phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_donor( ++i ) = false; // OH phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_donor( ++i ) = false; // HOP phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_donor( ++i ) = false; // P/ha phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_donor( ++i ) = false; // OP/ha phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_donor( ++i ) = true ; // OH/ha phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris //KMa
	fa_donor( ++i ) = false; // HOP/ha phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_donor( ++i ) = false; // CS1
	fa_donor( ++i ) = false; // CS2
	fa_donor( ++i ) = false; // CS5
	fa_donor( ++i ) = false; // CS6
	fa_donor( ++i ) = true;  // O5
	fa_donor( ++i ) = false; // V01
	fa_donor( ++i ) = false; // V02
	fa_donor( ++i ) = false; // V03
	fa_donor( ++i ) = false; // V04
	fa_donor( ++i ) = false; // V05
	fa_donor( ++i ) = false; // V06
	fa_donor( ++i ) = false; // V07
	fa_donor( ++i ) = false; // V08
	fa_donor( ++i ) = false; // V09
	fa_donor( ++i ) = false; // V10
	fa_donor( ++i ) = false; // V11
	fa_donor( ++i ) = false; // V12
	fa_donor( ++i ) = false; // V13
	fa_donor( ++i ) = false; // V14
	fa_donor( ++i ) = false; // V15
	fa_donor( ++i ) = false; // V16
	fa_donor( ++i ) = false; // V17
//******************************************************************************
//vats Donor atom list for Nucleic Acids
//******************************************************************************
//	fa_donor( ++i ) = false; // 1  CN1
//	fa_donor( ++i ) = false; // 2  CN2
//	fa_donor( ++i ) = false; // 3  CN3
//	fa_donor( ++i ) = false; // 4  CN4
//	fa_donor( ++i ) = false; // 5  CN5
//	fa_donor( ++i ) = false; // 6  CN7
//	fa_donor( ++i ) = false; // 7  CN8
//	fa_donor( ++i ) = false; // 8  CN9
//	fa_donor( ++i ) =  true; // 9  NN1
//	fa_donor( ++i ) =  true; // 10 NN2
//	fa_donor( ++i ) = false; // 11 NN3, sp2
//	fa_donor( ++i ) = false; // 12 NN4, sp2
//	fa_donor( ++i ) = false; // 13 ON1, sp2
//	fa_donor( ++i ) = false; // 14 ON2, sp3
//	fa_donor( ++i ) = false; // 15 ON3, sp2/sp3
//	fa_donor( ++i ) =  true; // 16 ON4, sp2/sp3
//	fa_donor( ++i ) =  true; // 17 ON5, sp3
//	fa_donor( ++i ) = false; // 18 ON6, sp3
//	fa_donor( ++i ) = false; // 20 H (polar)
//	fa_donor( ++i ) = false; // 21 H (non-polar)
}

void
fa_hbondH_initializer( FArray1D_bool & fa_hbondH )
{
	if ( fa_hbondH.u() == 0 ) return;
	int i = 0;
	fa_hbondH( ++i ) = false; // carbonyl C in Asn and Gln and guanidyl C in Arg
	fa_hbondH( ++i ) = false; // carboxyl C in Asp and Glu
	fa_hbondH( ++i ) = false; // aliphatic C with one H (Val, Ile, Thr)
	fa_hbondH( ++i ) = false; // aliphatic C with two H (other residues)
	fa_hbondH( ++i ) = false; // aliphatic C with three H (Ala)
	fa_hbondH( ++i ) = false; // aromatic ring C (His, Phe, Tyr, Trp)
	fa_hbondH( ++i ) = false; // N in Trp side-chain
	fa_hbondH( ++i ) = false; // N in His side-chain
	fa_hbondH( ++i ) = false; // N in Asn and Gln side-chain
	fa_hbondH( ++i ) = false; // N in Lys side-chain, N-terminus?
	fa_hbondH( ++i ) = false; // N in Arg side-chain
	fa_hbondH( ++i ) = false; // N in Pro backbone
	fa_hbondH( ++i ) = false; // hydroxyl O in Ser, Thr and Tyr
	fa_hbondH( ++i ) = false; // carbonyl O in Asn and Gln
	fa_hbondH( ++i ) = false; // carboyxl O in Asp and Glu
	fa_hbondH( ++i ) = false; // sulfur in Cys and Met
	fa_hbondH( ++i ) = false; // backbone N'
	fa_hbondH( ++i ) = false; // backbone CA
	fa_hbondH( ++i ) = false; // backbone C'
	fa_hbondH( ++i ) = false; // backbone O'
	fa_hbondH( ++i ) = false; // nucleic acid P
	fa_hbondH( ++i ) = true; // polar H
	fa_hbondH( ++i ) = false; // nonpolar H
	fa_hbondH( ++i ) = false; // aromatic H
	fa_hbondH( ++i ) = true; // backbone HN
	if ( fa_hbondH.u() == 25 ) return;
	fa_hbondH( ++i ) = false; // H2O, use separate functions to evaluate hbonding with
	if ( fa_hbondH.u() == 26 ) return;
	fa_hbondH( ++i ) = false; // F
	fa_hbondH( ++i ) = false; // Cl
	fa_hbondH( ++i ) = false; // Br
	fa_hbondH( ++i ) = false; // I
	fa_hbondH( ++i ) = false; // Zn2p
	fa_hbondH( ++i ) = false; // Fe2p
	fa_hbondH( ++i ) = false; // Fe3p
	fa_hbondH( ++i ) = false; // Mg2p
	fa_hbondH( ++i ) = false; // Ca2p
	fa_hbondH( ++i ) = false; // Na1p
	fa_hbondH( ++i ) = false; // K1p
	fa_hbondH( ++i ) = false; // Au
	fa_hbondH( ++i ) = false; // O in ice
	fa_hbondH( ++i ) = true;  // H in ice
	fa_hbondH( ++i ) = false; // Si in Quartz
	fa_hbondH( ++i ) = false; // O in Quartz
	fa_hbondH( ++i ) = false; // OP in phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_hbondH( ++i ) = false; // OH in phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_hbondH( ++i ) = true;  // HOP in phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_hbondH( ++i ) = false; // P/ha in phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_hbondH( ++i ) = false; // OP/ha in phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_hbondH( ++i ) = false; // OH/ha in phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_hbondH( ++i ) = true;  // HOP/ha in phosphate/bones ZAHN Phys.Chem.Chem.Phys.,2003,5,4004; kosta makrodimitris
	fa_hbondH( ++i ) = false; // CS1
	fa_hbondH( ++i ) = false; // CS2
	fa_hbondH( ++i ) = false; // CS5
	fa_hbondH( ++i ) = false; // CS6
	fa_hbondH( ++i ) = false; // O5
	fa_hbondH( ++i ) = false; // V01
	fa_hbondH( ++i ) = false; // V02
	fa_hbondH( ++i ) = false; // V03
	fa_hbondH( ++i ) = false; // V04
	fa_hbondH( ++i ) = false; // V05
	fa_hbondH( ++i ) = false; // V06
	fa_hbondH( ++i ) = false; // V07
	fa_hbondH( ++i ) = false; // V08
	fa_hbondH( ++i ) = false; // V09
	fa_hbondH( ++i ) = false; // V10
	fa_hbondH( ++i ) = false; // V11
	fa_hbondH( ++i ) = false; // V12
	fa_hbondH( ++i ) = false; // V13
	fa_hbondH( ++i ) = false; // V14
	fa_hbondH( ++i ) = false; // V15
	fa_hbondH( ++i ) = false; // V16
	fa_hbondH( ++i ) = false; // V17
//******************************************************************************
//vats Hydrogens of Nucleic acids that can form hydrogen bonds
//******************************************************************************
//	fa_hbondH( ++i ) = false; // 1  CN1
//	fa_hbondH( ++i ) = false; // 2  CN2
//	fa_hbondH( ++i ) = false; // 3  CN3
//	fa_hbondH( ++i ) = false; // 4  CN4
//	fa_hbondH( ++i ) = false; // 5  CN5
//	fa_hbondH( ++i ) = false; // 6  CN7
//	fa_hbondH( ++i ) = false; // 7  CN8
//	fa_hbondH( ++i ) = false; // 8  CN9
//	fa_hbondH( ++i ) = false; // 9  NN1
//	fa_hbondH( ++i ) = false; // 10 NN2
//	fa_hbondH( ++i ) = false; // 11 NN3, sp2
//	fa_hbondH( ++i ) = false; // 12 NN4, sp2
//	fa_hbondH( ++i ) = false; // 13 ON1, sp2
//	fa_hbondH( ++i ) = false; // 14 ON2, sp3
//	fa_hbondH( ++i ) = false; // 15 ON3, sp2/sp3
//	fa_hbondH( ++i ) = false; // 16 ON4, sp2/sp3
//	fa_hbondH( ++i ) = false; // 17 ON5, sp3
//	fa_hbondH( ++i ) = false; // 18 ON6, sp3
//	fa_hbondH( ++i ) = false; // 20 H (polar)
//	fa_hbondH( ++i ) = false; // 21 H (non-polar)
}


//
//  lj, lk, hbond tables
//
FArray1D_float fa_lj_radius( MAX_ATOMTYPES(), fa_lj_radius_initializer ); // lj vdw radii
	//FArray1D_float fa_lj_radius( MAX_ATOMTYPES(), 1 == true ? fa_lj_radius_initializer : fa_lj_soft_initializer ); // lj vdw radii
FArray1D_float const fa_lj_wdepth( MAX_ATOMTYPES(), fa_lj_wdepth_initializer ); // lj vdw well depths
FArray1D_float const fa_lk_volume( MAX_ATOMTYPES(), fa_lk_volume_initializer ); // lk solvation volume
FArray1D_float const fa_lk_lambda( MAX_ATOMTYPES(), fa_lk_lambda_initializer ); // lk solvation lda
FArray1D_float fa_lk_dgfree( MAX_ATOMTYPES(), fa_lk_dgfree_initializer ); // lk solvation change in free energy
FArray1D_bool const fa_acceptor( MAX_ATOMTYPES(), fa_acceptor_initializer ); // hbond acceptors
FArray1D_bool const fa_donor( MAX_ATOMTYPES(), fa_donor_initializer ); // hbond donors
FArray1D_bool const fa_hbondH( MAX_ATOMTYPES(), fa_hbondH_initializer ); // hydrogens that hbond


} // namespace etable
