// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_etable_class
#define INCLUDED_etable_class

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/Dimension.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray5D.hh>

// C++ Headers
//#include <iosfwd>
//#include <list>
//#include <string>


// jk Class definition for Etable
class Etable {

private:

	bool done_setup_;

	void smooth_etables();

	void modify_pot();

	void select_lj_switchpoint( std::string const & setting );

public:

	FArray3D_float ljatr;
	FArray3D_float ljrep;
	FArray3D_float solv1;
	FArray3D_float solv2;
	FArray3D_float dljatr;
	FArray3D_float dljrep;
	FArray3D_float dsolv;

  FArray3D_float elec_atr;
  FArray3D_float d_elec_atr;
  FArray3D_float elec_rep;
  FArray3D_float d_elec_rep;

	inline Etable() { done_setup_ = false; };

	inline bool done_setup() { return done_setup_; };

	void setup_Etable( bool const standard_weights, float const lj_rep, float const Wrad = 1. );

	void read_Etable();

	void write_Etable();

	void fa_make_pairenergy_table();

};



void fa_precalc_etable_coefficients(
	FArray2DB_double & fa_lj_sigma,
	FArray2DB_double & fa_lj_r6_coeff,
	FArray2DB_double & fa_lj_r12_coeff,
	FArray2DB_double & fa_lj_switch_intercept,
	FArray2DB_double & fa_lj_switch_slope,
	FArray1DB_double & fa_lk_inv_lambda2,
	FArray2DB_double & fa_lk_coeff,
	FArray2DB_double & fa_lk_min_dis2sigma_value
);

void fa_calc_etable_value(
	double & dis2,
	int & atype1,
	int & atype2,
	float & atrE,
	float & d_atrE,
	float & repE,
	float & d_repE,
	float & solvE1,
	float & solvE2,
	float & dsolvE,
	FArray2DB_double & fa_lj_sigma,
	FArray2DB_double & fa_lj_r6_coeff,
	FArray2DB_double & fa_lj_r12_coeff,
	FArray2DB_double & fa_lj_switch_intercept,
	FArray2DB_double & fa_lj_switch_slope,
	FArray1DB_double & fa_lk_inv_lambda2,
	FArray2DB_double & fa_lk_coeff,
	FArray2DB_double & fa_lk_min_dis2sigma_value
);

void output_etable(
	FArray3D_float & etable,
	std::string label,
	std::ostream & out
);

void input_etable(
	FArray3D_float & etable,
	std::string label,
	std::istream & in
);


#endif

