// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19866 $
//  $Date: 2008-01-23 14:54:04 -0500 (Wed, 23 Jan 2008) $
//  $Author: possu $

#ifndef INCLUDED_fast_pairenergy
#define INCLUDED_fast_pairenergy


// Rosetta Headers
#include "geometric_solvation_ns.h"
#include "pdbstatistics_pack.h"
#include "score.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray3D.hh>



////////////////////////////////////////////////////////////////////////////////
//\BEGIN fast_pairenergy
//
//\BRIEF
//
//\FULL
//
//\PARAM - atom1 - in/out -
//\PARAM - atom2 - in/out -
//\PARAM - attype1 - in/out -
//\PARAM - attype2 - in/out -
//\PARAM - solvE - in/out -
//\PARAM - atrE - in/out -
//\PARAM - repE - in/out -
//\PARAM - d2 - in/out -
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
void
fast_pairenergy(
	FArray1Da_float atom1,
	FArray1Da_float atom2,
	int const attype1,
	int const attype2,
	float & solvE,
	float & atrE,
	float & repE,
	float & d2,
	float const cp_weight
)
{
	using namespace pdbstatistics_pack;

//bk     uses lookup table to find the pairwise energies between two atoms,
//bk     currently calculate lennard jones and solvation energy

//ctsa    -- this version of pairenergy is used for all calls made from
//ctsa    functions in pack.cc (fullatom_energy.cc still calls normal pairenergy)
//ctsa    -- modified so that energies are summed within this function instead
//ctsa     of stored and passed back out to be summed in the calling loop,

//------------------------------------------------------------------------------

//Objexx: Linear indexing used to eliminate dimension() calls
	float const a_1 = atom1[ 0 ] - atom2[ 0 ]; // atom1(1) - atom2(1)
	float const a_2 = atom1[ 1 ] - atom2[ 1 ]; // atom1(2) - atom2(2)
	float const a_3 = atom1[ 2 ] - atom2[ 2 ]; // atom1(3) - atom2(3)
	d2 = ( ( a_1 * a_1 ) + ( a_2 * a_2 ) + ( a_3 * a_3 ) );

	if ( d2 >= safe_max_dis2 || d2 == 0.0 ) return;

//ctsa
//ctsa  get bins and interpolation fraction
//ctsa
	float const d2_bin = fa_bins_per_A2 * d2;
	int const disbin1 = static_cast< int >( d2_bin ) + 1;
//	int const disbin2 = disbin1 + 1;
	float const frac = d2_bin - ( disbin1 - 1 );

//ctsa
//ctsa   tables have been hacked so that if disbin2 = lastbin, all values = 0.
//ctsa

//Objexx: Assumes arrays having the same dimensions
	int const l1 = pCurrentEtable->ljatr.index(disbin1,attype2,attype1), l2 = l1 + 1;
	float const attract1 = pCurrentEtable->ljatr[ l1 ]; // ljatr(disbin1,attype2,attype1);
	float const attract2 = pCurrentEtable->ljatr[ l2 ]; // ljatr(disbin2,attype2,attype1);

	float const repulse1 = pCurrentEtable->ljrep[ l1 ]; // ljrep(disbin1,attype2,attype1);
	float const repulse2 = pCurrentEtable->ljrep[ l2 ]; // ljrep(disbin2,attype2,attype1);

	atrE  += ( attract1 + frac * ( attract2 - attract1 ) ) * cp_weight;
	repE  += ( repulse1 + frac * ( repulse2 - repulse1 ) ) * cp_weight;

	if ( geometric_sol::geometric_sol_flag ) {
		// jk solvation energy is computed elsewhere
		return;
	}

	float const senergy11 = pCurrentEtable->solv1[ l1 ]; // solv1(disbin1,attype2,attype1);
	float const senergy12 = pCurrentEtable->solv1[ l2 ]; // solv1(disbin2,attype2,attype1);

	float const senergy21 = pCurrentEtable->solv2[ l1 ]; // solv2(disbin1,attype2,attype1);
	float const senergy22 = pCurrentEtable->solv2[ l2 ]; // solv2(disbin2,attype2,attype1);

	float const sol1 = senergy11 + senergy21;
	float const sol2 = senergy12 + senergy22;

	solvE += ( sol1 + frac * ( sol2 - sol1 ) ) * cp_weight;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin fast_pairenergy_hydrogens
///
/// @brief
///
/// @detailed
///bk    uses lookup table to find the pairwise energies between two atoms,
///bk    this function should only be used in the case that one of the partners
///bk    is a hydrogen.
///bk    currently only the repulsive term is being evaluated with hydrogens
///
///ctsa   -- this version of pairenergy is used for all calls made from
///ctsa   functions in pack.cc (fullatom_energy.cc still calls normal pairenergy)
///ctsa   -- modified so that energies are summed within this function instead
///ctsa    of stored and passed back out to be summed in the calling loop,
///
/// @param  atom1 - [in] -
/// @param  atom2 - [in] -
/// @param  attype1 - [in] -
/// @param  attype2 - [in] -
/// @param  repE - [out] - unweighted lj repulsive term
/// @param  cp_weight - [in] - weight determined by count_pair
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////

inline
void
fast_pairenergy_hydrogens(
	FArray1Da_float atom1,
	FArray1Da_float atom2,
	int attype1,
	int attype2,
  float chrg1,
  float chrg2,
	float & repE,
  float & elecE,
	float const cp_weight
)
{
	using namespace pdbstatistics_pack;

	//++count_fpeh_calls;

	float const a_1 = atom1[ 0 ] - atom2[ 0 ]; // atom1(1) - atom2(1)
	float const a_2 = atom1[ 1 ] - atom2[ 1 ]; // atom1(2) - atom2(2)
	float const a_3 = atom1[ 2 ] - atom2[ 2 ]; // atom1(3) - atom2(3)
	float const d2 = ( ( a_1 * a_1 ) + ( a_2 * a_2 ) + ( a_3 * a_3 ) );

  if ( d2 >= safe_max_dis2 || d2 == 0.0 ) return;

//ctsa
//ctsa  get bins and interpolation fraction
//ctsa
	float const d2_bin = fa_bins_per_A2 * d2;
	int const disbin1 = static_cast< int >( d2_bin ) + 1;
//  int const disbin2 = disbin1 + 1;
	float const frac = d2_bin - ( disbin1 - 1 );
  float e1;
  int l1, l2;

  if ( get_simple_elec() ) { // SJF
    float pair_elecE; // This pair of atoms' electrostatic contribution
    l1 = pCurrentEtable->elec_rep.index(disbin1,1,1);
    l2 = l1 + 1;
    pair_elecE = chrg1 * chrg2;

    if ( pair_elecE > 0 ) { // repulsion
      e1 = pCurrentEtable->elec_rep[ l1 ];
      pair_elecE *= e1 + frac * ( pCurrentEtable->elec_rep[ l2 ] - e1);
    }
    else { // attraction
      e1 = pCurrentEtable->elec_atr[ l1 ];
      pair_elecE *= e1 + frac * ( pCurrentEtable->elec_atr[ l2 ] - e1);
    }
    elecE += pair_elecE * cp_weight;
  }
  else { elecE = 0.0; }

//ctsa
//ctsa   tables have been hacked so that if disbin2 = lastbin, all values = 0.
//ctsa
	int l = pCurrentEtable->ljrep.index(disbin1,attype2,attype1);
	float const repulse1 = pCurrentEtable->ljrep[  l ]; // ljrep(disbin1,attype2,attype1);
	float const repulse2 = pCurrentEtable->ljrep[ ++l ]; // ljrep(disbin2,attype2,attype1);
	repE += ( repulse1 + frac * ( repulse2 - repulse1 ) ) * cp_weight;
}

#endif
