// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 20536 $
//  $Date: 2008-02-22 00:29:21 -0500 (Fri, 22 Feb 2008) $
//  $Author: sarel $

#ifndef INCLUDED_files_paths
#define INCLUDED_files_paths


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/Dimension.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>
#include <string>
#include <vector>


// ____________________________________________________
//
// Contains Paths and FileNames Used in program
// ___________________________________________________


namespace files_paths {


extern int const TAG_MAX_LENGTH; // tags for scorefiles, etc
extern int const NUMBER_MAX_LENGTH; // length of field for structure numbers
extern int const NAME_LENGTH; // length of field for protein_name


extern std::string protein_name;
extern char protein_chain;
extern std::string code;
extern std::string movie_path;
extern std::string movie_file;
extern std::string pdb_out_path;
extern std::string score_path;
extern std::string score_file;
extern std::string status_path;
extern std::string status_file;
extern std::string user_path;
extern std::string pdb_path_1;
extern std::string pdb_path_2;
extern std::string fragments_path_1;
inline Dimension & n_frag_files() { static Dimension d; return d; }
extern FArray1D_string frag_file_name;
extern FArray1D_int frag_sizes;
extern std::string constraints_path;
extern std::string cst_ext; // extension for constraints file
extern std::string dpl_ext; // extension for dipolar file
extern std::string ss_path;
extern std::string seq_path;
extern std::string start_path;
extern std::string start_file;
extern std::string output_file;
extern std::string silent_input_file;
extern std::string ligand_input_mdlfile;
extern std::string data_path;
extern std::string data_path_2;
extern std::string disulf_connectivity_file;
extern std::string disulf_logfile;
extern std::string exrot_file;
extern std::string Eout;
extern std::string sqc;
extern std::string resfile;
extern std::string equiv_resfile;
extern std::string pdbout;
extern std::string alter_spec_mutfile;
extern std::string point_mut_energies;
extern std::string mut_mut_energies;
extern std::string ms_comp_list;
extern std::string ms_out_name;
extern std::string libraryname;
extern bool preserve_header;
extern std::vector<std::string> header_info;
extern std::string mode_title;
extern std::string protein_name_prefix;
extern std::string frags_name_prefix;
extern bool homolog_to_query_mapping;

//-----------------------
// file streams
//-----------------------
extern utility::io::izstream pdb_x;
extern utility::io::izstream start_x;
extern utility::io::izstream data_x;
extern utility::io::ozstream status_x;
extern utility::io::ozstream fa_status_x;
extern std::ofstream user_x;
extern std::ofstream opte_x; // used for calibrating design module
extern std::ofstream sqc_x; // design module, sequence comparisons
extern std::ofstream disulf_log_x; // used for outputting disulf parameters

extern bool concat_outpdbs;
extern std::string cat_outpdb_filename;
extern std::string cat_list_filename; // filename containing the list of opened pdbs

extern bool single_silent_writer;

//-------
// command line flags
//-------
//car  precedence/dependence

//car  require_start:  if not true, following options are not relevant
//car  use_fasta

//car  require_3args:  requires the query to be defined by code,protein and
//car                  chain; query must be defined for the following to be true:
//car    require_frags, use_constraints, use_fasta


namespace query_defined_common {
	extern bool query_defined; // is the code,name,chain defined?
}
using namespace query_defined_common;


namespace io_options_bool {
	extern bool require_3args; // require code name chain on command line
		// required for constraints, native struct, frags
	extern bool require_frags; // read frag files
	extern bool require_start; // require at least one starting conformation
	extern bool use_fasta; // obtain sequence from fasta or dat
		// (otherwise from starting structure)
	extern bool use_constraints; // look for constraint files
	extern bool output_all; // write out all structures (even if rg cut exceeded)
	extern bool accept_all; // accept all structures, even if they fail filters... useful for BOINC
	extern bool use_status;
	extern bool use_decoy_status; // write output when calling show_decoy_status()
	extern bool use_scorefile;
	extern bool input_fa; // fullatom input
	extern bool no_optH; // skip hydrogen optimization on input structure
	extern bool include_inputchi; // include input rotamers when packing
	extern bool output_coord; // write out a coordinate file
	extern bool output_fa; // fullatom output
	extern bool output_centroids; // put centroid dummy atoms in output pdb.
	extern bool refold_input; // refold starting structures before using
	extern bool require_ss; // require ss for starting structure
	extern bool idealized_structure; // sets default for refolding
		// if true, residues assumed to be refoldable from angles
		// if true, residues cannot be refolded from angles //???
		// false if using nonideal backbone e.g. when redesigning native backbone
	extern bool repack_input; // repack input pdb structures?
	extern bool allow_missing; // use pdb file even if missing bb atoms
	extern bool randomize_missing;// randomize missing bb coordinates
	extern bool skip_missing; // skip residues with missing atoms in pdb file
	extern bool read_all_chains;
	extern bool chain_last_char; // if true the last character in the
		// start file name is the chain id
	extern bool multi_chain; // protein has multiple chains
	extern bool prevent_multi_chain; // jk override multi_chain if it would be on by default
	extern bool use_pdb_numbering; // use atom/chain/res from starting pdbfile
	extern bool silent_input; // input from silent mode file (default F)
	extern bool by_index; // silent mode by_index (default by_name)
	extern bool overwrite_pdbs; // allow pdb files to be overwritten
	extern bool touch_before_reading; // jk create empty output file
	extern bool touch_before_starting; // create empty files before running desired simulation
	  // before reading input pdb, if only one output structure is desired
	extern bool disable_filters; // disables all filters (default=T)
	extern bool disable_output_decoy_filters; // disable filters in output_decoy
		// some may be re-enabled by command line
	extern bool use_timer; // write time per decoy to scorefile
	extern bool count_attempts; // write time per decoy to scorefile
	extern bool scorefile_output_full_filename; // don't allow filenames to be truncated
	extern bool make_ise_movie; // dump pdbs for reading ise_movie.py
	extern bool IUPAC; // use IUPAC proton numbering when reading/writing pdb/data files
	extern bool pose_looping; // pose_looping mode
	extern bool domain_insertion; // domain_insertion mode
	extern bool antibody_modeler; // antibody modeling mode
	extern bool create_domins_fasta; // creates a specialized fasta file for fragments of protein insertion
	extern bool window; // checks for window option, window option determines whether or not to use windows when creating a loop
	extern bool map_start_sequence; // allow re-mapping from start to fasta sequence
	extern bool output_chi_silent; // show chi angles in silent file
	extern bool new_silent_reader; // use new silent-file reader
	extern bool skip_scorefile_check; // check scorefile before output
   // gzipped output
	extern bool output_pdb_gz; // output gzipped decoy pdbs
	extern bool output_silent_gz; // output gzipped silent files
	extern bool output_scorefile_gz; // output gzipped score files
	extern bool pose_silent_out; // output structure has non-ideal geometry
	extern bool sasapack_bvalues; // bvalues reflect sasapack and unsatisfied hbond
	extern bool output_cen_vals; // add columns with cen6 and cen10 vals to "complete" lines
	extern bool use_conformer; // use conformer library
	extern bool use_bbind_conformer; // use backbone independent conformer library
	extern bool flip_symmetric_sidechains; // to agree w/ rosetta chi's
	extern bool use_homolog_env_stats; // to use homolog env statistics
	extern bool use_homolog_pair_stats; // to use homolog pair statistics
	extern bool use_homolog_cendist_stats; // to use homolog james statistics
	extern bool use_homolog_env_stats_in_farlx; // to use homolog env statistics
	extern bool use_homolog_pair_stats_in_farlx; // to use homolog pair statistics
	extern bool use_homolog_cendist_stats_in_farlx; // to use homolog james statistics
	extern bool output_hbond_info; // force output of hbond info when outputting pdb stats
	extern bool output_interface_hbonds_only; // only print interface hbond info
	extern bool remark_output; // Remark output of energies, so result can be redesign in rosetta and other software
	extern bool skip_dun; // skip bbdep, dunbrack, etc... good if you have no proteins.
}
using namespace io_options_bool;


namespace io_options_int {
	extern int default_nstruct; // default number of structures
	extern int max_frags; // max fragments from frag file
}
using namespace io_options_int;


extern int const MAX_FILTERS;

extern int const rg_type;
extern int const co_type;
extern int const sheet_type;
extern int const rms_type;
extern int const disulfide_type;
extern int const dock_type;
extern int const knot_type;


namespace io_options_filters {
	extern FArray1D_bool use_filter;
}
using namespace io_options_filters;


} // namespace files_paths


#endif
