// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 01:39:36 -0500 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_filters
#define INCLUDED_filters


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>


// contact_order Function Declarations


void
contact_order(
	float & co,
	FArray1D_int const & res,
	int const & total_residue
);


void
contact_order_cutoff(
	int & ss_type,
	int & total_residue,
	float & co_cutoff
);


void
read_jones_1state(
	utility::io::izstream & iunit,
	int & total_residue,
	FArray1Da_char seq, // sequence in 1 letter code
	FArray1Da_char ss_jon,
	bool & fail
);


void
read_jones_3state(
	utility::io::izstream & iunit,
	int & total_residue,
	FArray1Da_char seq, // sequence in 1 letter code
	FArray1Da_char ss_jon,
	bool & error
);


void
setup_filters();


void
disable_all_filters();


std::string
get_protein_sstype();

void
setup_protein_sstype( bool seq_undefined );

void
setup_protein_sstype_from_input();

bool
co_filter( float & co );


bool
rg_filter( float & rg );


bool
rms_filter( float & rms );


void
rg_filter_disable();

void
get_score_contact_options();

void
read_contact_prediction(
	int const & total_residue
);

float
score_contact_prediction(
	FArray3Dp_float const & Eposition,
	int const & total_residue
);

void
sheet_filter_disable();

#endif
