// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12546 $
//  $Date: 2007-02-07 17:55:50 -0500 (Wed, 07 Feb 2007) $
//  $Author: aroop $

#ifndef INCLUDED_fold_loops
#define INCLUDED_fold_loops


// fold_loops Function Declarations


void
fold_loops();


void
fold_extended_loop(
	bool trim,
	int loop_num // non-valid loop number means all extended regions
);


void
build_loop(
	int cutoff3,
	int cutoff9,
	bool fast,
	int loop_num // loop number to operate on
);


void
optimize_loop(
	int cutoff3,
	float splicerms_cutoff,
	bool fast,
	int loop_num
);


void
close_loop(
	float splicerms_cutoff,
	bool fast,
	int loop_num
);


void
grow_tail();


void
permute_loops();


void
permute_loops_get_cycles( int & cycles );


void
permute_minimize_loops();


void
screen_loops();


void
refine_loops(
	bool fast,
	bool fix_natsc
);


void
idealize_chainbreaks();


float
score0L();


float
score3L();


float
score4L();

float
score4Lc();


float
score9L();


float
score10L();


float
score11L();


float
score12L();


void
fold_loops_with_dunbrack_closure();


void
perturb_loop_with_dunbrack_closure(
	int cutoff9,
	int cutoff3,
	int cutoff1,
	bool fast,
	int loop_num
	);


void
refine_loops_with_dunbrack_closure(
	bool fast,
	bool fix_natsc
	);


#endif
