// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "fragment_class.h"
#include "pose.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>


void Fragment::dimension( const int size_in ) {
	if ( size != size_in ) {
		size = size_in;
		phi      .dimension( size );
		psi      .dimension( size );
		omega    .dimension( size );
		secstruct.dimension( size );
	}
}


bool Fragment::insert( pose_ns::Pose & pose , const int begin ) const {
	bool ok ( true );
	for ( int k=1; k<= size; ++k ) {
		ok = ok && pose.set_phi       ( begin+k-1, phi       (k) );
		ok = ok && pose.set_psi       ( begin+k-1, psi       (k) );
		ok = ok && pose.set_omega     ( begin+k-1, omega     (k) );
		ok = ok && pose.set_secstruct ( begin+k-1, secstruct (k) );
	}
	assert( ok );
	return ok;
}
