// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_fragment_class
#define INCLUDED_fragment_class

// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>
//#include <iostream>
//#include <sstream>
//#include <fstream>

class Fragment {
private:
	int size;
public:
	FArray1D_float phi;
	FArray1D_float psi;
	FArray1D_float omega;
	FArray1D_char secstruct;

	Fragment( const int size_in ):
		size      ( size_in ),
		phi       ( size_in, 0.0),
		psi       ( size_in, 0.0),
		omega     ( size_in, 0.0),
		secstruct ( size_in, 'L')
	{}

	Fragment():
		size(0)
	{}

	void dimension( const int size_in );

	bool insert( pose_ns::Pose & pose , const int begin ) const;

};
#endif

