// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15154 $
//  $Date: 2007-05-25 02:00:33 -0400 (Fri, 25 May 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_fragments_pose
#define INCLUDED_fragments_pose


// Rosetta Headers
#include "pose_fwd.h"
#include "vall_data.h"

// ObjexxFCL Headers

// C++ Headers
#include <string>

void
choose_fragment_pose(
	pose_ns::Pose & pose,
	int const size_in,
	bool const do_ss_check = false,
	bool const do_end_bias_check = false
);


void
choose_fragment_pose(
	pose_ns::Pose & pose,
	int & size,
	int & begin,
	bool const do_ss_check,
	bool const do_end_bias_check
);


bool
end_bias_check(
	pose_ns::Fold_tree const & fold_tree,
	int const begin,
	int const size
);


void
get_frags_by_ss(
	std::string const & target_ss,
	int const begin,
	int const end,
	int const frag_size,
	int const nfrags,
	bool const exclude_gly,
	bool const exclude_pro,
	bool const exclude_cys_peptides,
	int const size_bin
);


void
read_fragments_simple(
	std::string const & frag_name,
	int const frag_nres
);


bool
read_vall(
	const std::string & filename,
	Vall::Vall_data & vall_data
);


void
get_vall_frags(
	std::string const & target_seq,
	std::string const & target_ss,
	std::string const & target_bb,
	float const seq_weight,
	float const ss_weight,
	float const bb_weight,
	int const begin,
	int const end,
	int const frag_size,
	int const nfrags,
	bool const exclude_gly,
	bool const exclude_pro,
	bool const exclude_cys_peptides,
	int const size_bin
);


void
dump_frags(
					 std::string const & filename,
					 int const size,
					 int const first_window,
					 int const last_window
					 );


void
read_frags_new(
							 std::string const & filename,
							 int const size,
							 int const size_bin
							 );
bool
use_weighted_frags();

void
read_fragment_weights();

extern FArray3D_float fragment_weights;

#endif
